/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType32BitUnsignedInteger
extends AbstractContextual
implements DataType<UnsignedIntType> {
    private final UnsignedIntType type = new UnsignedIntType();

    @Override
    public UnsignedIntType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "32-bit uint";
    }

    @Override
    public String longName() {
        return "32-bit unsigned integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between 0 and 4294967295";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(UnsignedIntType dest) {
        dest.set(0L);
    }

    @Override
    public void upperBound(UnsignedIntType dest) {
        dest.set(0xFFFFFFFFL);
    }

    @Override
    public int bitCount() {
        return 32;
    }

    @Override
    public UnsignedIntType createVariable() {
        return new UnsignedIntType();
    }

    @Override
    public void cast(UnsignedIntType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, UnsignedIntType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(UnsignedIntType val) {
        return val.get();
    }

    @Override
    public long asLong(UnsignedIntType val) {
        return val.get();
    }

    @Override
    public void setDouble(UnsignedIntType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(UnsignedIntType val, long v) {
        if (v < 0L) {
            val.set(0L);
        } else if (v > 0xFFFFFFFFL) {
            val.set(0xFFFFFFFFL);
        } else {
            val.set(v);
        }
    }
}

