/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.gui;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.Command;

public final class CommandDescriptions {
    private final Map<Command, DescriptionAndTriggers> descriptions = new LinkedHashMap<Command, DescriptionAndTriggers>();
    private String context;

    public void add(String name, String[] defaultTriggers, String description) {
        Command c = new Command(name, this.context);
        DescriptionAndTriggers cd = new DescriptionAndTriggers(description, defaultTriggers);
        this.descriptions.put(c, cd);
    }

    public void setKeyconfigContext(String context) {
        this.context = context;
    }

    public Map<Command, String> createCommandDescriptionsMap() {
        LinkedHashMap<Command, String> map = new LinkedHashMap<Command, String>();
        this.descriptions.forEach((c, d) -> map.put((Command)c, ((DescriptionAndTriggers)d).description));
        return map;
    }

    public InputTriggerConfig createDefaultKeyconfig() {
        InputTriggerConfig config = new InputTriggerConfig();
        this.descriptions.forEach((c, d) -> {
            String name = c.getName();
            String context = c.getContext();
            String[] triggers = ((DescriptionAndTriggers)d).defaultTriggers;
            if (triggers == null || triggers.length == 0) {
                config.add("not mapped", name, context);
            } else {
                Arrays.stream(triggers).forEachOrdered(t -> config.add((String)t, name, context));
            }
        });
        return config;
    }

    public void augmentInputTriggerConfig(InputTriggerConfig config) {
        this.descriptions.forEach((c, d) -> {
            String context;
            String name = c.getName();
            if (config.getInputs(name, context = c.getContext()).isEmpty()) {
                String[] triggers = ((DescriptionAndTriggers)d).defaultTriggers;
                if (triggers == null || triggers.length == 0) {
                    config.add("not mapped", name, context);
                } else {
                    Arrays.stream(triggers).forEachOrdered(t -> config.add((String)t, name, context));
                }
            }
        });
    }

    public static final class DescriptionAndTriggers {
        private final String description;
        private final String[] defaultTriggers;

        public DescriptionAndTriggers(String description, String[] defaultTriggers) {
            this.description = description;
            this.defaultTriggers = defaultTriggers;
        }
    }
}

