/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public final class ComplexAggregator
extends AggregatorSet<ComplexNumber> {
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> AVERAGE = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private int myCount = 0;
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber.divide(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    ++this.myCount;
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public boolean isMergeable() {
                    return false;
                }

                @Override
                public void merge(ComplexNumber result) {
                    ProgrammingError.throwForIllegalInvocation();
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    ProgrammingError.throwForIllegalInvocation();
                    return null;
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myCount = 0;
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> CARDINALITY = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private int myCount = 0;

                @Override
                public ComplexNumber get() {
                    return ComplexNumber.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, anArg.norm())) {
                        ++this.myCount;
                    }
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myCount += result.intValue();
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> LARGEST = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MAX.invoke(this.myNumber, ComplexFunction.ABS.invoke(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> MAX = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> MIN = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.INFINITY;

                @Override
                public ComplexNumber get() {
                    if (ComplexNumber.isInfinite(this.myNumber)) {
                        return ComplexNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = ComplexFunction.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.INFINITY;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> NORM1 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.norm());
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> NORM2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return ComplexNumber.valueOf(PrimitiveFunction.SQRT.invoke(this.myNumber.norm()));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    double tmpMod = anArg.norm();
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.HYPOT.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> PRODUCT = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ONE;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> PRODUCT2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ONE;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myNumber = this.myNumber.multiply(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SMALLEST = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.INFINITY;

                @Override
                public ComplexNumber get() {
                    if (ComplexNumber.isInfinite(this.myNumber)) {
                        return ComplexNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    if (!ComplexNumber.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = ComplexFunction.MIN.invoke(this.myNumber, ComplexFunction.ABS.invoke(anArg));
                    }
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.INFINITY;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SUM = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.invoke(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<ComplexNumber>> SUM2 = new ThreadLocal<AggregatorFunction<ComplexNumber>>(){

        @Override
        protected AggregatorFunction<ComplexNumber> initialValue() {
            return new ComplexAggregatorFunction(){
                private ComplexNumber myNumber = ComplexNumber.ZERO;

                @Override
                public ComplexNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(ComplexNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public void merge(ComplexNumber result) {
                    this.myNumber = this.myNumber.add(result);
                }

                @Override
                public ComplexNumber merge(ComplexNumber result1, ComplexNumber result2) {
                    return ComplexFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<ComplexNumber> reset() {
                    this.myNumber = ComplexNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ComplexAggregator SET = new ComplexAggregator();

    public static ComplexAggregator getSet() {
        return SET;
    }

    private ComplexAggregator() {
    }

    @Override
    public AggregatorFunction<ComplexNumber> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<ComplexNumber> sum2() {
        return SUM2.get().reset();
    }

    static abstract class ComplexAggregatorFunction
    implements AggregatorFunction<ComplexNumber> {
        ComplexAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((ComplexNumber)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(ComplexNumber.valueOf(anArg));
        }

        @Override
        public final Scalar<ComplexNumber> toScalar() {
            return (Scalar)this.get();
        }
    }
}

