/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.ojalgo.RecoverableCondition;

public interface BasicParser<T> {
    public T parse(String var1) throws RecoverableCondition;

    default public void parse(File file, Consumer<T> consumer) {
        if (file.exists() && file.isFile() && file.canRead()) {
            String tmpPath = file.getPath();
            try {
                if (tmpPath.endsWith(".gz")) {
                    this.parse(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))), consumer);
                } else if (tmpPath.endsWith(".zip")) {
                    this.parse(new InputStreamReader(new ZipInputStream(new FileInputStream(file))), consumer);
                } else {
                    this.parse(new InputStreamReader(new FileInputStream(file)), consumer);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void parse(Reader reader, Consumer<T> consumer) {
        String tmpLine = null;
        Object tmpItem = null;
        try (BufferedReader tmpBufferedReader = new BufferedReader(reader);){
            while ((tmpLine = tmpBufferedReader.readLine()) != null) {
                try {
                    if (tmpLine.length() <= 0 || tmpLine.startsWith("#")) continue;
                    T t = this.parse(tmpLine);
                    tmpItem = t;
                    if (t == null) continue;
                    consumer.accept(tmpItem);
                }
                catch (RecoverableCondition recoverableCondition) {}
            }
            return;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

