/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import java.util.Collection;
import org.renjin.primitives.Indexes;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class AbstractMatrixBuilder<B extends Vector.Builder, V extends Vector> {
    protected final B builder;
    private final int nrows;
    private final int ncols;
    private Vector rowNames = Null.INSTANCE;
    private Vector colNames = Null.INSTANCE;

    public AbstractMatrixBuilder(Vector.Type vectorType, int nrows, int ncols) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.builder = vectorType.newBuilderWithInitialSize(nrows * ncols);
        this.builder.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(nrows, ncols));
    }

    public void setRowNames(Vector names2) {
        this.rowNames = names2;
    }

    public void setRowNames(Collection<String> names2) {
        this.rowNames = new StringArrayVector(names2);
    }

    public void setColNames(Vector names2) {
        this.colNames = names2;
    }

    public void setColNames(Collection<String> names2) {
        this.colNames = new StringArrayVector(names2);
    }

    public int getRows() {
        return this.nrows;
    }

    public int getCols() {
        return this.ncols;
    }

    protected final int computeIndex(int row2, int col2) {
        return Indexes.matrixIndexToVectorIndex(row2, col2, this.nrows, this.ncols);
    }

    public V build() {
        if (this.rowNames != Null.INSTANCE || this.colNames != Null.INSTANCE) {
            this.builder.setAttribute(Symbols.DIMNAMES, (SEXP)new ListVector(this.rowNames, this.colNames));
        }
        return (V)this.builder.build();
    }
}

