/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.renjin.primitives.subset.CompleteSelection;
import org.renjin.primitives.subset.CoordinateMatrixSelection;
import org.renjin.primitives.subset.DimensionSelection;
import org.renjin.primitives.subset.Selection;
import org.renjin.primitives.subset.VectorIndexSelection;
import org.renjin.sexp.SEXP;

public final class SelectionFactory {
    public static Selection fromSubscripts(SEXP source, Iterable<SEXP> subscripts) {
        if (Iterables.isEmpty(subscripts)) {
            return new CompleteSelection(source);
        }
        if (Iterables.size(subscripts) == 1) {
            return SelectionFactory.fromSubscript(source, subscripts.iterator().next());
        }
        return new DimensionSelection(source, Lists.newArrayList(subscripts));
    }

    public static Selection fromSubscript(SEXP source, SEXP subscript) {
        if (CoordinateMatrixSelection.isCoordinateMatrix(source, subscript)) {
            return new CoordinateMatrixSelection(source, subscript);
        }
        return new VectorIndexSelection(source, subscript);
    }
}

