/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.kymograph.linedrawer;

import java.util.Comparator;
import sc.fiji.filamentdetector.kymograph.linedrawer.AbstractLineDrawer;
import sc.fiji.filamentdetector.kymograph.linedrawer.LineDrawer;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.TrackedFilament;

public class LongestFilamentLineDrawer
extends AbstractLineDrawer
implements LineDrawer {
    public static String NAME = "Longest Filament Line Drawer";
    public static String DESCRIPTION = "Look for the longest filament in the track and draw the kymograph based on it.";

    public LongestFilamentLineDrawer() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    @Override
    public double[] draw(TrackedFilament trackedFilament) {
        Filament filament = trackedFilament.stream().max(Comparator.comparing(Filament::getLength)).orElse(null);
        return filament.getTips();
    }
}

