/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import java.util.Collection;
import java.util.Comparator;

class HuffmanNode {
    int tag;
    int tagLength;
    int shift;
    int dataLength;
    boolean absolute;
    private int frequency;
    private HuffmanNode child0;
    private HuffmanNode child1;
    private HuffmanNode mergeNode;
    private boolean merged;
    private boolean unmergeable;
    private boolean cleared;
    static FrequencyComparator frequencyComparator = new FrequencyComparator();
    static TagLengthComparator tagLengthComparator = new TagLengthComparator();

    void clear() {
        this.tag = -1;
        this.tagLength = -1;
        this.shift = -1;
        this.dataLength = -1;
        this.absolute = false;
        this.child0 = null;
        this.child1 = null;
        this.mergeNode = null;
        this.frequency = 0;
        this.merged = false;
        this.unmergeable = false;
        this.cleared = true;
    }

    HuffmanNode() {
        this.clear();
    }

    HuffmanNode(int length, int shift, boolean absolute) {
        this();
        this.set(length, shift, absolute);
    }

    final void set(int length, int shift, boolean absolute) {
        this.dataLength = length;
        this.shift = shift;
        this.absolute = absolute;
        this.cleared = false;
    }

    final boolean cleared() {
        return this.cleared;
    }

    final void addCount() {
        ++this.frequency;
    }

    final boolean hasCount() {
        return this.frequency > 0;
    }

    final boolean tokenEquals(HuffmanNode node) {
        return this.absolute == node.absolute && this.dataLength == node.dataLength && this.shift == node.shift;
    }

    void addChildren(HuffmanNode child0, HuffmanNode child1) {
        this.child0 = child0;
        this.child1 = child1;
        this.frequency = child0.frequency + child1.frequency;
    }

    void collectLeaves(int tag, int tagLength, Collection collection) {
        if (this.child0 == null) {
            this.tag = tag;
            this.tagLength = tagLength;
            collection.add(this);
        } else {
            this.child0.collectLeaves(tag << 1 | 0, tagLength + 1, collection);
            this.child1.collectLeaves(tag << 1 | 1, tagLength + 1, collection);
        }
    }

    boolean mergeInto(HuffmanNode node) {
        if (this.absolute == node.absolute) {
            if (this.dataLength > node.dataLength) {
                node.dataLength = this.dataLength;
            }
            if (this.shift < node.shift) {
                node.shift = this.shift;
            }
            node.frequency += this.frequency;
            this.mergeNode = node;
            this.merged = true;
            return true;
        }
        return false;
    }

    int incrementLength() {
        if (this.shift > 0) {
            --this.shift;
        } else {
            ++this.dataLength;
        }
        return this.dataLength - this.shift;
    }

    final boolean merged() {
        return this.merged;
    }

    final HuffmanNode getMergeNode() {
        return this.mergeNode;
    }

    void setUnmergeable() {
        this.unmergeable = true;
    }

    final boolean unmergeable() {
        return this.unmergeable;
    }

    public String toString() {
        return "shift " + this.shift + " data length " + this.dataLength + (this.absolute ? " absolute " : " relative ") + "\ntag 0x" + Integer.toHexString(this.tag) + " tag length " + this.tagLength + "\nfrequency: " + this.frequency;
    }

    static class TagLengthComparator
    implements Comparator {
        TagLengthComparator() {
        }

        public final int compare(Object o1, Object o2) {
            return ((HuffmanNode)o2).tagLength - ((HuffmanNode)o1).tagLength;
        }
    }

    static class FrequencyComparator
    implements Comparator {
        FrequencyComparator() {
        }

        public final int compare(Object o1, Object o2) {
            return ((HuffmanNode)o1).frequency - ((HuffmanNode)o2).frequency;
        }
    }
}

