/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UUID
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(UUID.class);
    private String value;
    private String fileName;

    public UUID() {
    }

    public UUID(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public UUID(UUID orig) {
        this.value = orig.value;
        this.fileName = orig.fileName;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String value_textContent = element.getTextContent();
        if (value_textContent.trim().length() > 0) {
            this.value = value_textContent;
        }
        if (element.hasAttribute("FileName")) {
            this.setFileName(String.valueOf(element.getAttribute("FileName")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element UUID_element) {
        if (UUID_element == null) {
            UUID_element = document.createElementNS(NAMESPACE, "UUID");
        }
        if (this.value != null) {
            UUID_element.setTextContent(this.value);
        }
        super.asXMLElement(document, UUID_element);
        if (this.fileName != null) {
            UUID_element.setAttribute("FileName", this.fileName);
        }
        return UUID_element;
    }
}

