/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.util.ArrayList;
import java.util.Collection;
import org.scijava.table.Column;
import org.scijava.table.Table;
import org.scijava.table.Tables;
import org.scijava.util.SizableArrayList;

public abstract class AbstractTable<C extends Column<? extends T>, T>
extends SizableArrayList<C>
implements Table<C, T> {
    private final SizableArrayList<String> rowHeaders;
    private int rowCount;

    public AbstractTable() {
        this(0, 0);
    }

    public AbstractTable(int colCount, int rowCount) {
        if (rowCount < 0) {
            throw new IllegalArgumentException("Invalid row count: " + rowCount);
        }
        this.rowHeaders = new SizableArrayList();
        this.rowCount = rowCount;
        this.setColumnCount(colCount);
    }

    @Override
    public void setColumnCount(int colCount) {
        if (colCount < 0) {
            throw new IllegalArgumentException("Invalid column count: " + colCount);
        }
        this.setSize(colCount);
        this.scaleColumns();
    }

    @Override
    public ArrayList<C> insertColumns(int col, int count) {
        Tables.checkCol(this, col, 0);
        int oldColCount = this.getColumnCount();
        int newColCount = oldColCount + count;
        this.setColumnCount(newColCount);
        for (int oldC = oldColCount - 1; oldC >= col; --oldC) {
            int newC = oldC + count;
            this.set(newC, this.get(oldC));
        }
        ArrayList<C> result = new ArrayList<C>(count);
        for (int c = 0; c < count; ++c) {
            C column = this.createColumn(null);
            column.setSize(this.getRowCount());
            result.add(column);
            this.set(col + c, column);
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void setRowCount(int rowCount) {
        if (rowCount < 0) {
            throw new IllegalArgumentException("Invalid row count: " + rowCount);
        }
        this.rowCount = rowCount;
        this.scaleColumns();
    }

    @Override
    public void removeRows(int row, int count) {
        Tables.checkRow(this, row, count);
        int oldRowCount = this.getRowCount();
        int newRowCount = oldRowCount - count;
        for (int oldR = row + count; oldR < oldRowCount; ++oldR) {
            int newR = oldR - count;
            this.setRowHeader(newR, this.getRowHeader(oldR));
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, newR, this.get(c, oldR));
            }
        }
        this.setRowCount(newRowCount);
        if (this.rowHeaders.size() > newRowCount) {
            this.rowHeaders.setSize(newRowCount);
        }
    }

    @Override
    public String getRowHeader(int row) {
        Tables.checkRow(this, row, 1);
        if (this.rowHeaders.size() <= row) {
            return null;
        }
        return (String)this.rowHeaders.get(row);
    }

    @Override
    public void setRowHeader(int row, String header) {
        Tables.checkRow(this, row, 1);
        if (row >= this.rowHeaders.size()) {
            this.rowHeaders.setSize(row + 1);
        }
        this.rowHeaders.set(row, (Object)header);
    }

    @Override
    public void set(String colHeader, int row, T value) {
        int col = Tables.colIndex(this, colHeader);
        Tables.checkRow(this, row, 1);
        Tables.assign((Column)this.get(col), row, value);
    }

    @Override
    public boolean add(C column) {
        if (column != null && column.size() > this.rowCount) {
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.add(column);
    }

    @Override
    public void add(int col, C column) {
        super.add(col, column);
        if (column != null && column.size() > this.rowCount) {
            this.rowCount = column.size();
        }
        this.scaleColumns();
    }

    @Override
    public boolean addAll(Collection<? extends C> c) {
        for (Column column : c) {
            if (column == null || column.size() <= this.rowCount) continue;
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int col, Collection<? extends C> c) {
        for (Column column : c) {
            if (column == null || column.size() <= this.rowCount) continue;
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.addAll(col, c);
    }

    protected abstract C createColumn(String var1);

    private void scaleColumns() {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (this.get(c) == null) {
                this.set(c, this.createColumn(null));
            }
            ((Column)this.get(c)).setSize(this.getRowCount());
        }
    }
}

