/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import ini.trakem2.imaging.P;
import ini.trakem2.io.ImageSaver;
import ini.trakem2.persistence.ImageBytes;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RawMipMaps {
    public static final byte GREY = 1;
    public static final byte GREY_ALPHA = 2;
    public static final byte RGB = 3;
    public static final byte RGBA = 4;
    public static final int HEADER_SIZE = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean save(String path, byte[][] b, int width, int height) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        RandomAccessFile ra = null;
        try {
            ra = new RandomAccessFile(new File(path), "rw");
            byte[] h = new byte[]{(byte)(width >> 24 & 0xFF), (byte)(width >> 16 & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(height >> 24 & 0xFF), (byte)(height >> 16 & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(height & 0xFF), (byte)b.length};
            ra.write(h);
            for (int i = 0; i < b.length; ++i) {
                ra.write(b[i]);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != ra) {
                try {
                    ra.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
        return false;
    }

    public static final ImageBytes load(String path) {
        return RawMipMaps.load(path, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageBytes load(String path, int retry) {
        RandomAccessFile ra = null;
        try {
            File f = new File(path);
            ra = new RandomAccessFile(f, "r");
            byte[] h = new byte[9];
            RawMipMaps.read(ra, h);
            int width = (h[0] & 0xFF) << 24 | (h[1] & 0xFF) << 16 | (h[2] & 0xFF) << 8 | h[3] & 0xFF;
            int height = (h[4] & 0xFF) << 24 | (h[5] & 0xFF) << 16 | (h[6] & 0xFF) << 8 | h[7] & 0xFF;
            int nCh = h[8];
            int chLength = ((int)f.length() - 9) / nCh;
            byte[][] ch = CachingThread.getOrCreateByteArray(nCh, chLength);
            for (int i = 0; i < nCh; ++i) {
                RawMipMaps.read(ra, ch[i]);
            }
            ImageBytes imageBytes = new ImageBytes(ch, width, height);
            return imageBytes;
        }
        catch (FileNotFoundException fnfe) {
            Utils.log2("File not found: " + path);
        }
        catch (Exception e) {
            if (retry < 2) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ImageBytes imageBytes = RawMipMaps.load(path, retry + 1);
                return imageBytes;
            }
            IJError.print(e);
        }
        finally {
            if (null != ra) {
                try {
                    ra.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BufferedImage read(String path) {
        try {
            ImageBytes ib = RawMipMaps.load(path);
            if (null == ib) {
                return null;
            }
            byte[][] ch = ib.c;
            switch (ch.length) {
                case 1: {
                    return ImageSaver.createGrayImage(ch[0], ib.width, ib.height);
                }
            }
            try {
                switch (ch.length) {
                    case 2: {
                        BufferedImage bufferedImage = ImageSaver.createARGBImagePre(P.blendPre(ch[0], ch[1]), ib.width, ib.height);
                        return bufferedImage;
                    }
                    case 3: {
                        BufferedImage bufferedImage = ImageSaver.createRGBImage(P.blend(ch[0], ch[1], ch[2]), ib.width, ib.height);
                        return bufferedImage;
                    }
                    case 4: {
                        BufferedImage bufferedImage = ImageSaver.createARGBImagePre(P.blendPre(ch[0], ch[1], ch[2], ch[3]), ib.width, ib.height);
                        return bufferedImage;
                    }
                }
                return null;
            }
            finally {
                CachingThread.storeForReuse(ch);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    private static final void read(RandomAccessFile ra, byte[] b) throws IOException {
        int r;
        for (int s = 0; s < b.length; s += r) {
            r = ra.read(b, s, b.length - s);
            if (-1 != r) continue;
            return;
        }
    }
}

