/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Selection;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.imaging.StitchingTEM;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Tile;
import mpicbg.models.Transforms;
import mpicbg.trakem2.align.AbstractAffineTile2D;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.ElasticMontage;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.MovingLeastSquaresTransform2;
import mpicbg.trakem2.transform.RigidModel2D;
import mpicbg.trakem2.transform.TransformMesh;
import mpicbg.trakem2.transform.TranslationModel2D;

public final class AlignTask {
    protected static boolean tilesAreInPlace = false;
    protected static boolean sloppyOverlapTest = false;
    protected static boolean largestGraphOnly = false;
    protected static boolean hideDisconnectedTiles = false;
    protected static boolean deleteDisconnectedTiles = false;
    protected static boolean deform = false;
    public static final int LINEAR_PHASE_CORRELATION = 0;
    public static final int LINEAR_SIFT_CORRESPONDENCES = 1;
    public static final int ELASTIC_BLOCK_CORRESPONDENCES = 2;
    protected static int mode = 1;
    private static final String[] modeStrings = new String[]{"phase-correlation", "least squares (linear feature correspondences)", "elastic (non-linear block correspondences)"};
    public static final Align.ParamOptimize p_snap = Align.paramOptimize.clone();

    public static final Bureaucrat alignSelectionTask(final Selection selection) {
        Worker worker = new Worker("Aligning selected images", false, true){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    int m = AlignTask.chooseAlignmentMode();
                    if (-1 == m) {
                        return;
                    }
                    AlignTask.alignSelection(selection, m);
                    Display.repaint(selection.getLayer());
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }

            @Override
            public void cleanup() {
                if (!selection.isEmpty()) {
                    selection.getLayer().getParent().undoOneStep();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, selection.getProject());
    }

    public static final void alignSelection(Selection selection, int m) throws Exception {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Displayable d : selection.getSelected()) {
            if (!(d instanceof Patch)) continue;
            patches.add((Patch)d);
        }
        HashSet<Patch> fixedPatches = new HashSet<Patch>();
        Displayable active = selection.getActive();
        if (null != active && active instanceof Patch) {
            fixedPatches.add((Patch)active);
        }
        for (Patch patch : patches) {
            if (!patch.isLocked()) continue;
            fixedPatches.add(patch);
        }
        AlignTask.alignPatches(patches, fixedPatches, m);
    }

    public static final Bureaucrat alignPatchesTask(final List<Patch> patches, final Set<Patch> fixedPatches) {
        if (0 == patches.size()) {
            Utils.log("Can't align zero patches.");
            return null;
        }
        Worker worker = new Worker("Aligning images", false, true){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    int m = AlignTask.chooseAlignmentMode();
                    if (-1 == m) {
                        return;
                    }
                    AlignTask.alignPatches(patches, fixedPatches, m);
                    Display.repaint();
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }

            @Override
            public void cleanup() {
                ((Patch)patches.get(0)).getLayer().getParent().undoOneStep();
            }
        };
        return Bureaucrat.createAndStart(worker, patches.get(0).getProject());
    }

    private static final int chooseAlignmentMode() {
        int m;
        GenericDialog gdMode = new GenericDialog("Montage mode");
        gdMode.addChoice("mode :", modeStrings, modeStrings[mode]);
        gdMode.showDialog();
        if (gdMode.wasCanceled()) {
            return -1;
        }
        mode = m = gdMode.getNextChoiceIndex();
        return m;
    }

    public static final void alignPatches(List<Patch> patches, Set<Patch> fixedPatches, int m) throws Exception {
        if (patches.size() < 2) {
            Utils.log("No images to align.");
            return;
        }
        for (Patch patch : fixedPatches) {
            if (patches.contains(patch)) continue;
            Utils.log("The list of fixed patches contains at least one Patch not included in the list of patches to align!");
            return;
        }
        if (2 == m) {
            new ElasticMontage().exec(patches, fixedPatches);
        } else if (0 == m) {
            if (!fixedPatches.isEmpty()) {
                Utils.log("Ignoring " + fixedPatches.size() + " fixed patches.");
            }
            StitchingTEM.montageWithPhaseCorrelation(patches);
        } else if (1 == m) {
            if (!Align.paramOptimize.setup("Montage Selection")) {
                return;
            }
            GenericDialog gd = new GenericDialog("Montage Selection: Miscellaneous");
            gd.addCheckbox("tiles are roughly in place", tilesAreInPlace);
            gd.addCheckbox("sloppy overlap test (fast)", sloppyOverlapTest);
            gd.addCheckbox("consider largest graph only", largestGraphOnly);
            gd.addCheckbox("hide tiles from non-largest graph", hideDisconnectedTiles);
            gd.addCheckbox("delete tiles from non-largest graph", deleteDisconnectedTiles);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            tilesAreInPlace = gd.getNextBoolean();
            sloppyOverlapTest = gd.getNextBoolean();
            largestGraphOnly = gd.getNextBoolean();
            hideDisconnectedTiles = gd.getNextBoolean();
            deleteDisconnectedTiles = gd.getNextBoolean();
            Align.ParamOptimize p = Align.paramOptimize.clone();
            AlignTask.alignPatches(p, patches, fixedPatches, tilesAreInPlace, largestGraphOnly, hideDisconnectedTiles, deleteDisconnectedTiles, sloppyOverlapTest);
        } else {
            Utils.log("Don't know how to align with mode " + m);
        }
    }

    public static final Bureaucrat montageLayersTask(final List<Layer> layers) {
        if (null == layers || layers.isEmpty()) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Montaging layers", true){

            @Override
            public void exec() {
                int m = AlignTask.chooseAlignmentMode();
                if (2 == m) {
                    ElasticMontage.Param p = ElasticMontage.setup();
                    if (p == null) {
                        return;
                    }
                    try {
                        AlignTask.montageLayers(p, layers);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Utils.log("Exception during montaging layers.  Operation failed.");
                    }
                } else if (0 == m) {
                    StitchingTEM.montageWithPhaseCorrelation(layers, this);
                } else if (1 == m) {
                    if (!Align.paramOptimize.setup("Montage Layers")) {
                        return;
                    }
                    GenericDialog gd = new GenericDialog("Montage Layers: Miscellaneous");
                    gd.addCheckbox("tiles are roughly in place", tilesAreInPlace);
                    gd.addCheckbox("sloppy overlap test (fast)", sloppyOverlapTest);
                    gd.addCheckbox("consider largest graph only", largestGraphOnly);
                    gd.addCheckbox("hide tiles from non-largest graph", hideDisconnectedTiles);
                    gd.addCheckbox("delete tiles from non-largest graph", deleteDisconnectedTiles);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    tilesAreInPlace = gd.getNextBoolean();
                    sloppyOverlapTest = gd.getNextBoolean();
                    largestGraphOnly = gd.getNextBoolean();
                    hideDisconnectedTiles = gd.getNextBoolean();
                    deleteDisconnectedTiles = gd.getNextBoolean();
                    Align.ParamOptimize p = Align.paramOptimize.clone();
                    AlignTask.montageLayers(p, layers, tilesAreInPlace, largestGraphOnly, hideDisconnectedTiles, deleteDisconnectedTiles, sloppyOverlapTest);
                } else {
                    Utils.log("Don't know how to align with mode " + m);
                }
            }
        }, layers.get(0).getProject());
    }

    public static final void montageLayers(Align.ParamOptimize p, List<Layer> layers, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn, boolean sloppyOverlapTest) {
        int i = 0;
        for (Layer layer : layers) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Displayable> patches = layer.getDisplayables(Patch.class, true);
            if (patches.isEmpty()) continue;
            for (Displayable patch : patches) {
                if (!patch.isLinked() || patch.isOnlyLinkedTo(Patch.class)) continue;
                Utils.log("Cannot montage layer " + layer + "\nReason: at least one Patch is linked to non-image data: " + patch);
            }
            Utils.log("====\nMontaging layer " + layer);
            Utils.showProgress((double)i / (double)layers.size());
            ++i;
            AlignTask.alignPatches(p, new ArrayList<Displayable>(patches), new ArrayList<Patch>(), tilesAreInPlaceIn, largestGraphOnlyIn, hideDisconnectedTilesIn, deleteDisconnectedTilesIn, sloppyOverlapTest);
            Display.repaint(layer);
        }
    }

    public static final void montageLayers(Align.ParamOptimize p, List<Layer> layers, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn) {
        AlignTask.montageLayers(p, layers, tilesAreInPlaceIn, largestGraphOnlyIn, hideDisconnectedTilesIn, deleteDisconnectedTilesIn, false);
    }

    public static final void montageLayers(ElasticMontage.Param p, List<Layer> layers) throws Exception {
        int i = 0;
        block0: for (Layer layer : layers) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Displayable> patches = layer.getDisplayables(Patch.class, true);
            if (patches.isEmpty()) continue;
            ArrayList<Patch> patchesList = new ArrayList<Patch>();
            for (Displayable d : patches) {
                if (!Patch.class.isInstance(d)) continue;
                Patch patch = (Patch)d;
                patchesList.add(patch);
                if (!patch.isLinked() || patch.isOnlyLinkedTo(Patch.class)) continue;
                Utils.log("Cannot montage layer " + layer + "\nReason: at least one Patch is linked to non-image data: " + patch);
                continue block0;
            }
            Utils.log("====\nMontaging layer " + layer);
            Utils.showProgress((double)i / (double)layers.size());
            ++i;
            new ElasticMontage().exec(p, patchesList, new HashSet<Patch>());
            Display.repaint(layer);
        }
    }

    public static final void transformPatchesAndVectorData(final Layer layer, final AffineTransform a) {
        AlignTask.transformPatchesAndVectorData(layer.getDisplayables(Patch.class), new Runnable(){

            @Override
            public void run() {
                layer.apply(Patch.class, a);
            }
        });
    }

    public static final void transformPatchesAndVectorData(final Collection<Patch> patches, final AffineTransform a) {
        AlignTask.transformPatchesAndVectorData(patches, new Runnable(){

            @Override
            public void run() {
                for (Patch p : patches) {
                    p.getAffineTransform().preConcatenate(a);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ReferenceData createTransformPropertiesTable(List<Displayable> src_vdata, List<Displayable> tgt_vdata, final Set<Long> lids_to_operate) {
        if (src_vdata.isEmpty()) {
            return null;
        }
        final HashMap<Long, Patch.TransformProperties> tp = new HashMap<Long, Patch.TransformProperties>();
        final HashMap<Displayable, Map<Long, TreeMap<Integer, Long>>> underlying = new HashMap<Displayable, Map<Long, TreeMap<Integer, Long>>>();
        final HashSet<Long> src_layer_lids_used = new HashSet<Long>();
        int nproc = Runtime.getRuntime().availableProcessors();
        final ThreadPoolExecutor exec = Utils.newFixedThreadPool(nproc, "AlignTask-createTransformPropertiesTable");
        ArrayList dtasks = new ArrayList();
        final ArrayList ltasks = new ArrayList();
        final Thread current = Thread.currentThread();
        try {
            for (int i = src_vdata.size() - 1; i > -1; --i) {
                Displayable tgt_d;
                final Displayable src_d = src_vdata.get(i);
                if (!(src_d instanceof VectorData)) continue;
                Displayable displayable = tgt_d = null == tgt_vdata ? src_d : tgt_vdata.get(i);
                if (!(tgt_d instanceof VectorData)) {
                    Utils.log("WARNING ignoring provided tgt_vdata " + tgt_d + " which is NOT a VectorData instance!");
                    continue;
                }
                if (src_d.getClass() != tgt_d.getClass()) {
                    Utils.log("WARNING src_d and tgt_d are instances of different classes:\n  src_d :: " + src_d + "\n  tgt_d :: " + tgt_d);
                }
                dtasks.add(exec.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashMap under = new HashMap();
                        Map map = underlying;
                        synchronized (map) {
                            underlying.put(tgt_d, under);
                        }
                        if (current.isInterrupted()) {
                            return;
                        }
                        for (Long olid : src_d.getLayerIds()) {
                            Layer la;
                            Area a;
                            long lid = olid;
                            if (!lids_to_operate.contains(lid) || null == (a = src_d.getAreaAt(la = src_d.getLayerSet().getLayer(lid))) || a.isEmpty()) continue;
                            final TreeMap stacked_patch_ids = new TreeMap();
                            HashMap hashMap = under;
                            synchronized (hashMap) {
                                under.put(lid, stacked_patch_ids);
                            }
                            final boolean[] layer_visited = new boolean[]{false};
                            for (final Patch patch : la.getDisplayables(Patch.class, a, true)) {
                                if (current.isInterrupted()) {
                                    return;
                                }
                                try {
                                    ltasks.add(exec.submit(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            if (current.isInterrupted()) {
                                                return;
                                            }
                                            Patch patch2 = patch;
                                            synchronized (patch2) {
                                                Patch.TransformProperties props;
                                                Object object = tp;
                                                synchronized (object) {
                                                    props = (Patch.TransformProperties)tp.get(patch.getId());
                                                }
                                                if (null == props) {
                                                    props = patch.getTransformPropertiesCopy();
                                                    object = tp;
                                                    synchronized (object) {
                                                        tp.put(patch.getId(), props);
                                                    }
                                                }
                                                object = stacked_patch_ids;
                                                synchronized (object) {
                                                    stacked_patch_ids.put(la.indexOf(patch), patch.getId());
                                                }
                                                if (!layer_visited[0]) {
                                                    layer_visited[0] = true;
                                                    object = src_layer_lids_used;
                                                    synchronized (object) {
                                                        src_layer_lids_used.add(la.getId());
                                                    }
                                                }
                                            }
                                        }
                                    }));
                                }
                                catch (Throwable t) {
                                    IJError.print(t);
                                    return;
                                }
                            }
                        }
                    }
                }));
            }
            Utils.wait(dtasks);
            Utils.wait(ltasks);
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        finally {
            exec.shutdownNow();
        }
        return new ReferenceData(tp, underlying, src_layer_lids_used);
    }

    public static final void transformPatchesAndVectorData(Collection<Patch> patches, Runnable alignment) {
        if (patches.isEmpty()) {
            Utils.log("No patches to align!");
            return;
        }
        ArrayList<Displayable> vdata = new ArrayList<Displayable>();
        LayerSet ls = patches.iterator().next().getLayerSet();
        for (Layer layer : ls.getLayers()) {
            vdata.addAll(layer.getDisplayables(VectorData.class, false, true));
        }
        vdata.addAll(ls.getZDisplayables(VectorData.class, true));
        if (vdata.isEmpty()) {
            alignment.run();
            return;
        }
        HashSet<Long> lids = new HashSet<Long>();
        for (Patch p : patches) {
            lids.add(p.getLayer().getId());
        }
        ReferenceData referenceData = AlignTask.createTransformPropertiesTable(vdata, null, lids);
        alignment.run();
        if (null != referenceData && !vdata.isEmpty()) {
            AlignTask.transformVectorData(referenceData, vdata, ls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformVectorData(final ReferenceData rd, Collection<Displayable> vdata, LayerSet target_layerset) {
        ThreadPoolExecutor exec = Utils.newFixedThreadPool("AlignTask-transformVectorData");
        try {
            ArrayList fus = new ArrayList();
            final HashMap<Long, Layer> lidm = new HashMap<Long, Layer>();
            for (Long l : rd.src_layer_lids_used) {
                Layer la = target_layerset.getLayer((long)l);
                if (null == la) {
                    Utils.log("ERROR layer with id " + l + " NOT FOUND in target layerset!");
                    continue;
                }
                lidm.put(l, la);
            }
            for (final Map.Entry entry : rd.underlying.entrySet()) {
                final Displayable d = (Displayable)entry.getKey();
                fus.add(exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry el : ((Map)entry.getValue()).entrySet()) {
                            Layer layer = (Layer)lidm.get(el.getKey());
                            if (null == layer) {
                                Utils.log("ERROR layer with id " + el.getKey() + " NOT FOUND in target layerset!");
                                continue;
                            }
                            ArrayList pids = new ArrayList(((TreeMap)el.getValue()).values());
                            Collections.reverse(pids);
                            Area used_area = new Area();
                            VectorDataTransform vdt = new VectorDataTransform(layer);
                            Iterator iterator = pids.iterator();
                            while (iterator.hasNext()) {
                                mpicbg.trakem2.transform.CoordinateTransform ct;
                                long pid = (Long)iterator.next();
                                DBObject ob = layer.findById(pid);
                                if (null == ob || !(ob instanceof Patch)) {
                                    Utils.log("ERROR layer with id " + layer.getId() + " DOES NOT CONTAIN a Patch with id " + pid);
                                    continue;
                                }
                                Patch patch = (Patch)ob;
                                Patch.TransformProperties props = rd.tp.get(pid);
                                if (null == props) {
                                    Utils.log("ERROR: could not find any Patch.TransformProperties for patch " + patch);
                                    continue;
                                }
                                Area a = new Area(props.area);
                                a.subtract(used_area);
                                if (M.isEmpty(a)) continue;
                                used_area.add(props.area);
                                CoordinateTransformList tlist = new CoordinateTransformList();
                                AffineModel2D aff_inv = new AffineModel2D();
                                try {
                                    aff_inv.set(props.at.createInverse());
                                }
                                catch (NoninvertibleTransformException nite) {
                                    Utils.log("ERROR: could not invert the affine transform for Patch " + patch);
                                    IJError.print(nite);
                                    continue;
                                }
                                tlist.add((CoordinateTransform)aff_inv);
                                if (null != props.ct) {
                                    TransformMesh mesh = new TransformMesh((CoordinateTransform)props.ct, props.meshResolution, (double)props.o_width, (double)props.o_height);
                                    tlist.add((CoordinateTransform)new InverseICT((InvertibleCoordinateTransform)mesh));
                                }
                                if (null != (ct = patch.getCoordinateTransform())) {
                                    tlist.add((CoordinateTransform)ct);
                                    TransformMesh mesh = new TransformMesh((CoordinateTransform)ct, patch.getMeshResolution(), (double)patch.getOWidth(), (double)patch.getOHeight());
                                    Rectangle box = mesh.getBoundingBox();
                                    AffineModel2D aff = new AffineModel2D();
                                    aff.set(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -box.x, -box.y));
                                    tlist.add((CoordinateTransform)aff);
                                }
                                AffineModel2D new_aff = new AffineModel2D();
                                new_aff.set(patch.getAffineTransform());
                                tlist.add((CoordinateTransform)new_aff);
                                vdt.add(a, (CoordinateTransform)tlist);
                            }
                            try {
                                ((VectorData)((Object)d)).apply(vdt);
                            }
                            catch (Exception t) {
                                Utils.log("ERROR transformation failed for " + d + " at layer " + layer);
                                IJError.print(t);
                            }
                        }
                    }
                }));
            }
            Utils.wait(fus);
            Display.repaint();
        }
        finally {
            exec.shutdown();
        }
    }

    public static final void alignPatches(final Align.ParamOptimize p, List<Patch> patches, Collection<Patch> fixedPatches, final boolean tilesAreInPlaceIn, final boolean largestGraphOnlyIn, final boolean hideDisconnectedTilesIn, final boolean deleteDisconnectedTilesIn, final boolean sloppyOverlapTest) {
        final ArrayList tiles = new ArrayList();
        final ArrayList fixedTiles = new ArrayList();
        Align.tilesFromPatches(p, patches, fixedPatches, tiles, fixedTiles);
        AlignTask.transformPatchesAndVectorData(patches, new Runnable(){

            @Override
            public void run() {
                AlignTask.alignTiles(p, tiles, fixedTiles, tilesAreInPlaceIn, largestGraphOnlyIn, hideDisconnectedTilesIn, deleteDisconnectedTilesIn, sloppyOverlapTest);
                Display.repaint();
            }
        });
    }

    public static final void alignPatches(Align.ParamOptimize p, List<Patch> patches, Collection<Patch> fixedPatches, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn) {
        AlignTask.alignPatches(p, patches, fixedPatches, tilesAreInPlaceIn, largestGraphOnlyIn, hideDisconnectedTilesIn, deleteDisconnectedTilesIn, false);
    }

    public static final void alignTiles(Align.ParamOptimize p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>> fixedTiles, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn, boolean sloppyOverlapTest) {
        List<AbstractAffineTile2D<?>> interestingTiles;
        ArrayList<AbstractAffineTile2D<?>[]> tilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
        if (tilesAreInPlaceIn) {
            AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs, sloppyOverlapTest);
        } else {
            AbstractAffineTile2D.pairTiles(tiles, tilePairs);
        }
        Align.connectTilePairs(p, tiles, tilePairs, Runtime.getRuntime().availableProcessors());
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ArrayList graphs = AbstractAffineTile2D.identifyConnectedGraphs(tiles);
        if (largestGraphOnlyIn) {
            Set largestGraph = null;
            for (Set set : graphs) {
                if (largestGraph != null && largestGraph.size() >= set.size()) continue;
                largestGraph = set;
            }
            interestingTiles = new ArrayList();
            for (Tile tile : largestGraph) {
                interestingTiles.add((AbstractAffineTile2D)tile);
            }
            if (hideDisconnectedTilesIn) {
                for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
                    if (interestingTiles.contains((Object)abstractAffineTile2D)) continue;
                    abstractAffineTile2D.getPatch().setVisible(false);
                }
            }
            if (deleteDisconnectedTilesIn) {
                for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
                    if (interestingTiles.contains((Object)abstractAffineTile2D)) continue;
                    abstractAffineTile2D.getPatch().remove(false);
                }
            }
        } else {
            interestingTiles = tiles;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Align.optimizeTileConfiguration(p, interestingTiles, fixedTiles);
        for (AbstractAffineTile2D<?> t : interestingTiles) {
            t.getPatch().getAffineTransform().setTransform(((Affine2D)t.getModel()).createAffine());
        }
        Utils.log("Montage done.");
    }

    public static final void alignTiles(Align.ParamOptimize p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>> fixedTiles, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn) {
        AlignTask.alignTiles(p, tiles, fixedTiles, tilesAreInPlaceIn, largestGraphOnlyIn, hideDisconnectedTilesIn, deleteDisconnectedTilesIn, false);
    }

    public static final Bureaucrat alignMultiLayerMosaicTask(Layer l) {
        return AlignTask.alignMultiLayerMosaicTask(l, null);
    }

    public static final Bureaucrat alignMultiLayerMosaicTask(final Layer l, final Patch nail) {
        Worker worker = new Worker("Aligning multi-layer mosaic", false, true){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    AlignTask.alignMultiLayerMosaic(l, nail);
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, l.getProject());
    }

    public static final void alignMultiLayerMosaic(Layer l, Patch nail) {
        int last;
        ArrayList<Layer> layers = l.getParent().getLayers();
        String[] layerTitles = new String[layers.size()];
        for (int i = 0; i < layers.size(); ++i) {
            layerTitles[i] = l.getProject().findLayerThing(layers.get(i)).toString();
        }
        GenericDialog gd1 = new GenericDialog("Align Multi-Layer Mosaic : Layer Range");
        gd1.addMessage("Layer Range:");
        int sel = l.getParent().indexOf(l);
        gd1.addChoice("first :", layerTitles, layerTitles[sel]);
        gd1.addChoice("last :", layerTitles, layerTitles[sel]);
        gd1.addMessage("Miscellaneous:");
        gd1.addCheckbox("tiles are roughly in place", tilesAreInPlace);
        gd1.addCheckbox("consider largest graph only", largestGraphOnly);
        gd1.addCheckbox("hide tiles from non-largest graph", hideDisconnectedTiles);
        gd1.addCheckbox("delete tiles from non-largest graph", deleteDisconnectedTiles);
        gd1.addCheckbox("deform layers", deform);
        gd1.showDialog();
        if (gd1.wasCanceled()) {
            return;
        }
        int first = gd1.getNextChoiceIndex();
        int d = first < (last = gd1.getNextChoiceIndex()) ? 1 : -1;
        tilesAreInPlace = gd1.getNextBoolean();
        largestGraphOnly = gd1.getNextBoolean();
        hideDisconnectedTiles = gd1.getNextBoolean();
        deleteDisconnectedTiles = gd1.getNextBoolean();
        deform = gd1.getNextBoolean();
        if (!Align.paramOptimize.setup("Align Multi-Layer Mosaic : Intra-Layer")) {
            return;
        }
        Align.ParamOptimize p = Align.paramOptimize.clone();
        Align.ParamOptimize pcp = p.clone();
        if (!Align.param.setup("Align Multi-Layer Mosaic : Cross-Layer")) {
            return;
        }
        Align.Param cp = Align.param.clone();
        pcp.desiredModelIndex = cp.desiredModelIndex;
        ArrayList<Layer> layerRange = new ArrayList<Layer>();
        for (int i = first; i != last + d; i += d) {
            layerRange.add((Layer)layers.get(i));
        }
        AlignTask.alignMultiLayerMosaicTask(layerRange, nail, cp, p, pcp, tilesAreInPlace, largestGraphOnly, hideDisconnectedTiles, deleteDisconnectedTiles, deform);
    }

    private static final boolean alignGraphs(Align.Param p, Layer layer1, Layer layer2, Iterable<Tile<?>> graph1, Iterable<Tile<?>> graph2) {
        Align.Param cp = p.clone();
        Selection selection1 = new Selection(null);
        for (Tile<?> tile : graph1) {
            selection1.add(((AbstractAffineTile2D)tile).getPatch());
        }
        Rectangle graph1Box = selection1.getBox();
        Selection selection2 = new Selection(null);
        for (Tile<?> tile : graph2) {
            selection2.add(((AbstractAffineTile2D)tile).getPatch());
        }
        Rectangle graph2Box = selection2.getBox();
        int maxLength = Math.max(Math.max(Math.max(graph1Box.width, graph1Box.height), graph2Box.width), graph2Box.height);
        cp.sift.maxOctaveSize = Math.min(maxLength, 2 * p.sift.maxOctaveSize);
        double scale = (double)(cp.sift.maxOctaveSize - 1) / (double)maxLength;
        FloatArray2DSIFT sift = new FloatArray2DSIFT(cp.sift);
        SIFT ijSIFT = new SIFT(sift);
        ArrayList features1 = new ArrayList();
        ArrayList features2 = new ArrayList();
        ArrayList candidates = new ArrayList();
        ArrayList inliers = new ArrayList();
        long s = System.currentTimeMillis();
        ijSIFT.extractFeatures(layer1.getProject().getLoader().getFlatImage(layer1, graph1Box, scale, -1, 0, Patch.class, selection1.getSelected(Patch.class), false, Color.GRAY).getProcessor(), features1);
        Utils.log(features1.size() + " features extracted for graphs in layer \"" + layer1.getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
        ijSIFT.extractFeatures(layer2.getProject().getLoader().getFlatImage(layer2, graph2Box, scale, -1, 0, Patch.class, selection2.getSelected(Patch.class), false, Color.GRAY).getProcessor(), features2);
        Utils.log(features2.size() + " features extracted for graphs in layer \"" + layer1.getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
        boolean modelFound = false;
        if (features1.size() > 0 && features2.size() > 0) {
            TranslationModel2D model;
            s = System.currentTimeMillis();
            FeatureTransform.matchFeatures(features1, features2, candidates, (float)cp.rod);
            switch (cp.expectedModelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                default: {
                    return false;
                }
            }
            boolean again = false;
            try {
                do {
                    again = false;
                    modelFound = model.filterRansac(candidates, inliers, 1000, (double)cp.maxEpsilon, (double)cp.minInlierRatio, cp.minNumInliers, 3.0);
                    if (!modelFound || !cp.rejectIdentity) continue;
                    ArrayList points = new ArrayList();
                    PointMatch.sourcePoints(inliers, points);
                    if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)cp.identityTolerance)) continue;
                    IJ.log((String)("Identity transform for " + inliers.size() + " matches rejected."));
                    candidates.removeAll(inliers);
                    inliers.clear();
                    again = true;
                } while (again);
            }
            catch (NotEnoughDataPointsException e) {
                modelFound = false;
            }
            if (modelFound) {
                Utils.log("Model found for graphs in layer \"" + layer1.getTitle() + "\" and \"" + layer2.getTitle() + "\":\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() / scale + " px\n  took " + (System.currentTimeMillis() - s) + " ms");
                AffineTransform b = new AffineTransform();
                b.translate(graph2Box.x, graph2Box.y);
                b.scale(1.0 / scale, 1.0 / scale);
                b.concatenate(model.createAffine());
                b.scale(scale, scale);
                b.translate(-graph1Box.x, -graph1Box.y);
                for (Displayable displayable : selection1.getSelected(Patch.class)) {
                    displayable.getAffineTransform().preConcatenate(b);
                }
                for (Tile tile : graph1) {
                    ((AbstractAffineTile2D)tile).initModel();
                }
                Display.repaint(layer1);
            } else {
                IJ.log((String)("No model found for graphs in layer \"" + layer1.getTitle() + "\" and \"" + layer2.getTitle() + "\":\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - s) + " ms"));
            }
        }
        return modelFound;
    }

    public static final void alignMultiLayerMosaicTask(List<Layer> layerRange, Patch nail, Align.Param cp, Align.ParamOptimize p, Align.ParamOptimize pcp, boolean tilesAreInPlaceIn, boolean largestGraphOnlyIn, boolean hideDisconnectedTilesIn, boolean deleteDisconnectedTilesIn, boolean deformIn) {
        ArrayList allTiles = new ArrayList();
        ArrayList allFixedTiles = new ArrayList();
        ArrayList previousLayerTiles = new ArrayList();
        HashMap<Patch, PointMatch> tileCenterPoints = new HashMap<Patch, PointMatch>();
        HashSet<Patch> fixedPatches = new HashSet<Patch>();
        if (null != nail) {
            fixedPatches.add(nail);
        }
        Layer previousLayer = null;
        for (Layer layer : layerRange) {
            ArrayList<Patch> patches = new ArrayList<Patch>();
            for (Displayable a : layer.getDisplayables(Patch.class, true)) {
                if (!(a instanceof Patch)) continue;
                patches.add((Patch)a);
            }
            ArrayList arrayList = new ArrayList();
            ArrayList fixedTiles = new ArrayList();
            Align.tilesFromPatches(p, patches, fixedPatches, arrayList, fixedTiles);
            AlignTask.alignTiles(p, arrayList, fixedTiles, tilesAreInPlaceIn, false, false, false);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            HashMap<Patch, AbstractAffineTile2D> hashMap = new HashMap<Patch, AbstractAffineTile2D>();
            for (AbstractAffineTile2D t : arrayList) {
                hashMap.put(t.getPatch(), t);
            }
            ArrayList csCurrentLayerTiles = new ArrayList();
            HashSet csFixedTiles = new HashSet();
            Align.tilesFromPatches(cp, patches, fixedPatches, csCurrentLayerTiles, csFixedTiles);
            HashMap tileTiles = new HashMap();
            for (AbstractAffineTile2D abstractAffineTile2D : csCurrentLayerTiles) {
                tileTiles.put(hashMap.get(abstractAffineTile2D.getPatch()), abstractAffineTile2D);
            }
            for (AbstractAffineTile2D abstractAffineTile2D : arrayList) {
                AbstractAffineTile2D csLayerTile = (AbstractAffineTile2D)((Object)tileTiles.get((Object)abstractAffineTile2D));
                csLayerTile.addMatches(abstractAffineTile2D.getMatches());
                for (Tile ct : abstractAffineTile2D.getConnectedTiles()) {
                    csLayerTile.addConnectedTile((Tile)tileTiles.get(ct));
                }
            }
            allFixedTiles.addAll(csFixedTiles);
            ArrayList currentLayerGraphs = AbstractAffineTile2D.identifyConnectedGraphs(csCurrentLayerTiles);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList arrayList2 = AbstractAffineTile2D.identifyConnectedGraphs(allTiles);
            HashMap<Set, Iterator<Tile>> graphGraphs = new HashMap<Set, Iterator<Tile>>();
            for (Set graph : arrayList2) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Iterator<Tile> previousLayerGraph = new HashSet();
                for (Tile tile : previousLayerTiles) {
                    if (!graph.contains(tile)) continue;
                    graphGraphs.put(graph, previousLayerGraph);
                    previousLayerGraph.add(tile);
                }
            }
            Collection previousLayerGraphs = graphGraphs.values();
            ArrayList<AbstractAffineTile2D<?>[]> crossLayerTilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
            for (Set set : currentLayerGraphs) {
                for (Set previousLayerGraph : previousLayerGraphs) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    AlignTask.alignGraphs(cp, layer, previousLayer, set, previousLayerGraph);
                    ArrayList previousLayerGraphTiles = new ArrayList();
                    previousLayerGraphTiles.addAll(previousLayerGraph);
                    ArrayList currentLayerGraphTiles = new ArrayList();
                    currentLayerGraphTiles.addAll(set);
                    AbstractAffineTile2D.pairOverlappingTiles(previousLayerGraphTiles, currentLayerGraphTiles, crossLayerTilePairs);
                }
            }
            Align.connectTilePairs(cp, csCurrentLayerTiles, crossLayerTilePairs, Runtime.getRuntime().availableProcessors());
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            allTiles.addAll(csCurrentLayerTiles);
            previousLayerTiles.clear();
            previousLayerTiles.addAll(csCurrentLayerTiles);
            Align.optimizeTileConfiguration(pcp, allTiles, allFixedTiles);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            for (AbstractAffineTile2D abstractAffineTile2D : allTiles) {
                abstractAffineTile2D.getPatch().setAffineTransform(((Affine2D)abstractAffineTile2D.getModel()).createAffine());
            }
            previousLayer = layer;
        }
        ArrayList graphs = AbstractAffineTile2D.identifyConnectedGraphs(allTiles);
        ArrayList<Object> interestingTiles = new ArrayList<Object>();
        if (largestGraphOnlyIn && (hideDisconnectedTilesIn || deleteDisconnectedTilesIn)) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Set largestGraph = null;
            for (Iterator graph : graphs) {
                if (largestGraph != null && largestGraph.size() >= graph.size()) continue;
                largestGraph = graph;
            }
            HashSet<AbstractAffineTile2D> hashSet = new HashSet<AbstractAffineTile2D>();
            for (Tile tile : largestGraph) {
                hashSet.add((AbstractAffineTile2D)tile);
            }
            if (hideDisconnectedTilesIn) {
                for (AbstractAffineTile2D abstractAffineTile2D : allTiles) {
                    if (hashSet.contains((Object)abstractAffineTile2D)) continue;
                    abstractAffineTile2D.getPatch().setVisible(false);
                }
            }
            if (deleteDisconnectedTilesIn) {
                for (AbstractAffineTile2D abstractAffineTile2D : allTiles) {
                    if (hashSet.contains((Object)abstractAffineTile2D)) continue;
                    abstractAffineTile2D.getPatch().remove(false);
                }
            }
            interestingTiles.addAll(hashSet);
        } else {
            interestingTiles.addAll(allTiles);
        }
        if (deformIn) {
            Utils.log("deforming...");
            for (AbstractAffineTile2D abstractAffineTile2D : interestingTiles) {
                double[] c = new double[]{abstractAffineTile2D.getWidth() / 2.0, abstractAffineTile2D.getHeight() / 2.0};
                abstractAffineTile2D.getModel().applyInPlace(c);
                Point point = new Point(c);
                tileCenterPoints.put(abstractAffineTile2D.getPatch(), new PointMatch(point.clone(), point));
            }
            for (Layer layer : layerRange) {
                Utils.log("layer" + layer);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ArrayList<Patch> patches = new ArrayList<Patch>();
                for (Displayable a : layer.getDisplayables(Patch.class)) {
                    if (!(a instanceof Patch)) continue;
                    patches.add((Patch)a);
                }
                ArrayList arrayList = new ArrayList();
                ArrayList fixedTiles = new ArrayList();
                Align.tilesFromPatches(p, patches, fixedPatches, arrayList, fixedTiles);
                allFixedTiles.addAll(fixedTiles);
                AlignTask.alignTiles(p, arrayList, fixedTiles, true, false, false, false);
                ArrayList currentLayerGraphs = AbstractAffineTile2D.identifyConnectedGraphs(arrayList);
                for (Set graph : currentLayerGraphs) {
                    ArrayList<PointMatch> arrayList3 = new ArrayList<PointMatch>();
                    ArrayList<AbstractAffineTile2D> toBeDeformedTiles = new ArrayList<AbstractAffineTile2D>();
                    for (AbstractAffineTile2D t : graph) {
                        PointMatch pm = (PointMatch)tileCenterPoints.get(t.getPatch());
                        if (pm == null) continue;
                        double[] dArray = pm.getP1().getL();
                        dArray[0] = t.getWidth() / 2.0;
                        dArray[1] = t.getHeight() / 2.0;
                        t.getModel().applyInPlace(dArray);
                        arrayList3.add(pm);
                        toBeDeformedTiles.add(t);
                    }
                    for (AbstractAffineTile2D t : toBeDeformedTiles) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        try {
                            Patch patch = t.getPatch();
                            Rectangle rectangle = patch.getCoordinateTransformBoundingBox();
                            AffineTransform affineTransform = new AffineTransform();
                            affineTransform.translate(-rectangle.x, -rectangle.y);
                            affineTransform.preConcatenate(patch.getAffineTransform());
                            mpicbg.trakem2.transform.AffineModel2D toWorld = new mpicbg.trakem2.transform.AffineModel2D();
                            toWorld.set(affineTransform);
                            MovingLeastSquaresTransform2 mlst = Align.createMLST(arrayList3, 1.0);
                            CoordinateTransformList ctl = new CoordinateTransformList();
                            ctl.add((CoordinateTransform)toWorld);
                            ctl.add((CoordinateTransform)mlst);
                            ctl.add((CoordinateTransform)toWorld.createInverse());
                            patch.appendCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
                            patch.getProject().getLoader().regenerateMipMaps(patch);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        layerRange.get(0).getParent().setMinimumDimensions();
        IJ.log((String)"Done: register multi-layer mosaic.");
    }

    public static final Bureaucrat snap(final Patch patch, final Align.ParamOptimize p_snapIn, final boolean setup) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Snapping", true){

            @Override
            public void exec() {
                Align.ParamOptimize p;
                Align.ParamOptimize paramOptimize = p = null == p_snapIn ? p_snap : p_snapIn;
                if (setup) {
                    p.setup("Snap");
                }
                ArrayList<Displayable> linked_images = new ArrayList<Displayable>();
                for (Displayable d : patch.getLinkedGroup(null)) {
                    if (d.getClass() != Patch.class || d == patch) continue;
                    linked_images.add(d);
                }
                ArrayList<Patch> overlapping = new ArrayList<Patch>(patch.getLayer().getIntersecting(patch, Patch.class));
                overlapping.remove(patch);
                if (0 == overlapping.size()) {
                    return;
                }
                overlapping.removeAll(linked_images);
                if (0 == overlapping.size()) {
                    Utils.log("Cannot snap: overlapping images are linked to the one to snap.");
                    return;
                }
                linked_images.clear();
                Rectangle box = patch.getBoundingBox(null);
                Patch most = null;
                Rectangle most_inter = null;
                for (Patch other : overlapping) {
                    if (null == most) {
                        most = other;
                        most_inter = other.getBoundingBox();
                        continue;
                    }
                    Rectangle inter = other.getBoundingBox().intersection(box);
                    if (inter.width * inter.height <= most_inter.width * most_inter.height) continue;
                    most = other;
                    most_inter = inter;
                }
                overlapping.clear();
                ArrayList<Patch> patches = new ArrayList<Patch>();
                patches.add(most);
                patches.add(patch);
                ArrayList<Patch> fixedPatches = new ArrayList<Patch>();
                fixedPatches.add(most);
                ArrayList tiles = new ArrayList();
                ArrayList fixedTiles = new ArrayList();
                Align.tilesFromPatches(p, patches, fixedPatches, tiles, fixedTiles);
                ArrayList<AbstractAffineTile2D<?>[]> tilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
                AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs);
                Align.connectTilePairs(p, tiles, tilePairs, Runtime.getRuntime().availableProcessors());
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Align.optimizeTileConfiguration(p, tiles, fixedTiles);
                for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
                    if (abstractAffineTile2D.getPatch() != patch) continue;
                    AffineTransform at = ((Affine2D)abstractAffineTile2D.getModel()).createAffine();
                    try {
                        at.concatenate(patch.getAffineTransform().createInverse());
                        patch.transform(at);
                    }
                    catch (NoninvertibleTransformException nite) {
                        IJError.print(nite);
                    }
                    break;
                }
                Display.repaint();
            }
        }, patch.getProject());
    }

    public static final Bureaucrat registerStackSlices(final Patch slice) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Registering slices", true){

            @Override
            public void exec() {
                ArrayList<Patch> slices = slice.getStackPatches();
                if (slices.size() < 2) {
                    Utils.log2("Not a stack!");
                    return;
                }
                for (Patch patch : slices) {
                    if (patch.isOnlyLinkedTo(Patch.class)) continue;
                    Utils.log("Can't register: one or more slices are linked to objects other than images.");
                    return;
                }
                Align.ParamOptimize p = Align.paramOptimize.clone();
                p.setup("Register stack slices");
                ArrayList<Patch> fixedSlices = new ArrayList<Patch>();
                fixedSlices.add(slice);
                AlignTask.alignPatches(p, slices, fixedSlices, false, false, false, false);
                Display.repaint();
            }
        }, slice.getProject());
    }

    public static final class ReferenceData {
        final Map<Long, Patch.TransformProperties> tp;
        final Map<Displayable, Map<Long, TreeMap<Integer, Long>>> underlying;
        final Set<Long> src_layer_lids_used;

        ReferenceData(Map<Long, Patch.TransformProperties> tp, Map<Displayable, Map<Long, TreeMap<Integer, Long>>> underlying, Set<Long> src_layer_lids_used) {
            this.tp = tp;
            this.underlying = underlying;
            this.src_layer_lids_used = src_layer_lids_used;
        }
    }

    private static final class InverseICT
    implements InvertibleCoordinateTransform {
        final InvertibleCoordinateTransform ict;

        InverseICT(InvertibleCoordinateTransform ict) {
            this.ict = ict;
        }

        public final double[] apply(double[] p) {
            double[] q = (double[])p.clone();
            this.applyInPlace(q);
            return q;
        }

        public final double[] applyInverse(double[] p) {
            double[] q = (double[])p.clone();
            this.applyInverseInPlace(q);
            return q;
        }

        public final void applyInPlace(double[] p) {
            try {
                this.ict.applyInverseInPlace(p);
            }
            catch (NoninvertibleModelException e) {
                Utils.log2("Point outside mesh: " + p[0] + ", " + p[1]);
            }
        }

        public final void applyInverseInPlace(double[] p) {
            this.ict.applyInPlace(p);
        }

        public final mpicbg.trakem2.transform.InvertibleCoordinateTransform createInverse() {
            return null;
        }
    }
}

