/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.optional;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import org.scijava.optional.Options;
import org.scijava.optional.Values;

public abstract class AbstractOptions<T extends AbstractOptions<T>>
implements Options<T> {
    final LinkedHashMap<String, Object> theOptions = new LinkedHashMap();

    protected AbstractOptions(T that) {
        this.theOptions.putAll(((AbstractOptions)that).theOptions);
    }

    public AbstractOptions() {
    }

    protected T copyOrThis() {
        return (T)this;
    }

    protected T append(T additionalOptions) {
        if (additionalOptions == null) {
            return (T)this;
        }
        T concat = this.copyOrThis();
        ((AbstractOptions)additionalOptions).theOptions.forEach((k, v) -> {
            concat.theOptions.remove(k);
            concat.theOptions.put((String)k, v);
        });
        return concat;
    }

    @Override
    public T setValue(String key, Object value) {
        T copy = this.copyOrThis();
        ((AbstractOptions)copy).theOptions.remove(key);
        ((AbstractOptions)copy).theOptions.put(key, value);
        return copy;
    }

    public String toString() {
        ValuesToString sb = new ValuesToString();
        this.theOptions.forEach(sb);
        return sb.toString();
    }

    private static String valueToString(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return String.valueOf(value);
    }

    protected class ValuesToString
    implements BiConsumer<String, Object> {
        private final StringBuilder sb = new StringBuilder().append("{");
        private boolean first = true;

        public String toString() {
            this.sb.append("}");
            return this.sb.toString();
        }

        @Override
        public void accept(String key, Object value) {
            if (this.first) {
                this.first = false;
            } else {
                this.sb.append(", ");
            }
            this.sb.append(key);
            this.sb.append(" = ");
            this.sb.append(AbstractOptions.valueToString(value));
            if (!AbstractOptions.this.theOptions.containsKey(key)) {
                this.sb.append(" [default]");
            }
        }
    }

    protected abstract class AbstractValues
    implements Values {
        protected AbstractValues() {
        }

        public void forEach(BiConsumer<String, Object> action) {
            AbstractOptions.this.theOptions.forEach(action);
        }

        public String toString() {
            ValuesToString sb = new ValuesToString();
            this.forEach(sb);
            return sb.toString();
        }

        @Override
        public <T> T getValueOrDefault(String key, T defaultValue) {
            return (T)(AbstractOptions.this.theOptions.containsKey(key) ? AbstractOptions.this.theOptions.get(key) : defaultValue);
        }
    }
}

