/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import sc.fiji.coloc.algorithms.Stepper;

public class SimpleStepper
extends Stepper {
    double threshold;
    double lastThreshold;
    double currentValue;
    double lastValue;
    boolean finished = false;

    public SimpleStepper(double threshold) {
        this.threshold = threshold;
        this.currentValue = 1.0;
        this.lastValue = Double.MAX_VALUE;
    }

    @Override
    public void update(double value) {
        if (!this.finished) {
            this.lastValue = this.currentValue;
            this.currentValue = value;
            this.threshold -= 1.0;
            this.finished = Double.NaN == value || this.threshold < 1.0 || value < 1.0E-4 || value > this.lastValue;
        }
    }

    @Override
    public double getValue() {
        return this.threshold;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

