/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import ij.IJ;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.Java3d;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3d;

public class MappingFusionSequentialDifferentOutput
extends SPIMImageFusion {
    final Image<FloatType>[] fusedImages;
    final int numViews;
    final int numParalellStacks;
    public static int[] angleIndiciesStatic = null;
    public int[] angleIndicies = null;

    public MappingFusionSequentialDifferentOutput(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories, int numParalellStacks) {
        super(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories);
        this.numViews = viewStructure.getNumViews();
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused images.");
        }
        if (angleIndiciesStatic == null) {
            this.angleIndicies = new int[this.numViews];
            for (int view = 0; view < this.numViews; ++view) {
                this.angleIndicies[view] = view;
            }
        } else {
            if (viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WARNING: Using statically defined angle-indices from class mpicbg.spim.fusion.MappingFusionSequentialDifferentOutput: " + Util.printCoordinates((int[])this.angleIndicies));
            }
            this.angleIndicies = (int[])angleIndiciesStatic.clone();
        }
        this.numParalellStacks = numParalellStacks;
        IJ.log((String)("nump = " + numParalellStacks));
        this.fusedImages = new Image[this.angleIndicies.length];
        ImageFactory fusedImageFactory = new ImageFactory((Type)new FloatType(), this.conf.processImageFactory);
        long size = 4L * (long)this.imgW * (long)this.imgH * (long)this.imgD / 1000000L;
        for (int i = 0; i < this.angleIndicies.length; ++i) {
            if (viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving " + size + " MiB for '" + viewStructure.getViews().get(this.angleIndicies[i]).getName() + "'");
            }
            this.fusedImages[i] = fusedImageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "Fused image");
            if (this.fusedImages[i] != null || viewStructure.getDebugLevel() > 2) continue;
            IOFunctions.printErr("MappingFusionSequentialDifferentOutput.constructor: Cannot create output image: " + this.conf.processImageFactory.getErrorMessage());
        }
    }

    @Override
    public void fuseSPIMImages(int channelIndex) {
        if (channelIndex > 0) {
            return;
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Unloading source images.");
        }
        final ArrayList<ViewDataBeads> views = this.viewStructure.getViews();
        final int numViews = this.angleIndicies.length;
        for (ViewDataBeads view : views) {
            view.closeImage();
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing output image.");
        }
        for (int v = 0; v < this.angleIndicies.length; v += this.numParalellStacks) {
            final int viewIndexStart = v;
            final int viewIndexEnd = Math.min(v + this.numParalellStacks, numViews);
            for (int viewIndex = viewIndexStart; viewIndex < viewIndexEnd; ++viewIndex) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading view: " + views.get(this.angleIndicies[viewIndex]).getName());
                }
                views.get(this.angleIndicies[viewIndex]).getImage(false);
            }
            final AtomicInteger ai = new AtomicInteger(0);
            Thread[] threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
            final int numThreads = threads.length;
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        for (int viewIndex = viewIndexStart; viewIndex < viewIndexEnd; ++viewIndex) {
                            LocalizableCursor iteratorFused;
                            Interpolator interpolator;
                            ViewDataBeads view;
                            block12: {
                                if (viewIndex % numThreads != myNumber) continue;
                                view = (ViewDataBeads)views.get(MappingFusionSequentialDifferentOutput.this.angleIndicies[viewIndex]);
                                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing individual registered image for '" + view.getName() + "'");
                                if (Math.max(view.getTile().getConnectedTiles().size(), view.getViewErrorStatistics().getNumConnectedViews()) <= 0 && view.getViewStructure().getNumViews() > 1) {
                                    if (MappingFusionSequentialDifferentOutput.this.viewStructure.getDebugLevel() > 2) continue;
                                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Cannot use view '" + view.getName() + ", view is not connected to any other view.");
                                    continue;
                                }
                                Image<FloatType> img = view.getImage(MappingFusionSequentialDifferentOutput.this.conf.inputImageFactory, false);
                                interpolator = img.createInterpolator(MappingFusionSequentialDifferentOutput.this.conf.interpolatorFactorOutput);
                                Point3d tmpCoordinates = new Point3d();
                                int[] imageSize = view.getImageSize();
                                int w = imageSize[0];
                                int h = imageSize[1];
                                int d = imageSize[2];
                                AbstractAffineModel3D model = (AbstractAffineModel3D)view.getTile().getModel();
                                double[] tmp = new double[3];
                                CombinedPixelWeightener[] combW = new CombinedPixelWeightener[MappingFusionSequentialDifferentOutput.this.combinedWeightenerFactories.size()];
                                for (int i = 0; i < combW.length; ++i) {
                                    combW[i] = ((CombinedPixelWeightenerFactory)MappingFusionSequentialDifferentOutput.this.combinedWeightenerFactories.get(i)).createInstance(views);
                                }
                                double[][] loc = new double[numViews][3];
                                boolean[] use = new boolean[numViews];
                                for (int v = 0; v < numViews; ++v) {
                                    use[v] = true;
                                    for (int i = 0; i < 3; ++i) {
                                        loc[v][i] = MappingFusionSequentialDifferentOutput.this.viewStructure.getViews().get(v).getImageSize()[i] / 2;
                                    }
                                }
                                if (MappingFusionSequentialDifferentOutput.this.viewStructure.getDebugLevel() <= 1) {
                                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting fusion for: " + view.getName());
                                }
                                iteratorFused = MappingFusionSequentialDifferentOutput.this.fusedImages[viewIndex].createLocalizableCursor();
                                try {
                                    while (iteratorFused.hasNext()) {
                                        iteratorFused.next();
                                        int x = iteratorFused.getPosition(0) + MappingFusionSequentialDifferentOutput.this.cropOffsetX;
                                        int y = iteratorFused.getPosition(1) + MappingFusionSequentialDifferentOutput.this.cropOffsetY;
                                        int z = iteratorFused.getPosition(2) + MappingFusionSequentialDifferentOutput.this.cropOffsetZ;
                                        tmpCoordinates.x = (float)(x * MappingFusionSequentialDifferentOutput.this.scale) + MappingFusionSequentialDifferentOutput.this.min.x;
                                        tmpCoordinates.y = (float)(y * MappingFusionSequentialDifferentOutput.this.scale) + MappingFusionSequentialDifferentOutput.this.min.y;
                                        tmpCoordinates.z = (float)(z * MappingFusionSequentialDifferentOutput.this.scale) + MappingFusionSequentialDifferentOutput.this.min.z;
                                        Java3d.applyInverseInPlace(model, tmpCoordinates, tmp);
                                        int locX = (int)Util.round((double)tmpCoordinates.x);
                                        int locY = (int)Util.round((double)tmpCoordinates.y);
                                        int locZ = (int)Util.round((double)tmpCoordinates.z);
                                        if (locX < 0 || locY < 0 || locZ < 0 || locX >= w || locY >= h || locZ >= d) continue;
                                        float weight = 1.0f;
                                        if (combW.length > 0) {
                                            loc[viewIndex][0] = tmpCoordinates.x;
                                            loc[viewIndex][1] = tmpCoordinates.y;
                                            loc[viewIndex][2] = tmpCoordinates.z;
                                            for (CombinedPixelWeightener we : combW) {
                                                we.updateWeights(loc, use);
                                            }
                                            for (CombinedPixelWeightener we : combW) {
                                                weight = (float)((double)weight * we.getWeight(viewIndex));
                                            }
                                        }
                                        tmp[0] = tmpCoordinates.x;
                                        tmp[1] = tmpCoordinates.y;
                                        tmp[2] = tmpCoordinates.z;
                                        interpolator.setPosition(tmp);
                                        float intensity = ((FloatType)interpolator.getType()).get();
                                        ((FloatType)iteratorFused.getType()).set(intensity * weight);
                                    }
                                }
                                catch (NoninvertibleModelException e) {
                                    if (MappingFusionSequentialDifferentOutput.this.viewStructure.getDebugLevel() > 2) break block12;
                                    IOFunctions.println("MappingFusionSequentialDifferentOutput(): Model not invertible for " + MappingFusionSequentialDifferentOutput.this.viewStructure);
                                }
                            }
                            iteratorFused.close();
                            interpolator.close();
                            view.closeImage();
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Done computing output image.");
        }
    }

    @Override
    public Image<FloatType> getFusedImage() {
        return this.fusedImages[0];
    }

    public Image<FloatType> getFusedImage(int index) {
        return this.fusedImages[index];
    }

    @Override
    public boolean saveAsTiffs(String dir, String name, int channelIndex) {
        if (channelIndex > 0) {
            return true;
        }
        boolean success = true;
        for (int i = 0; i < this.fusedImages.length; ++i) {
            ViewDataBeads view = this.viewStructure.getViews().get(this.angleIndicies[i]);
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saving '" + name + "_ch" + view.getChannel() + "_angle" + view.getAcqusitionAngle() + "'");
            }
            success &= ImageJFunctions.saveAsTiffs(this.fusedImages[i], (String)dir, (String)(name + "_ch" + view.getChannel() + "_angle" + view.getAcqusitionAngle()), (int)2);
        }
        return success;
    }

    @Override
    public void closeImages() {
        for (int i = 0; i < this.fusedImages.length; ++i) {
            this.fusedImages[i].close();
        }
    }
}

