/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution;

import fiji.plugin.Multi_View_Deconvolution;
import ij.IJ;
import java.util.ArrayList;
import java.util.List;
import mpicbg.imglib.algorithm.transformation.ImageTransform;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyPeriodicFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.CoordinateTransform;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadRegistration;

public class ExtractPSF {
    final ViewStructure viewStructure;
    final ArrayList<Image<FloatType>> pointSpreadFunctions;
    final ArrayList<Image<FloatType>> originalPSFs;
    Image<FloatType> avgPSF;
    Image<FloatType> avgOriginalPSF;
    final SPIMConfiguration conf;
    int[] size3d = null;
    int size = 17;
    boolean isotropic = false;

    public ExtractPSF(SPIMConfiguration config) {
        ViewStructure viewStructure = ViewStructure.initViewStructure(config, 0, new AffineModel3D(), "ViewStructure Timepoint 0", config.debugLevelInt);
        for (ViewDataBeads view : viewStructure.getViews()) {
            view.loadDimensions();
            view.loadSegmentation();
            view.loadRegistration();
            BeadRegistration.concatenateAxialScaling(view, 1);
        }
        this.viewStructure = viewStructure;
        this.pointSpreadFunctions = new ArrayList();
        this.originalPSFs = new ArrayList();
        this.conf = config;
        this.setPSFSize(Multi_View_Deconvolution.psfSize, Multi_View_Deconvolution.isotropic, Multi_View_Deconvolution.psfSize3d);
    }

    public ExtractPSF(ViewStructure viewStructure) {
        this.viewStructure = viewStructure;
        this.pointSpreadFunctions = new ArrayList();
        this.originalPSFs = new ArrayList();
        this.conf = viewStructure.getSPIMConfiguration();
        this.setPSFSize(Multi_View_Deconvolution.psfSize, Multi_View_Deconvolution.isotropic, Multi_View_Deconvolution.psfSize3d);
    }

    public void setPSFSize(int size, boolean isotropic, int[] size3d) {
        this.size = size;
        this.isotropic = isotropic;
        this.size3d = size3d;
    }

    public ArrayList<Image<FloatType>> getPSFs() {
        return this.pointSpreadFunctions;
    }

    public ArrayList<Image<FloatType>> getPSFsInInputCalibration() {
        return this.originalPSFs;
    }

    public Image<FloatType> getAveragePSF() {
        return this.avgPSF;
    }

    public Image<FloatType> getAverageOriginalPSF() {
        return this.avgOriginalPSF;
    }

    public Image<FloatType> getMaxProjectionAveragePSF() {
        int[] dimensions = this.avgPSF.getDimensions();
        int minSize = dimensions[0];
        int minDim = 0;
        for (int d = 0; d < dimensions.length; ++d) {
            if (this.avgPSF.getDimension(d) >= minSize) continue;
            minSize = this.avgPSF.getDimension(d);
            minDim = d;
        }
        int[] projDim = new int[dimensions.length - 1];
        int dim = 0;
        int sizeProjection = 0;
        for (int d = 0; d < dimensions.length; ++d) {
            if (d != minDim) {
                projDim[dim++] = dimensions[d];
                continue;
            }
            sizeProjection = dimensions[d];
        }
        Image proj = this.avgPSF.getImageFactory().createImage(projDim);
        LocalizableByDimCursor psfIterator = this.avgPSF.createLocalizableByDimCursor();
        LocalizableCursor projIterator = proj.createLocalizableCursor();
        int[] tmp = new int[this.avgPSF.getNumDimensions()];
        while (projIterator.hasNext()) {
            projIterator.fwd();
            dim = 0;
            for (int d = 0; d < dimensions.length; ++d) {
                if (d == minDim) continue;
                tmp[d] = projIterator.getPosition(dim++);
            }
            tmp[minDim] = -1;
            float maxValue = -3.4028235E38f;
            psfIterator.setPosition(tmp);
            for (int i = 0; i < sizeProjection; ++i) {
                psfIterator.fwd(minDim);
                float value = ((FloatType)psfIterator.getType()).get();
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
            ((FloatType)projIterator.getType()).set(maxValue);
        }
        proj.setName("MIP of PSF's of " + this.viewStructure.getID());
        return proj;
    }

    public void computeAveragePSF(int[] maxSize) {
        int numDimensions = maxSize.length;
        IJ.log((String)("maxSize: " + Util.printCoordinates((int[])maxSize)));
        this.avgPSF = this.pointSpreadFunctions.get(0).createNewImage(maxSize);
        int[] avgCenter = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            avgCenter[d] = this.avgPSF.getDimension(d) / 2;
        }
        for (Image<FloatType> psf : this.pointSpreadFunctions) {
            int d;
            LocalizableByDimCursor avgCursor = this.avgPSF.createLocalizableByDimCursor();
            LocalizableCursor psfCursor = psf.createLocalizableCursor();
            int[] loc = new int[numDimensions];
            int[] psfCenter = new int[numDimensions];
            for (d = 0; d < numDimensions; ++d) {
                psfCenter[d] = psf.getDimension(d) / 2;
            }
            while (psfCursor.hasNext()) {
                psfCursor.fwd();
                psfCursor.getPosition(loc);
                for (d = 0; d < numDimensions; ++d) {
                    loc[d] = psfCenter[d] - loc[d] + avgCenter[d];
                }
                avgCursor.moveTo(loc);
                ((FloatType)avgCursor.getType()).add((FloatType)psfCursor.getType());
            }
            avgCursor.close();
            psfCursor.close();
        }
        this.avgPSF.getDisplay().setMinMax();
        this.avgPSF.setName("PSF's of " + this.viewStructure.getID());
        this.avgOriginalPSF = this.originalPSFs.get(0).createNewImage();
        try {
            for (Image<FloatType> psf : this.originalPSFs) {
                Cursor cursor = psf.createCursor();
                for (FloatType t : this.avgOriginalPSF) {
                    t.add((FloatType)cursor.next());
                }
            }
        }
        catch (Exception e) {
            IOFunctions.printErr("Input PSFs were most likely of different size ... not computing average image in original scale.");
            e.printStackTrace();
        }
        this.avgOriginalPSF.getDisplay().setMinMax();
        this.avgOriginalPSF.setName("(original scale) PSF's of " + this.viewStructure.getID());
    }

    public void extract(int viewID, int[] maxSize) {
        int[] size;
        ArrayList<ViewDataBeads> views = this.viewStructure.getViews();
        int numDimensions = 3;
        if (this.size3d == null) {
            size = Util.getArrayFromValue((int)this.size, (int)3);
            if (!this.isotropic) {
                size[2] = (int)((double)size[2] * Math.max(1.0, 5.0 / views.get(0).getZStretching()));
                if (size[2] % 2 == 0) {
                    size[2] = size[2] + 1;
                }
            }
        } else {
            size = (int[])this.size3d.clone();
        }
        IJ.log((String)("PSF size: " + Util.printCoordinates((int[])size)));
        ViewDataBeads view = views.get(viewID);
        Image<FloatType> originalPSF = ExtractPSF.extractPSF(view, size);
        Image<FloatType> psf = ExtractPSF.transformPSF(originalPSF, (AbstractAffineModel3D)view.getTile().getModel());
        psf.setName("PSF_" + view.getName());
        for (int d = 0; d < 3; ++d) {
            if (psf.getDimension(d) <= maxSize[d]) continue;
            maxSize[d] = psf.getDimension(d);
        }
        this.pointSpreadFunctions.add(psf);
        this.originalPSFs.add(originalPSF);
        psf.getDisplay().setMinMax();
    }

    public void extract() {
        int[] size;
        ArrayList<ViewDataBeads> views = this.viewStructure.getViews();
        int numDimensions = 3;
        if (this.size3d == null) {
            size = Util.getArrayFromValue((int)this.size, (int)3);
            if (!this.isotropic) {
                size[2] = (int)((double)size[2] * Math.max(1.0, 5.0 / views.get(0).getZStretching()));
                if (size[2] % 2 == 0) {
                    size[2] = size[2] + 1;
                }
            }
        } else {
            size = (int[])this.size3d.clone();
        }
        IJ.log((String)("PSF size: " + Util.printCoordinates((int[])size)));
        int[] maxSize = new int[3];
        for (int d = 0; d < 3; ++d) {
            maxSize[d] = 0;
        }
        for (ViewDataBeads view : views) {
            Image<FloatType> originalPSF = ExtractPSF.extractPSF(view, size);
            Image<FloatType> psf = ExtractPSF.transformPSF(originalPSF, (AbstractAffineModel3D)view.getTile().getModel());
            psf.setName("PSF_" + view.getName());
            for (int d = 0; d < 3; ++d) {
                if (psf.getDimension(d) <= maxSize[d]) continue;
                maxSize[d] = psf.getDimension(d);
            }
            this.pointSpreadFunctions.add(psf);
            this.originalPSFs.add(originalPSF);
            psf.getDisplay().setMinMax();
        }
        this.computeAveragePSF(maxSize);
    }

    protected static Image<FloatType> transformPSF(Image<FloatType> psf, AbstractAffineModel3D<?> model) {
        int d;
        int numDimensions = psf.getNumDimensions();
        float[][] minMaxDim = ExtractPSF.getMinMaxDim(psf.getDimensions(), model);
        float[] size = new float[numDimensions];
        int[] newSize = new int[numDimensions];
        float[] offset = new float[numDimensions];
        double[] center = new double[numDimensions];
        for (d = 0; d < numDimensions; ++d) {
            center[d] = psf.getDimension(d) / 2;
        }
        model.applyInPlace(center);
        for (d = 0; d < numDimensions; ++d) {
            size[d] = minMaxDim[d][1] - minMaxDim[d][0];
            newSize[d] = (int)size[d] + 3;
            if (newSize[d] % 2 == 0) {
                int n = d;
                newSize[n] = newSize[n] + 1;
            }
            offset[d] = (float)center[d] - (float)(newSize[d] / 2);
        }
        ImageTransform transform = new ImageTransform(psf, model, (InterpolatorFactory)new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory()));
        transform.setOffset(offset);
        transform.setNewImageSize(newSize);
        if (!transform.checkInput() || !transform.process()) {
            System.out.println("Error transforming psf: " + transform.getErrorMessage());
            return null;
        }
        Image transformedPSF = transform.getResult();
        ViewDataBeads.normalizeImage((Image<FloatType>)transformedPSF);
        return transformedPSF;
    }

    protected static Image<FloatType> extractPSF(ViewDataBeads view, int[] size) {
        int numDimensions = size.length;
        OutOfBoundsStrategyPeriodicFactory outside = new OutOfBoundsStrategyPeriodicFactory();
        LinearInterpolatorFactory interpolatorFactory = new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)outside);
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), view.getViewStructure().getSPIMConfiguration().processImageFactory);
        Image<FloatType> img = view.getImage();
        Image psf = imageFactory.createImage(size);
        Interpolator interpolator = img.createInterpolator((InterpolatorFactory)interpolatorFactory);
        LocalizableCursor psfCursor = psf.createLocalizableCursor();
        int[] sizeHalf = (int[])size.clone();
        int d = 0;
        while (d < numDimensions) {
            int n = d++;
            sizeHalf[n] = sizeHalf[n] / 2;
        }
        int numRANSACBeads = 0;
        for (Bead bead : view.getBeadStructure().getBeadList()) {
            double[] position = (double[])bead.getL().clone();
            int[] tmpI = new int[position.length];
            double[] tmpF = new double[position.length];
            if (bead.getRANSACCorrespondence().size() <= 0) continue;
            ++numRANSACBeads;
            psfCursor.reset();
            while (psfCursor.hasNext()) {
                psfCursor.fwd();
                psfCursor.getPosition(tmpI);
                for (int d2 = 0; d2 < numDimensions; ++d2) {
                    tmpF[d2] = (double)(tmpI[d2] - sizeHalf[d2]) + position[d2];
                }
                interpolator.moveTo(tmpF);
                ((FloatType)psfCursor.getType()).add((FloatType)interpolator.getType());
            }
        }
        FloatType n = new FloatType((float)numRANSACBeads);
        psfCursor.reset();
        while (psfCursor.hasNext()) {
            psfCursor.fwd();
            ((FloatType)psfCursor.getType()).div(n);
        }
        ViewDataBeads.normalizeImage((Image<FloatType>)psf);
        return psf;
    }

    private static float[][] getMinMaxDim(int[] dimensions, CoordinateTransform transform) {
        int numDimensions = dimensions.length;
        double[] tmp = new double[numDimensions];
        float[][] minMaxDim = new float[numDimensions][2];
        for (int d = 0; d < numDimensions; ++d) {
            minMaxDim[d][0] = Float.MAX_VALUE;
            minMaxDim[d][1] = -3.4028235E38f;
        }
        boolean[][] positions = new boolean[Util.pow((int)2, (int)numDimensions)][numDimensions];
        Util.setCoordinateRecursive((int)(numDimensions - 1), (int)numDimensions, (int[])new int[numDimensions], (boolean[][])positions);
        for (int i = 0; i < positions.length; ++i) {
            int d;
            for (d = 0; d < numDimensions; ++d) {
                tmp[d] = positions[i][d] ? (double)(dimensions[d] - 1) : 0.0;
            }
            transform.applyInPlace(tmp);
            for (d = 0; d < numDimensions; ++d) {
                if (tmp[d] < (double)minMaxDim[d][0]) {
                    minMaxDim[d][0] = (float)tmp[d];
                }
                if (!(tmp[d] > (double)minMaxDim[d][1])) continue;
                minMaxDim[d][1] = (float)tmp[d];
            }
        }
        return minMaxDim;
    }

    public static Image<FloatType> makeSameSize(Image<FloatType> img, int[] sizeIn) {
        int[] size = (int[])sizeIn.clone();
        float min = Float.MAX_VALUE;
        for (FloatType f : img) {
            min = Math.min(min, f.get());
        }
        Image square = img.createNewImage(size);
        LocalizableCursor squareCursor = square.createLocalizableCursor();
        LocalizableByDimCursor inputCursor = img.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory((Type)new FloatType(min)));
        while (squareCursor.hasNext()) {
            squareCursor.fwd();
            squareCursor.getPosition(size);
            for (int d = 0; d < img.getNumDimensions(); ++d) {
                size[d] = size[d] - square.getDimension(d) / 2 + img.getDimension(d) / 2;
            }
            inputCursor.setPosition(size);
            ((FloatType)squareCursor.getType()).set(((FloatType)inputCursor.getType()).get());
        }
        return square;
    }

    public static <T extends Type<T>> int[] commonSize(List<Image<T>> images) {
        if (images == null || images.size() == 0) {
            return null;
        }
        int[] size = images.get(0).getDimensions();
        for (Image<T> image : images) {
            for (int d = 0; d < image.getNumDimensions(); ++d) {
                size[d] = Math.max(size[d], image.getDimension(d));
            }
        }
        return size;
    }

    public static ExtractPSF loadAndTransformPSF(ArrayList<String> fileName, boolean transformPSFs, ViewStructure viewStructure) {
        ExtractPSF extractPSF = new ExtractPSF(viewStructure);
        ArrayList<ViewDataBeads> views = viewStructure.getViews();
        int numDimensions = 3;
        int[] maxSize = new int[3];
        for (int d = 0; d < 3; ++d) {
            maxSize[d] = 0;
        }
        int i = 0;
        for (ViewDataBeads view : views) {
            Image<FloatType> psf;
            Image psfImage;
            if (viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("Loading PSF file '" + fileName.get(i) + "' for " + view.getName());
            }
            if ((psfImage = LOCI.openLOCIFloatType((String)fileName.get(i), (ContainerFactory)viewStructure.getSPIMConfiguration().inputImageFactory)) == null) {
                IJ.log((String)("Could not find PSF file '" + fileName.get(i) + "' - quitting."));
                return null;
            }
            ++i;
            if (transformPSFs) {
                if (viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("Transforming PSF for " + view.getName());
                }
                psf = ExtractPSF.transformPSF((Image<FloatType>)psfImage, (AbstractAffineModel3D)view.getTile().getModel());
            } else {
                psf = psfImage.clone();
            }
            psf.setName("PSF_" + view.getName());
            for (int d = 0; d < 3; ++d) {
                if (psf.getDimension(d) <= maxSize[d]) continue;
                maxSize[d] = psf.getDimension(d);
            }
            extractPSF.pointSpreadFunctions.add(psf);
            extractPSF.originalPSFs.add((Image<FloatType>)psfImage);
            psf.getDisplay().setMinMax();
        }
        extractPSF.computeAveragePSF(maxSize);
        return extractPSF;
    }
}

