/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import spim.Threads;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;

public class Mirror {
    public static <T extends Type<T>> boolean mirror(final Img<T> image, final int dimension, int numThreads) {
        final int n = image.numDimensions();
        long imageSize = image.size();
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(imageSize, numThreads * 4);
        final long maxMirror = image.dimension(dimension) - 1L;
        final long sizeMirrorH = image.dimension(dimension) / 2L;
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Cursor cursorIn = image.localizingCursor();
                    RandomAccess cursorOut = image.randomAccess();
                    Type temp = ((Type)image.firstElement()).createVariable();
                    long[] position = new long[n];
                    long startPosition = portion.getStartPosition();
                    long loopSize = portion.getLoopSize();
                    if (startPosition > 0L) {
                        cursorIn.jumpFwd(startPosition);
                    }
                    for (long i = 0L; i < loopSize; ++i) {
                        cursorIn.fwd();
                        cursorIn.localize(position);
                        if (position[dimension] > sizeMirrorH) continue;
                        position[dimension] = maxMirror - position[dimension];
                        cursorOut.setPosition(position);
                        Type in = (Type)cursorIn.get();
                        Type out = (Type)cursorOut.get();
                        temp.set(in);
                        in.set(out);
                        out.set(temp);
                    }
                    return null;
                }
            });
        }
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to compute downsampling: " + e);
            e.printStackTrace();
            return false;
        }
        taskExecutor.shutdown();
        return true;
    }
}

