/*
 * Decompiled with CFR 0.152.
 */
package fsalign;

import fsalign.FileListener;
import fsalign.FolderWatcher;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import javax.swing.filechooser.FileFilter;

public abstract class ImageListener
implements FileListener,
Runnable {
    private static final int QUEUE_CAP = 256;
    private final ArrayBlockingQueue<File> imageQueue = new ArrayBlockingQueue(256);
    private final Vector<File> holdList = new Vector();
    private final FileModifiedComparator fmc = new FileModifiedComparator();
    private final Hashtable<String, ImagePlus> fileTable = new Hashtable();
    private final Thread thread = new Thread(this);
    private boolean enabled = true;

    public static FolderWatcher imageFolderWatcher(String folderName, int interval, ImageListener imageListener, final String regexp) {
        FolderWatcher fw = new FolderWatcher(folderName, (long)interval, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().matches(regexp);
            }

            @Override
            public String getDescription() {
                return "File Filter, matching against regexp " + regexp;
            }
        });
        fw.addListener(imageListener);
        return fw;
    }

    public ImageListener() {
        this.thread.start();
    }

    @Override
    public void handle(FolderWatcher fw) {
        this.holdList.addAll(fw.getFreshFileList());
        ArrayList<File> readyList = new ArrayList<File>();
        for (File f : this.holdList) {
            if (!this.fileIsReady(f)) continue;
            readyList.add(f);
        }
        Collections.sort(readyList, this.fmc);
        for (File f : readyList) {
            if (!this.imageQueue.offer(f)) continue;
            this.holdList.remove(f);
        }
    }

    public void setEnabled(boolean go) {
        this.enabled = go;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void run() {
        while (this.enabled) {
            try {
                this.processImage(this.imageQueue.take());
            }
            catch (InterruptedException ie) {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void stop() {
        this.setEnabled(false);
        this.thread.interrupt();
    }

    public ImagePlus getImageFromPath(File file) {
        return this.getImageFromPath(file.getAbsolutePath());
    }

    public void dropImage(File file) {
        this.dropImage(file.getAbsolutePath());
    }

    public void dropImage(String path) {
        this.fileTable.remove(path);
    }

    public ImagePlus getImageFromPath(String path) {
        return this.fileTable.get(path);
    }

    protected boolean fileIsReady(File imageFile) {
        if (imageFile.isDirectory()) {
            return false;
        }
        ImagePlus im = IJ.openImage((String)imageFile.getAbsolutePath());
        if (im == null) {
            return false;
        }
        this.fileTable.put(imageFile.getAbsolutePath(), im);
        return true;
    }

    protected abstract void processImage(File var1);

    private static class FileModifiedComparator
    implements Comparator<File> {
        private FileModifiedComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return (int)(file1.lastModified() - file2.lastModified());
        }
    }
}

