/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Alpha;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.PathInterpolator;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;
import org.scijava.vecmath.Quat4f;
import org.scijava.vecmath.Tuple4f;

public class RotationPathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Quat4f tQuat = new Quat4f();
    private Quat4f[] quats;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationPathInterpolator() {
    }

    public RotationPathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float[] knots, Quat4f[] quats) {
        super(alpha, target, axisOfTransform, knots);
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setPathArrays(quats);
    }

    public void setQuat(int index, Quat4f quat) {
        this.quats[index].set((Tuple4f)quat);
    }

    public void getQuat(int index, Quat4f quat) {
        quat.set((Tuple4f)this.quats[index]);
    }

    public void setPathArrays(float[] knots, Quat4f[] quats) {
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setKnots(knots);
        this.setPathArrays(quats);
    }

    private void setPathArrays(Quat4f[] quats) {
        this.quats = new Quat4f[quats.length];
        for (int i = 0; i < quats.length; ++i) {
            this.quats[i] = new Quat4f();
            this.quats[i].set((Tuple4f)quats[i]);
        }
    }

    public void getQuats(Quat4f[] quats) {
        for (int i = 0; i < this.quats.length; ++i) {
            quats[i].set((Tuple4f)this.quats[i]);
        }
    }

    public void setAxisOfRotation(Transform3D axisOfRotation) {
        this.setTransformAxis(axisOfRotation);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        this.computePathInterpolation(alphaValue);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
        } else {
            double quatDot = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (quatDot < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
        }
        this.tQuat.normalize();
        this.rotation.set(this.tQuat);
        transform.mul(this.axis, this.rotation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        RotationPathInterpolator rpi = new RotationPathInterpolator();
        rpi.duplicateNode(this, forceDuplicate);
        return rpi;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        RotationPathInterpolator ri = (RotationPathInterpolator)originalNode;
        int len = ri.getArrayLengths();
        this.quats = new Quat4f[len];
        Quat4f quat = new Quat4f();
        for (int i = 0; i < len; ++i) {
            this.quats[i] = new Quat4f();
            ri.getQuat(i, quat);
            this.setQuat(i, quat);
        }
    }
}

