/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.tools;

import bdv.export.ExportMipmapInfo;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.spimdata.tools.ChangeAttributeId;
import bdv.spimdata.tools.ChangeViewSetupId;
import bdv.spimdata.tools.MergePartitionList;
import bdv.spimdata.tools.MergeTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;

public class MergeExample {
    public static void mergeHdf5ViewsSetups(List<String> inputFilenames, List<ViewTransform> transforms, String outputXmlFilename) throws SpimDataException {
        XmlIoSpimDataMinimal io = new XmlIoSpimDataMinimal();
        HashMap<String, Set<Integer>> attributeIdsInUse = new HashMap<String, Set<Integer>>();
        HashSet<Integer> setupIdsInUse = new HashSet<Integer>();
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        HashMap<Integer, ExportMipmapInfo> newMipmapInfos = new HashMap<Integer, ExportMipmapInfo>();
        ArrayList<SpimDataMinimal> spimDatas = new ArrayList<SpimDataMinimal>();
        for (int i = 0; i < inputFilenames.size(); ++i) {
            String fn = inputFilenames.get(i);
            ViewTransform transform = transforms.get(i);
            SpimDataMinimal spimData = (SpimDataMinimal)io.load(fn);
            SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
            ArrayList<Partition> partitions = MergePartitionList.getPartitions(seq);
            Map<Integer, ExportMipmapInfo> mipmapInfos = MergePartitionList.getHdf5PerSetupExportMipmapInfos(seq);
            Map<String, Map<Integer, Integer>> attributesReassigned = ChangeAttributeId.assignNewAttributeIds(spimData, attributeIdsInUse);
            Map<Integer, Integer> setupsReassigned = ChangeViewSetupId.assignNewViewSetupIds(spimData, setupIdsInUse);
            for (Partition partition : partitions) {
                Map<Integer, Integer> seqToPart = partition.getSetupIdSequenceToPartition();
                HashMap<Integer, Integer> newSeqToPart = new HashMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> entry : seqToPart.entrySet()) {
                    int oldSeq = entry.getKey();
                    int newSeq = setupsReassigned.containsKey(oldSeq) ? setupsReassigned.get(oldSeq) : oldSeq;
                    newSeqToPart.put(newSeq, entry.getValue());
                }
                newPartitions.add(new Partition(partition.getPath(), partition.getTimepointIdSequenceToPartition(), newSeqToPart));
            }
            for (Map.Entry entry : mipmapInfos.entrySet()) {
                int oldSeq = (Integer)entry.getKey();
                int newSeq = setupsReassigned.containsKey(oldSeq) ? setupsReassigned.get(oldSeq) : oldSeq;
                newMipmapInfos.put(newSeq, (ExportMipmapInfo)entry.getValue());
            }
            ViewRegistrations regs = spimData.getViewRegistrations();
            if (transform != null) {
                for (ViewRegistration reg : regs.getViewRegistrationsOrdered()) {
                    reg.concatenateTransform(transform);
                }
            }
            spimDatas.add(spimData);
        }
        File xmlFile = new File(outputXmlFilename);
        File path = xmlFile.getParentFile();
        String xmlFilename = xmlFile.getAbsolutePath();
        String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
        File h5File = new File(basename + ".h5");
        if (h5File.exists()) {
            h5File.delete();
        }
        SpimDataMinimal spimData = MergeTools.merge(path, spimDatas);
        SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
        Hdf5ImageLoader imgLoader = new Hdf5ImageLoader(h5File, newPartitions, seq, false);
        seq.setImgLoader((BasicImgLoader)imgLoader);
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile(seq, newMipmapInfos);
        io.save(spimData, xmlFilename);
    }

    public static void mergeHdf5ViewsTimepoints(List<String> inputFilenames, String outputXmlFilename) throws SpimDataException {
        XmlIoSpimDataMinimal io = new XmlIoSpimDataMinimal();
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        HashMap<Integer, ExportMipmapInfo> newMipmapInfos = new HashMap<Integer, ExportMipmapInfo>();
        ArrayList<SpimDataMinimal> spimDatas = new ArrayList<SpimDataMinimal>();
        int maxUsedTimepointId = -1;
        for (int i = 0; i < inputFilenames.size(); ++i) {
            Object tp22;
            String fn = inputFilenames.get(i);
            SpimDataMinimal spimData = (SpimDataMinimal)io.load(fn);
            SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
            ArrayList<Partition> partitions = MergePartitionList.getPartitions(seq);
            Map<Integer, ExportMipmapInfo> mipmapInfos = MergePartitionList.getHdf5PerSetupExportMipmapInfos(seq);
            newMipmapInfos.putAll(mipmapInfos);
            List tpsOrdered = seq.getTimePoints().getTimePointsOrdered();
            int oldFirst = ((TimePoint)tpsOrdered.get(0)).getId();
            int newFirst = Math.max(maxUsedTimepointId + 1, oldFirst);
            int offset = newFirst - oldFirst;
            maxUsedTimepointId = ((TimePoint)tpsOrdered.get(tpsOrdered.size() - 1)).getId() + offset;
            if (offset == 0) {
                newPartitions.addAll(partitions);
                spimDatas.add(spimData);
                continue;
            }
            HashMap<Integer, TimePoint> tps = new HashMap<Integer, TimePoint>();
            for (Object tp22 : tpsOrdered) {
                TimePoint tpReassigned = new TimePoint(tp22.getId() + offset);
                tps.put(tpReassigned.getId(), tpReassigned);
            }
            TimePoints newTps = new TimePoints(tps);
            tp22 = partitions.iterator();
            while (tp22.hasNext()) {
                Partition partition = (Partition)tp22.next();
                Map<Integer, Integer> seqToPart = partition.getTimepointIdSequenceToPartition();
                HashMap<Integer, Integer> newSeqToPart = new HashMap<Integer, Integer>();
                for (Map.Entry entry : seqToPart.entrySet()) {
                    int oldSeq = (Integer)entry.getKey();
                    int newSeq = oldSeq + offset;
                    newSeqToPart.put(newSeq, (Integer)entry.getValue());
                }
                newPartitions.add(new Partition(partition.getPath(), newSeqToPart, partition.getSetupIdSequenceToPartition()));
            }
            ViewRegistrations regs = spimData.getViewRegistrations();
            HashMap<ViewRegistration, ViewRegistration> newRegsMap = new HashMap<ViewRegistration, ViewRegistration>();
            for (ViewRegistration reg : regs.getViewRegistrationsOrdered()) {
                ViewRegistration newReg = new ViewRegistration(reg.getTimePointId() + offset, reg.getViewSetupId(), new ArrayList(reg.getTransformList()));
                newRegsMap.put(newReg, newReg);
            }
            ViewRegistrations newRegs = new ViewRegistrations(newRegsMap);
            Set mv = seq.getMissingViews().getMissingViews();
            HashSet<ViewId> newMv = new HashSet<ViewId>();
            for (ViewId view : mv) {
                newMv.add(new ViewId(view.getTimePointId() + offset, view.getViewSetupId()));
            }
            MissingViews missingViews = new MissingViews(newMv);
            SpimDataMinimal newSpimData = new SpimDataMinimal(spimData.getBasePath(), new SequenceDescriptionMinimal(newTps, seq.getViewSetups(), seq.getImgLoader(), missingViews), newRegs);
            spimDatas.add(newSpimData);
        }
        File xmlFile = new File(outputXmlFilename);
        File path = xmlFile.getParentFile();
        String xmlFilename = xmlFile.getAbsolutePath();
        String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
        File h5File = new File(basename + ".h5");
        if (h5File.exists()) {
            h5File.delete();
        }
        SpimDataMinimal spimData = MergeTools.merge(path, spimDatas);
        SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
        Hdf5ImageLoader imgLoader = new Hdf5ImageLoader(h5File, newPartitions, seq, false);
        seq.setImgLoader((BasicImgLoader)imgLoader);
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile(seq, newMipmapInfos);
        io.save(spimData, xmlFilename);
    }
}

