/*
 * Decompiled with CFR 0.152.
 */
package bijfit;

import bijnum.BIJmatrix;
import ij.IJ;

public class Maximum {
    static float mag;

    public static float[] findSubpixel(float[] image, int width) {
        int height = image.length / width;
        int[] intpeak = Maximum.find(image, width);
        float dxpeak = intpeak[0] - width / 2;
        float dypeak = intpeak[1] - height / 2;
        int xpeak = intpeak[0];
        int ypeak = intpeak[1];
        if (xpeak <= 0) {
            xpeak = -xpeak + 1;
        }
        if (ypeak <= 0) {
            ypeak = -ypeak + 1;
        }
        if (xpeak >= width) {
            xpeak = 2 * width - xpeak;
        }
        if (ypeak >= height) {
            ypeak = 2 * height - ypeak;
        }
        float[] fpeak = new float[2];
        float[] z = new float[3];
        float[][] w = new float[3][3];
        z[0] = image[xpeak - 1 + ypeak * width];
        if (Float.isNaN(z[0])) {
            z[0] = image[xpeak + ypeak * width];
        }
        z[1] = image[xpeak + ypeak * width];
        z[2] = image[xpeak + 1 + ypeak * width];
        if (Float.isNaN(z[2])) {
            z[2] = image[xpeak + ypeak * width];
        }
        w[0][0] = (dxpeak - 1.0f) * (dxpeak - 1.0f);
        w[0][1] = dxpeak - 1.0f;
        w[0][2] = 1.0f;
        w[1][0] = dxpeak * dxpeak;
        w[1][1] = dxpeak;
        w[1][2] = 1.0f;
        w[2][0] = (dxpeak + 1.0f) * (dxpeak + 1.0f);
        w[2][1] = dxpeak + 1.0f;
        w[2][2] = 1.0f;
        float[][] wi = null;
        float[] x = null;
        try {
            wi = BIJmatrix.inverse(w);
            x = BIJmatrix.mul(wi, z);
        }
        catch (Exception e) {
            IJ.log((String)("Error " + e));
        }
        fpeak[0] = -x[1] / (2.0f * x[0]);
        z[0] = image[xpeak + (ypeak - 1) * width];
        if (Float.isNaN(z[0])) {
            z[0] = image[xpeak + ypeak * width];
        }
        z[1] = image[xpeak + ypeak * width];
        z[2] = image[xpeak + (ypeak + 1) * width];
        if (Float.isNaN(z[2])) {
            z[2] = image[xpeak + ypeak * width];
        }
        w[0][0] = (dypeak - 1.0f) * (dypeak - 1.0f);
        w[0][1] = dypeak - 1.0f;
        w[0][2] = 1.0f;
        w[1][0] = dypeak * dypeak;
        w[1][1] = dypeak;
        w[1][2] = 1.0f;
        w[2][0] = (dypeak + 1.0f) * (dypeak + 1.0f);
        w[2][1] = dypeak + 1.0f;
        w[2][2] = 1.0f;
        try {
            wi = BIJmatrix.inverse(w);
            x = BIJmatrix.mul(wi, z);
        }
        catch (Exception e) {
            IJ.log((String)("Error " + e));
        }
        fpeak[1] = -x[1] / (2.0f * x[0]);
        mag = x[0] * (fpeak[1] * fpeak[1]) + x[1] * fpeak[1] + x[2];
        return fpeak;
    }

    public static int[] find(float[] image, int width) {
        int[] maxpos = new int[]{0, 0};
        float max = -3.402823E38f;
        for (int j = 0; j < image.length / width; ++j) {
            for (int i = 0; i < width; ++i) {
                if (!(image[j * width + i] > max)) continue;
                max = image[j * width + i];
                maxpos[0] = i;
                maxpos[1] = j;
            }
        }
        return maxpos;
    }

    public static int find(float[] v) {
        int maxpos = 0;
        float max = -3.402823E38f;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] > max)) continue;
            max = v[i];
            maxpos = i;
        }
        return maxpos;
    }

    @Deprecated
    public static float peakMag() {
        return mag;
    }
}

