/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.metrics.imagequality;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.metrics.imagequality.MSE;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;

public class PSNR {
    public static <T extends RealType<T>> double computeMetrics(RandomAccessibleInterval<T> reference, RandomAccessibleInterval<T> processed) {
        if (!Intervals.equalDimensions(reference, processed)) {
            throw new IllegalArgumentException("Image dimensions must match.");
        }
        double range = ((RealType)reference.randomAccess().get()).getMaxValue() - ((RealType)reference.randomAccess().get()).getMinValue();
        double mse = MSE.computeMetrics(reference, processed);
        return mse > 0.0 ? 10.0 * Math.log10(range * range / mse) : Double.NaN;
    }
}

