/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.curve;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sc.fiji.kappa.curve.BezierPoint;
import sc.fiji.kappa.gui.KappaFrame;

public abstract class Curve {
    public static final double DEFAULT_MICRON_PIXEL_FACTOR = 0.16;
    public static final int THRESHOLD_RADIUS = 5;
    public static final int CTRL_PT_TOL = 4;
    protected double minimumGlobalError;
    protected double minimumLocalError;
    public static final int DEFAULT_STROKE_THICKNESS = 1;
    public static final int CTRL_PT_SIZE = 1;
    public static final int SELECTED_CTRL_PT_SIZE = 2;
    public static final int PT_INDICATOR_SIZE = 2;
    public static final int STRETCH_FACTOR = 1;
    public static final Color CTRL_PT_COLOR = Color.GREEN;
    public static final Color THRESHOLD_DATA_CONTOUR_COLOR = Color.CYAN;
    protected int selectedCtrlPtIndex;
    protected String name;
    protected List<Point2D> ctrlPts;
    protected int noCtrlPts;
    protected int hoveredCtrlPt;
    protected int dataRadius;
    protected boolean selected;
    protected BArrayList keyframes;
    protected Rectangle2D boundingBox;
    protected List<Point2D> bounds;
    protected Polygon scaledBounds;
    protected List<Point2D> dataFittingBounds;
    protected Polygon scaledDataBounds;
    protected List<Point2D> thresholdedPixels;
    protected int t;
    protected static double micronPixelFactor = 0.16;
    protected KappaFrame frame;

    public Curve(List<Point2D> ctrlPts, int t, int noCtrlPts, String name, int dataRadius, KappaFrame frame) {
        this.frame = frame;
        this.selected = true;
        this.name = name;
        this.ctrlPts = ctrlPts;
        this.selectedCtrlPtIndex = -1;
        this.noCtrlPts = noCtrlPts;
        this.hoveredCtrlPt = -1;
        this.setKeyframes(new BArrayList());
        this.getKeyframes().add(new BControlPoints(this.ctrlPts, t));
        this.boundingBox = this.getKeyframes().getBounds(t);
        this.dataRadius = dataRadius;
        this.t = t;
        this.bounds = new ArrayList<Point2D>();
        this.scaledBounds = new Polygon();
        this.dataFittingBounds = new ArrayList<Point2D>();
        this.scaledDataBounds = new Polygon();
        this.thresholdedPixels = new ArrayList<Point2D>();
    }

    public void translateCurve(int t) {
        BControlPoints prev = this.getKeyframes().getInclusivePrev(t);
        BControlPoints next = this.getKeyframes().getInclusiveNext(t);
        if (prev.t == next.t) {
            for (int i = 0; i < this.noCtrlPts; ++i) {
                this.ctrlPts.set(i, new Point2D.Double(prev.defPoints[i].getX(), prev.defPoints[i].getY()));
            }
            this.fillPoints(this.ctrlPts, t);
            return;
        }
        double scaleFactor = (double)(t - prev.t) / ((double)(next.t - prev.t) * 1.0);
        for (int i = 0; i < this.noCtrlPts; ++i) {
            this.ctrlPts.set(i, new Point2D.Double(prev.defPoints[i].getX() + (next.defPoints[i].getX() - prev.defPoints[i].getX()) * scaleFactor, prev.defPoints[i].getY() + (next.defPoints[i].getY() - prev.defPoints[i].getY()) * scaleFactor));
        }
        this.fillPoints(this.ctrlPts, t);
        this.boundingBox = this.getKeyframes().getBounds(t);
    }

    public void addKeyFrame(Point2D newCtrlPt, int t) {
        if (this.selectedCtrlPtIndex < 0) {
            return;
        }
        this.ctrlPts.set(this.selectedCtrlPtIndex, newCtrlPt);
        this.getKeyframes().add(new BControlPoints(this.ctrlPts, t));
        this.fillPoints(this.ctrlPts, t);
        this.boundingBox = this.getKeyframes().getBounds(t);
        this.minimumGlobalError = Double.MAX_VALUE;
        this.minimumLocalError = Double.MAX_VALUE;
    }

    public void addKeyframe(List<Point2D> newCtrlPts, int t) {
        this.getKeyframes().add(new BControlPoints(this.ctrlPts, t));
    }

    public int[] getKeyframeLayers() {
        int[] keyframeLayers = new int[this.getKeyframes().size()];
        int i = 0;
        for (BControlPoints p : this.getKeyframes()) {
            keyframeLayers[i++] = p.t;
        }
        return keyframeLayers;
    }

    public int controlPointIndex(Point2D p, int t, double scale, boolean clicked) {
        for (int i = 0; i < this.ctrlPts.size(); ++i) {
            if (!(p.getX() >= (this.ctrlPts.get(i).getX() - this.frame.getSelectedCtrlPointSize()) * scale - 4.0) || !(p.getX() <= (this.ctrlPts.get(i).getX() + this.frame.getSelectedCtrlPointSize()) * scale + 4.0) || !(p.getY() >= (this.ctrlPts.get(i).getY() - this.frame.getSelectedCtrlPointSize()) * scale - 4.0) || !(p.getY() <= (this.ctrlPts.get(i).getY() + this.frame.getSelectedCtrlPointSize()) * scale + 4.0)) continue;
            if (clicked) {
                this.selectedCtrlPtIndex = i;
            }
            return i;
        }
        return -1;
    }

    public void shiftControlPoints(int t) {
        for (int i = 0; i < this.noCtrlPts; ++i) {
            this.ctrlPts.set(i, new Point2D.Double(this.ctrlPts.get(i).getX() + 1.0, this.ctrlPts.get(i).getY() + 1.0));
        }
        this.addKeyframe(this.ctrlPts, t);
        this.fillPoints(this.ctrlPts, t);
    }

    public void deshiftControlPoints(int t) {
        for (int i = 0; i < this.noCtrlPts; ++i) {
            this.ctrlPts.set(i, new Point2D.Double(this.ctrlPts.get(i).getX() - 1.0, this.ctrlPts.get(i).getY() - 1.0));
        }
        this.addKeyframe(this.ctrlPts, t);
        this.fillPoints(this.ctrlPts, t);
    }

    public void scale(double scaleFactor, int t) {
        for (int i = 0; i < this.noCtrlPts; ++i) {
            this.ctrlPts.set(i, new Point2D.Double(this.ctrlPts.get(i).getX() * scaleFactor, this.ctrlPts.get(i).getY() * scaleFactor));
        }
        this.addKeyframe(this.ctrlPts, t);
        this.fillPoints(this.ctrlPts, t);
    }

    public abstract void drawThresholdedPixels(Graphics2D var1, double var2);

    abstract void fillPoints(List<Point2D> var1, int var2);

    abstract List<Point2D> generateOffsetBounds(List<Point2D> var1, int var2);

    abstract void draw(double var1, Graphics2D var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public abstract boolean isPointOnCurve(Point2D var1, int var2, double var3);

    public abstract double getAverageCurvature();

    public abstract double getApproxCurveLength();

    public abstract double getPointCurvature(int var1);

    public abstract double getCurvatureStdDev();

    public abstract List<Point2D> getIntensityDataRed();

    public abstract List<Point2D> getIntensityDataGreen();

    public abstract List<Point2D> getIntensityDataBlue();

    public abstract List<Point2D> getCurveData();

    public abstract List<Point2D> getDebugCurveData();

    public abstract List<BezierPoint> getPoints();

    public abstract List<BezierPoint> getDigitizedPoints();

    public abstract Point2D.Double getPoint(int var1);

    public abstract void setSelected(boolean var1);

    public abstract boolean isSelected();

    public abstract int getNoPoints();

    public abstract void evaluateThresholdedPixels();

    public abstract void updateIntensities();

    public abstract List<Point2D> getThresholdedPixels();

    public abstract Point2D.Double getUnitTangent(int var1);

    public abstract Point2D.Double getUnitNormal(int var1);

    public abstract int getSign(int var1);

    public abstract void printValues(PrintWriter var1, double[][] var2, boolean var3);

    public abstract double getMaximum(double var1, double var3);

    public String getName() {
        return this.name;
    }

    public void resetControlPointSelection() {
        this.selectedCtrlPtIndex = -1;
    }

    public static void setMicronPixelFactor(double newMicronPixelFactor) {
        micronPixelFactor = newMicronPixelFactor;
    }

    public static double getMicronPixelFactor() {
        return micronPixelFactor;
    }

    public Rectangle2D.Double getScaledBounds(Rectangle2D rect, double imageScale) {
        return new Rectangle2D.Double(rect.getX() * imageScale, rect.getY() * imageScale, rect.getWidth() * imageScale, rect.getHeight() * imageScale);
    }

    public void recalculateCurvature(int t) {
        this.fillPoints(this.ctrlPts, t);
    }

    public void setHoveredControlPoint(int index) {
        this.hoveredCtrlPt = index;
    }

    public int getHoveredControlPoint() {
        return this.hoveredCtrlPt;
    }

    public int getNoKeyframes() {
        return this.getKeyframes().size();
    }

    public int getNoCtrlPts() {
        return this.ctrlPts.size();
    }

    public void setDataRadius(int radius) {
        this.dataRadius = radius;
        this.dataFittingBounds = this.generateOffsetBounds(this.dataFittingBounds, this.dataRadius);
        this.evaluateThresholdedPixels();
    }

    public int getDataRadius() {
        return this.dataRadius;
    }

    public int getT() {
        return this.t;
    }

    public List<Point2D> getCtrlPts() {
        return this.ctrlPts;
    }

    public BArrayList getKeyframes() {
        return this.keyframes;
    }

    public void setKeyframes(BArrayList keyframes) {
        this.keyframes = keyframes;
    }

    public class BControlPoints
    implements Comparable<Integer> {
        public Point2D[] defPoints;
        public double minX;
        public double maxX;
        public double minY;
        public double maxY;
        public int t;

        public BControlPoints(List<Point2D> ctrlPoints, int t) {
            int i;
            this.defPoints = new Point2D[Curve.this.noCtrlPts];
            for (i = 0; i < Curve.this.noCtrlPts; ++i) {
                this.defPoints[i] = ctrlPoints.get(i);
            }
            this.t = t;
            this.minX = this.maxX = this.defPoints[0].getX();
            this.minY = this.maxY = this.defPoints[0].getY();
            for (i = 1; i < this.defPoints.length; ++i) {
                if (this.defPoints[i].getX() < this.minX) {
                    this.minX = this.defPoints[i].getX();
                } else if (this.defPoints[i].getX() > this.maxX) {
                    this.maxX = this.defPoints[i].getX();
                }
                if (this.defPoints[i].getY() < this.minY) {
                    this.minY = this.defPoints[i].getY();
                    continue;
                }
                if (!(this.defPoints[i].getY() > this.maxY)) continue;
                this.maxY = this.defPoints[i].getY();
            }
        }

        @Override
        public int compareTo(Integer t) {
            return this.t - t;
        }
    }

    public class BArrayList
    extends ArrayList<BControlPoints> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean add(BControlPoints element) {
            int index = Collections.binarySearch(this, element.t);
            if (index < 0) {
                this.add(-1 * (index + 1), element);
                return true;
            }
            this.set(index, element);
            return true;
        }

        public BControlPoints getInclusivePrev(int t) {
            int index = Collections.binarySearch(this, t);
            if (index < 0) {
                if ((index = -1 * (index + 1)) == 0) {
                    return (BControlPoints)this.get(index);
                }
                return (BControlPoints)this.get(index - 1);
            }
            return (BControlPoints)this.get(index);
        }

        public BControlPoints getInclusiveNext(int t) {
            int index = Collections.binarySearch(this, t);
            if (index < 0) {
                if ((index = -1 * (index + 1)) == this.size()) {
                    return (BControlPoints)this.get(index - 1);
                }
                return (BControlPoints)this.get(index);
            }
            return (BControlPoints)this.get(index);
        }

        public Rectangle2D.Double getBounds(int t) {
            BControlPoints prev = Curve.this.getKeyframes().getInclusivePrev(t);
            BControlPoints next = Curve.this.getKeyframes().getInclusiveNext(t);
            if (prev.t == next.t) {
                return new Rectangle2D.Double(prev.minX, prev.minY, prev.maxX - prev.minX, prev.maxY - prev.minY);
            }
            double scaleFactor = (double)(t - prev.t) / ((double)(next.t - prev.t) * 1.0);
            return new Rectangle2D.Double(prev.minX + (next.minX - prev.minX) * scaleFactor, prev.minY + (next.minY - prev.minY) * scaleFactor, scaleFactor * (next.maxX - next.minX) - (prev.maxX - prev.minX) * (scaleFactor - 1.0), scaleFactor * (next.maxY - next.minY) - (prev.maxY - prev.minY) * (scaleFactor - 1.0));
        }
    }
}

