/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.zernike.helper;

public class Polynom {
    private final int[] m_coefficients;
    private final int m_degree;

    public Polynom(int degree) {
        this.m_degree = degree;
        this.m_coefficients = new int[this.m_degree + 1];
        for (int i = 0; i <= this.m_degree; ++i) {
            this.setCoefficient(i, 0);
        }
    }

    public void setCoefficient(int pos, int coef) {
        this.m_coefficients[pos] = coef;
    }

    public int getCoefficient(int pos) {
        return this.m_coefficients[pos];
    }

    public double evaluate(double x) {
        double power = 1.0;
        double result = 0.0;
        for (int i = 0; i <= this.m_degree; ++i) {
            result += (double)this.m_coefficients[i] * power;
            power *= x;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = this.m_degree; i >= 0; --i) {
            if (this.m_coefficients[i] == 0) continue;
            result.append(this.m_coefficients[i] + "X^" + i + " ");
        }
        return result.toString();
    }
}

