/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.convolve;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Convolve.class)
public class ConvolveNaiveC<I extends RealType<I>, K extends RealType<K>, O extends RealType<O>>
extends AbstractUnaryComputerOp<RandomAccessible<I>, RandomAccessibleInterval<O>>
implements Ops.Filter.Convolve,
Contingent {
    @Parameter
    private RandomAccessibleInterval<K> kernel;

    @Override
    public void compute(RandomAccessible<I> input, RandomAccessibleInterval<O> output) {
        long[] min = new long[input.numDimensions()];
        long[] max = new long[input.numDimensions()];
        for (int d = 0; d < this.kernel.numDimensions(); ++d) {
            min[d] = -this.kernel.dimension(d);
            max[d] = this.kernel.dimension(d) + output.dimension(d);
        }
        RandomAccess inRA = input.randomAccess((Interval)new FinalInterval(min, max));
        Cursor kernelC = Views.iterable(this.kernel).localizingCursor();
        Cursor outC = Views.iterable(output).localizingCursor();
        long[] pos = new long[input.numDimensions()];
        long[] kernelRadius = new long[this.kernel.numDimensions()];
        for (int i = 0; i < kernelRadius.length; ++i) {
            kernelRadius[i] = this.kernel.dimension(i) / 2L;
        }
        while (outC.hasNext()) {
            outC.fwd();
            outC.localize(pos);
            float val = 0.0f;
            inRA.setPosition(pos);
            kernelC.reset();
            while (kernelC.hasNext()) {
                kernelC.fwd();
                for (int i = 0; i < kernelRadius.length; ++i) {
                    if (kernelRadius[i] <= 0L) continue;
                    inRA.setPosition(pos[i] + kernelC.getLongPosition(i) - kernelRadius[i], i);
                }
                val = (float)((double)val + ((RealType)inRA.get()).getRealDouble() * ((RealType)kernelC.get()).getRealDouble());
            }
            ((RealType)outC.get()).setReal(val);
        }
    }

    @Override
    public boolean conforms() {
        return Intervals.numElements(this.kernel) <= 9L;
    }
}

