/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.help;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.OpCandidate;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpUtils;
import net.imagej.ops.Ops;
import org.scijava.ItemIO;
import org.scijava.module.ModuleInfo;
import org.scijava.plugin.Parameter;

public abstract class AbstractHelp
extends AbstractOp
implements Ops.Help {
    @Parameter(type=ItemIO.OUTPUT)
    private String help;

    protected void help(List<OpCandidate> candidates) {
        ArrayList<OpInfo> infos = new ArrayList<OpInfo>();
        for (OpCandidate candidate : candidates) {
            infos.add(candidate.opInfo());
        }
        this.help((Collection<? extends OpInfo>)infos);
    }

    protected void help(Collection<? extends OpInfo> infos) {
        OpInfo info;
        String string;
        if (infos.size() == 0) {
            this.help = "No such operation.";
            return;
        }
        StringBuilder sb = new StringBuilder("Available operations:");
        for (OpInfo opInfo : infos) {
            sb.append("\n\t" + OpUtils.opString((ModuleInfo)opInfo.cInfo()));
        }
        if (infos.size() == 1 && (string = (info = infos.iterator().next()).cInfo().getDescription()) != null && !string.isEmpty()) {
            sb.append("\n\n" + string);
        }
        this.help = sb.toString();
    }
}

