/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.create.img.CreateImgFromDimsAndType;
import net.imagej.ops.image.distancetransform.Phase1Runnable2DCal;
import net.imagej.ops.image.distancetransform.Phase2Runnable2DCal;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Image.DistanceTransform.class)
public class DistanceTransform2DCalibration<B extends BooleanType<B>, T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, RandomAccessibleInterval<T>>
implements Ops.Image.DistanceTransform,
Contingent {
    @Parameter(required=true)
    private double[] calibration;
    @Parameter
    private ThreadService ts;
    private UnaryFunctionOp<FinalInterval, RandomAccessibleInterval> createOp;
    private ExecutorService es;

    @Override
    public boolean conforms() {
        if (((RandomAccessibleInterval)this.in()).numDimensions() == 2) {
            long max_dist = ((RandomAccessibleInterval)this.in()).dimension(0) * ((RandomAccessibleInterval)this.in()).dimension(0) + ((RandomAccessibleInterval)this.in()).dimension(1) * ((RandomAccessibleInterval)this.in()).dimension(1);
            return ((RandomAccessibleInterval)this.in()).numDimensions() == 2 && max_dist <= Integer.MAX_VALUE;
        }
        return false;
    }

    @Override
    public void initialize() {
        this.es = this.ts.getExecutorService();
        this.createOp = Functions.unary(this.ops(), CreateImgFromDimsAndType.class, RandomAccessibleInterval.class, new FinalInterval((Interval)this.in()), new FloatType());
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<B> in) {
        return this.createOp.calculate(new FinalInterval(in));
    }

    @Override
    public void compute(RandomAccessibleInterval<B> in, RandomAccessibleInterval<T> out) {
        double[][] tempValues = new double[(int)in.dimension(0)][(int)out.dimension(1)];
        ArrayList<Callable<Void>> list = new ArrayList<Callable<Void>>();
        int y = 0;
        while ((long)y < in.dimension(1)) {
            list.add(new Phase1Runnable2DCal<B>(tempValues, in, y, this.calibration));
            ++y;
        }
        try {
            this.es.invokeAll(list);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        list.clear();
        int x = 0;
        while ((long)x < in.dimension(0)) {
            list.add(new Phase2Runnable2DCal<T>(tempValues, out, x, this.calibration));
            ++x;
        }
        try {
            this.es.invokeAll(list);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

