/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.otsu;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Otsu.class, priority=100.0)
public class ComputeOtsuThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Otsu {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        int k;
        long[] histogram = hist.toLongArray();
        int L = histogram.length;
        long S = 0L;
        long N = 0L;
        for (k = 0; k < L; ++k) {
            S += (long)k * histogram[k];
            N += histogram[k];
        }
        long Sk = 0L;
        long N1 = histogram[0];
        double BCV = 0.0;
        double BCVmax = 0.0;
        int kStar = 0;
        for (k = 1; k < L - 1; ++k) {
            double denom;
            Sk += (long)k * histogram[k];
            if ((denom = (double)(N1 += histogram[k]) * (double)(N - N1)) != 0.0) {
                double num = (double)N1 / (double)N * (double)S - (double)Sk;
                BCV = num * num / denom;
            } else {
                BCV = 0.0;
            }
            if (!(BCV >= BCVmax)) continue;
            BCVmax = BCV;
            kStar = k;
        }
        return kStar;
    }
}

