/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.StyleElements;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class DisplaySettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int tfCols = 4;
    private final JColorChooser colorChooser = new JColorChooser();
    private final List<StyleElements.StyleElement> styleElements;

    public DisplaySettingsPanel(DisplaySettings ds) {
        super(new GridBagLayout());
        this.styleElements = this.styleElements(ds);
        ds.listeners().add(() -> {
            this.styleElements.forEach(StyleElements.StyleElement::update);
            this.repaint();
        });
        final GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 5, 2, 5);
        this.styleElements.forEach(element -> element.accept(new StyleElements.StyleElementVisitor(){
            final /* synthetic */ DisplaySettingsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visit(StyleElements.Separator element) {
                this.this$0.add(Box.createVerticalStrut(10), c);
                ++c.gridy;
                this.addToLayout(new JSeparator(0));
            }

            @Override
            public void visit(StyleElements.LabelElement element) {
                JLabel label = new JLabel(element.getLabel());
                label.setFont(this.this$0.getFont().deriveFont(1).deriveFont((float)this.this$0.getFont().getSize() + 2.0f));
                this.addToLayout(label);
            }

            @Override
            public void visit(StyleElements.BooleanElement element) {
                JCheckBox checkbox = StyleElements.linkedCheckBox(element, "");
                checkbox.setHorizontalAlignment(11);
                this.addToLayout(checkbox, new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.BoundedDoubleElement element) {
                this.addToLayout(StyleElements.linkedSliderPanel(element, 4, 0.1), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.DoubleElement element) {
                this.addToLayout(StyleElements.linkedFormattedTextField(element), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.IntElement element) {
                this.addToLayout(StyleElements.linkedSliderPanel(element, 4), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.ColorElement element) {
                this.addToLayoutFlushRight(StyleElements.linkedColorButton(element, this.this$0.colorChooser), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.FeatureElement element) {
                this.addToLayout(StyleElements.linkedFeatureSelector(element), new JLabel(element.getLabel()));
            }

            @Override
            public <E> void visit(StyleElements.EnumElement<E> element) {
                this.addToLayout(StyleElements.linkedComboBoxEnumSelector(element), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.ColormapElement element) {
                this.addToLayout(StyleElements.linkedColormapChooser(element), new JLabel(element.getLabel()));
            }

            @Override
            public void visit(StyleElements.FontElement element) {
                this.addToLayout(StyleElements.linkedFontButton(element, SwingUtilities.getWindowAncestor(this.this$0)), new JLabel(element.getLabel()));
            }

            private void addToLayout(JComponent comp1, JComponent comp2) {
                c.gridwidth = 1;
                c.anchor = 22;
                this.this$0.add((Component)comp1, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.anchor = 21;
                this.this$0.add((Component)comp2, c);
                c.gridx = 0;
                c.weightx = 1.0;
                ++c.gridy;
            }

            private void addToLayoutFlushRight(JComponent comp1, JComponent comp2) {
                c.gridwidth = 1;
                c.fill = 1;
                c.fill = 0;
                c.anchor = 13;
                this.this$0.add((Component)comp1, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 2;
                c.anchor = 21;
                this.this$0.add((Component)comp2, c);
                c.gridx = 0;
                c.weightx = 1.0;
                ++c.gridy;
            }

            private void addToLayout(JComponent comp) {
                c.gridwidth = 2;
                c.anchor = 21;
                c.gridx = 0;
                c.weightx = 1.0;
                this.this$0.add((Component)comp, c);
                ++c.gridy;
            }
        }));
    }

    private List<StyleElements.StyleElement> styleElements(DisplaySettings ds) {
        StyleElements.StyleElement[] styleElementArray = new StyleElements.StyleElement[42];
        styleElementArray[0] = StyleElements.separator();
        styleElementArray[1] = StyleElements.label("Spots");
        styleElementArray[2] = StyleElements.booleanElement("draw spots", ds::isSpotVisible, ds::setSpotVisible);
        styleElementArray[3] = StyleElements.booleanElement("draw spots as ROIs", ds::isSpotDisplayedAsRoi, ds::setSpotDisplayedAsRoi);
        styleElementArray[4] = StyleElements.booleanElement("draw spots filled", ds::isSpotFilled, ds::setSpotFilled);
        styleElementArray[5] = StyleElements.boundedDoubleElement("spot alpha transparency", 0.0, 1.0, ds::getSpotTransparencyAlpha, ds::setSpotTransparencyAlpha);
        styleElementArray[6] = StyleElements.booleanElement("show spot names", ds::isSpotShowName, ds::setSpotShowName);
        styleElementArray[7] = StyleElements.boundedDoubleElement("spot radius ratio", 0.0, 20.0, ds::getSpotDisplayRadius, ds::setSpotDisplayRadius);
        styleElementArray[8] = StyleElements.featureElement("spot color", ds::getSpotColorByType, ds::getSpotColorByFeature, (type, feature) -> ds.setSpotColorBy((DisplaySettings.TrackMateObject)((Object)type), (String)feature));
        styleElementArray[9] = StyleElements.doubleElement("spot display min", ds::getSpotMin, m -> ds.setSpotMinMax((double)m, ds.getSpotMax()));
        styleElementArray[10] = StyleElements.doubleElement("spot display max", ds::getSpotMax, m -> ds.setSpotMinMax(ds.getSpotMin(), (double)m));
        styleElementArray[11] = StyleElements.colorElement("spot uniform color", ds::getSpotUniformColor, ds::setSpotUniformColor);
        styleElementArray[12] = StyleElements.separator();
        styleElementArray[13] = StyleElements.label("Tracks");
        styleElementArray[14] = StyleElements.booleanElement("draw tracks", ds::isTrackVisible, ds::setTrackVisible);
        styleElementArray[15] = StyleElements.enumElement("track display mode", DisplaySettings.TrackDisplayMode.values(), ds::getTrackDisplayMode, ds::setTrackDisplayMode);
        styleElementArray[16] = StyleElements.featureElement("track color", ds::getTrackColorByType, ds::getTrackColorByFeature, (type, feature) -> ds.setTrackColorBy((DisplaySettings.TrackMateObject)((Object)type), (String)feature));
        styleElementArray[17] = StyleElements.doubleElement("track display min", ds::getTrackMin, m -> ds.setTrackMinMax((double)m, ds.getTrackMax()));
        styleElementArray[18] = StyleElements.doubleElement("track display max", ds::getTrackMax, m -> ds.setTrackMinMax(ds.getTrackMin(), (double)m));
        styleElementArray[19] = StyleElements.colorElement("track uniform color", ds::getTrackUniformColor, ds::setTrackUniformColor);
        styleElementArray[20] = StyleElements.booleanElement("fade track in time", ds::isFadeTracks, ds::setFadeTracks);
        styleElementArray[21] = StyleElements.intElement("track fade range", 0, 500, ds::getFadeTrackRange, ds::setFadeTrackRange);
        styleElementArray[22] = StyleElements.separator();
        styleElementArray[23] = StyleElements.label("General");
        styleElementArray[24] = StyleElements.colormapElement("colormap", ds::getColormap, ds::setColormap);
        styleElementArray[25] = StyleElements.booleanElement("limit Z-depth", ds::isZDrawingDepthLimited, ds::setZDrawingDepthLimited);
        styleElementArray[26] = StyleElements.boundedDoubleElement("drawing Z-depth", 0.0, 1000.0, ds::getZDrawingDepth, ds::setZDrawingDepth);
        styleElementArray[27] = StyleElements.colorElement("selection color", ds::getHighlightColor, ds::setHighlightColor);
        styleElementArray[28] = StyleElements.colorElement("color for missing values", ds::getMissingValueColor, ds::setMissingValueColor);
        styleElementArray[29] = StyleElements.colorElement("color for undefined values", ds::getUndefinedValueColor, ds::setUndefinedValueColor);
        styleElementArray[30] = StyleElements.boundedDoubleElement("line thickness", 0.0, 10.0, ds::getLineThickness, ds::setLineThickness);
        styleElementArray[31] = StyleElements.boundedDoubleElement("selection line thickness", 0.0, 10.0, ds::getSelectionLineThickness, ds::setSelectionLineThickness);
        styleElementArray[32] = StyleElements.fontElement("font", ds::getFont, ds::setFont);
        styleElementArray[33] = StyleElements.booleanElement("anti-aliasing", ds::getUseAntialiasing, ds::setUseAntialiasing);
        styleElementArray[34] = StyleElements.separator();
        styleElementArray[35] = StyleElements.label("TrackScheme");
        styleElementArray[36] = StyleElements.colorElement("foreground color", ds::getTrackSchemeForegroundColor, ds::setTrackSchemeForegroundColor);
        styleElementArray[37] = StyleElements.colorElement("background color 1", ds::getTrackSchemeBackgroundColor1, ds::setTrackSchemeBackgroundColor1);
        styleElementArray[38] = StyleElements.colorElement("background color 2", ds::getTrackSchemeBackgroundColor2, ds::setTrackSchemeBackgroundColor2);
        styleElementArray[39] = StyleElements.colorElement("decoration color", ds::getTrackSchemeDecorationColor, ds::setTrackSchemeDecorationColor);
        styleElementArray[40] = StyleElements.booleanElement("fill box", ds::isTrackSchemeFillBox, ds::setTrackschemeFillBox);
        styleElementArray[41] = StyleElements.separator();
        return Arrays.asList(styleElementArray);
    }
}

