/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.BigDataViewerActions;
import bdv.tools.CloseWindowActions;
import bdv.tools.PreferencesDialog;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.appearance.AppearanceSettingsPage;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.keymap.KeymapSettingsPage;
import bdv.ui.settings.SettingsPage;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMLabKitModel;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMTransformationModel;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class TMLabKitActions {
    private static final String RESET_VIEW = "reset view";
    private static final String[] RESET_VIEW_KEYS = new String[]{"shift R "};

    public static void install(Actions actions, TMLabKitModel model, TMLabKitFrame frame, InputActionBindings keybindings, KeymapManager keymapManager, AppearanceManager appearanceManager) {
        Keymap keymap = keymapManager.getForwardSelectedKeymap();
        PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)frame, keymap, new String[]{"trackmate-labkit"});
        GuiUtils.positionWindow((Window)preferencesDialog, frame);
        BigDataViewerActions.toggleDialogAction((Actions)actions, (Dialog)preferencesDialog, (String)"Preferences", (String[])BigDataViewerActions.PREFERENCES_DIALOG_KEYS);
        preferencesDialog.addPage((SettingsPage)new KeymapSettingsPage("Keymap", keymapManager, keymapManager.getCommandDescriptions()));
        preferencesDialog.addPage((SettingsPage)new AppearanceSettingsPage("Appearance", appearanceManager));
        appearanceManager.appearance().updateListeners().add(frame::repaint);
        SwingUtilities.invokeLater(() -> appearanceManager.updateLookAndFeel());
        TMTransformationModel transformationModel = (TMTransformationModel)model.imageLabelingModel().transformationModel();
        actions.runnableAction(() -> transformationModel.resetView(), RESET_VIEW, RESET_VIEW_KEYS);
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TMLabKitActions.RESET_VIEW, RESET_VIEW_KEYS, "Reset the view.");
            descriptions.add("Preferences", BigDataViewerActions.PREFERENCES_DIALOG_KEYS, "Show the Preferences dialog.");
            descriptions.add("close dialog window", CloseWindowActions.CLOSE_DIALOG_KEYS, "Close the active dialog.");
        }
    }
}

