/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.displaysettings.BoundedValue;
import fiji.plugin.trackmate.gui.displaysettings.StyleElements;
import fiji.plugin.trackmate.util.FileChooser;
import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CommandCLIConfigurator;
import fiji.plugin.trackmate.util.cli.CondaCLIConfigurator;
import fiji.plugin.trackmate.util.cli.Configurator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ConfigGuiBuilder
implements Configurator.ArgumentVisitor {
    private static final int tfCols = 4;
    private final ConfigPanel panel;
    private final GridBagConstraints c;
    private int topInset = 5;
    private int bottomInset = 5;
    private final Map<Configurator.Argument<?, ?>, Function<?, ?>> forwardUITranslators;
    private final Map<Configurator.Argument<?, ?>, Function<?, ?>> backwardUITranslators;

    private ConfigGuiBuilder(Map<Configurator.Argument<?, ?>, Function<?, ?>> forwardUITranslators, Map<Configurator.Argument<?, ?>, Function<?, ?>> backwardUITranslators) {
        this.forwardUITranslators = forwardUITranslators;
        this.backwardUITranslators = backwardUITranslators;
        this.panel = new ConfigPanel();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWeights = new double[]{0.0, 1.0, 0.0};
        this.panel.setLayout(layout);
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
    }

    private void setCurrentRadioButton(JRadioButton radioButton) {
        if (radioButton == null || this.panel.rdbtn != radioButton) {
            this.topInset = 5;
            this.bottomInset = 5;
        } else {
            this.topInset = 0;
            this.bottomInset = 0;
        }
        this.panel.rdbtn = radioButton;
    }

    @Override
    public void visit(CommandCLIConfigurator.ExecutablePath arg) {
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((String)arg.getDefaultValue());
        }
        StyleElements.StringElement element = StyleElements.stringElement(arg.getName(), arg::getValue, arg::set);
        this.panel.elements.put(arg.getKey(), element);
        this.addPathToLayout(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedTextField(element), null);
        this.panel.add(Box.createVerticalStrut(10), this.c);
        JSeparator separator = new JSeparator(0);
        separator.setMinimumSize(new Dimension(10, 10));
        this.addToLayout(null, separator);
    }

    @Override
    public void visit(Configurator.Flag flag) {
        if (!flag.isSet()) {
            if (!flag.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + flag.getName() + "' misses both.");
            }
            flag.set((Boolean)flag.getDefaultValue());
        }
        StyleElements.BooleanElement element = StyleElements.booleanElement(flag.getName(), flag::getValue, flag::set);
        this.panel.elements.put(flag.getKey(), element);
        JCheckBox checkbox = StyleElements.linkedCheckBox(element, "");
        checkbox.setHorizontalAlignment(10);
        this.addToLayout(flag.getHelp(), new JLabel(element.getLabel()), checkbox, flag);
    }

    @Override
    public void visit(Configurator.IntArgument arg) {
        int numberOfColumns;
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((Integer)arg.getDefaultValue());
        }
        Function<Object, Object> forward = this.forwardUITranslators.getOrDefault(arg, v -> v);
        Function<Object, Object> backward = this.backwardUITranslators.getOrDefault(arg, v -> v);
        IntSupplier valueGetter = () -> {
            int value = (Integer)arg.getValue();
            return (Integer)forward.apply(value);
        };
        Consumer<Integer> valueSetter = v -> {
            int value = (Integer)backward.apply(v);
            arg.set(value);
        };
        int min = (Integer)forward.apply((Integer)arg.getMin());
        int max = (Integer)forward.apply((Integer)arg.getMax());
        StyleElements.IntElement element = StyleElements.intElement(arg.getName(), min, max, valueGetter, valueSetter);
        this.panel.elements.put(arg.getKey(), element);
        if (arg.hasMin() && arg.hasMin()) {
            int largest = Math.max(Math.abs(min), Math.abs(max));
            String numberString = String.valueOf(largest);
            numberOfColumns = numberString.length() + 1;
        } else {
            numberOfColumns = 4;
        }
        this.addToLayout(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedSliderPanel(element, numberOfColumns), arg.getUnits(), arg);
    }

    @Override
    public void visit(Configurator.DoubleArgument arg) {
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((Double)arg.getDefaultValue());
        }
        Function<Object, Object> forward = this.forwardUITranslators.getOrDefault(arg, v -> v);
        Function<Object, Object> backward = this.backwardUITranslators.getOrDefault(arg, v -> v);
        DoubleSupplier valueGetter = () -> {
            double value = (Double)arg.getValue();
            return (Double)forward.apply(value);
        };
        Consumer<Double> valueSetter = v -> {
            double value = (Double)backward.apply(v);
            arg.set(value);
        };
        if (arg.hasMin() && arg.hasMax()) {
            double min = (Double)forward.apply((Double)arg.getMin());
            double max = (Double)forward.apply((Double)arg.getMax());
            StyleElements.BoundedDoubleElement element = StyleElements.boundedDoubleElement(arg.getName(), min, max, valueGetter, valueSetter);
            this.panel.elements.put(arg.getKey(), element);
            this.addToLayout(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedSliderPanel(element, 4, (Double)arg.getMax() / 50.0), arg.getUnits(), arg);
        } else {
            StyleElements.DoubleElement element = StyleElements.doubleElement(arg.getName(), valueGetter, valueSetter);
            this.panel.elements.put(arg.getKey(), element);
            if (arg.isSet()) {
                element.set((Double)forward.apply((Double)arg.getValue()));
            } else if (arg.hasDefaultValue()) {
                element.set((Double)forward.apply((Double)arg.getDefaultValue()));
            }
            this.addToLayout(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedFormattedTextField(element), arg.getUnits(), arg);
        }
    }

    @Override
    public void visit(Configurator.StringArgument arg) {
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((String)arg.getDefaultValue());
        }
        Function<Object, Object> forward = this.forwardUITranslators.getOrDefault(arg, v -> v);
        Function<Object, Object> backward = this.backwardUITranslators.getOrDefault(arg, v -> v);
        Supplier<String> valueGetter = () -> {
            String value = (String)arg.getValue();
            return (String)forward.apply(value);
        };
        Consumer<String> valueSetter = v -> {
            String value = (String)backward.apply(v);
            arg.set(value);
        };
        StyleElements.StringElement element = StyleElements.stringElement(arg.getName(), valueGetter, valueSetter);
        this.panel.elements.put(arg.getKey(), element);
        this.addToLayoutTwoLines(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedTextField(element), arg);
    }

    @Override
    public void visit(Configurator.PathArgument arg) {
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((String)arg.getDefaultValue());
        }
        Function<Object, Object> forward = this.forwardUITranslators.getOrDefault(arg, v -> v);
        Function<Object, Object> backward = this.backwardUITranslators.getOrDefault(arg, v -> v);
        Supplier<String> valueGetter = () -> {
            String value = (String)arg.getValue();
            return (String)forward.apply(value);
        };
        Consumer<String> valueSetter = v -> {
            String value = (String)backward.apply(v);
            arg.set(value);
        };
        StyleElements.StringElement element = StyleElements.stringElement(arg.getName(), valueGetter, valueSetter);
        this.panel.elements.put(arg.getKey(), element);
        this.addPathToLayout(arg.getHelp(), new JLabel(element.getLabel()), StyleElements.linkedTextField(element), arg);
    }

    @Override
    public void visit(Configurator.ChoiceArgument arg) {
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((String)arg.getDefaultValue());
        }
        List<String> displays = arg.getDisplays();
        Supplier<String> supplier = () -> (String)displays.get(arg.getSelectedIndex());
        Consumer<String> consumer = s -> arg.set(displays.indexOf(s));
        StyleElements.ListElement<String> element = StyleElements.listElement(arg.getName(), displays, supplier, consumer);
        this.panel.elements.put(arg.getKey(), element);
        JComboBox<String> comboBox = StyleElements.linkedComboBoxSelector(element);
        comboBox.setSelectedIndex(arg.getSelectedIndex());
        this.addToLayout(arg.getHelp(), new JLabel(element.getLabel()), comboBox, arg.getUnits(), arg);
    }

    @Override
    public void visit(CondaCLIConfigurator.CondaEnvironmentCommand arg) {
        if (arg.getEnvironments().isEmpty()) {
            JLabel lbl = new JLabel("<html>There was an error retrieving the list of conda environments. <p>Did you configure Conda for TrackMate? <p>(Edit > Options > Configure TrackMate Conda path...)</html>");
            lbl.setFont(Fonts.SMALL_FONT);
            lbl.setForeground(Color.RED);
            lbl.setPreferredSize(new Dimension(200, 40));
            this.addToLayout(arg.getHelp(), lbl);
            return;
        }
        if (!arg.isSet()) {
            if (!arg.hasDefaultValue()) {
                throw new IllegalArgumentException("The GUI builder requires all arguments and commands to have a value or a default value. The argument '" + arg.getName() + "' misses both.");
            }
            arg.set((String)arg.getDefaultValue());
        }
        StyleElements.ListElement<String> element = StyleElements.listElement(arg.getName(), arg.getEnvironments(), arg::getValue, arg::set);
        this.panel.elements.put(arg.getKey(), element);
        JComboBox<String> comboBox = StyleElements.linkedComboBoxSelector(element);
        comboBox.setSelectedItem(arg.getValue());
        this.addToLayout(arg.getHelp(), new JLabel(element.getLabel()), comboBox, null);
    }

    private void addToLayoutTwoLines(String help, JLabel lbl, JComponent comp, Configurator.Argument<?, ?> arg) {
        JComponent item;
        lbl.setText(lbl.getText() + " ");
        lbl.setFont(Fonts.SMALL_FONT);
        comp.setFont(Fonts.SMALL_FONT);
        if (this.panel.rdbtn != null) {
            JRadioButton btn = this.panel.rdbtn;
            btn.addItemListener(e -> comp.setEnabled(btn.isSelected()));
            comp.setEnabled(btn.isSelected());
            item = new JPanel();
            item.setLayout(new BoxLayout(item, 2));
            item.add(btn);
            item.add(Box.createHorizontalGlue());
            item.add(lbl);
        } else {
            item = lbl;
        }
        this.c.insets = new Insets(5, 0, 0, 0);
        this.c.gridwidth = 3;
        this.panel.add((Component)item, this.c);
        ++this.c.gridy;
        this.c.anchor = 21;
        this.c.insets = new Insets(0, 0, 5, 0);
        this.panel.add((Component)comp, this.c);
        ++this.c.gridy;
        if (help != null) {
            lbl.setToolTipText(help);
            comp.setToolTipText(help);
        }
    }

    private void addPathToLayout(String help, JLabel lbl, JTextField tf, Configurator.Argument<?, ?> arg) {
        JPanel p = new JPanel();
        BoxLayout bl = new BoxLayout(p, 2);
        p.setLayout(bl);
        tf.setColumns(10);
        lbl.setText(lbl.getText() + " ");
        lbl.setFont(Fonts.SMALL_FONT);
        tf.setFont(Fonts.SMALL_FONT);
        JButton browseButton = new JButton("browse");
        browseButton.setFont(Fonts.SMALL_FONT);
        browseButton.addActionListener(e -> {
            File file = FileChooser.chooseFile(p, tf.getText(), FileChooser.DialogType.LOAD);
            if (file == null) {
                return;
            }
            tf.setText(file.getAbsolutePath());
            tf.postActionEvent();
        });
        if (this.panel.rdbtn != null) {
            JRadioButton btn = this.panel.rdbtn;
            btn.addItemListener(e -> {
                tf.setEnabled(btn.isSelected());
                browseButton.setEnabled(btn.isSelected());
            });
            tf.setEnabled(btn.isSelected());
            browseButton.setEnabled(btn.isSelected());
            p.add(btn);
        }
        p.add(lbl);
        p.add(Box.createHorizontalGlue());
        p.add(browseButton);
        this.c.insets = new Insets(this.topInset, 0, 0, 0);
        this.c.gridwidth = 3;
        this.panel.add((Component)p, this.c);
        ++this.c.gridy;
        this.c.anchor = 21;
        this.c.insets = new Insets(0, 0, this.bottomInset, 0);
        this.panel.add((Component)tf, this.c);
        ++this.c.gridy;
        if (help != null) {
            lbl.setToolTipText(help);
            tf.setToolTipText(help);
            browseButton.setToolTipText(help);
        }
    }

    private void addToLayout(String help, JLabel lbl, JComponent comp, Configurator.Argument<?, ?> arg) {
        JComponent header;
        lbl.setText(lbl.getText() + " ");
        lbl.setFont(Fonts.SMALL_FONT);
        lbl.setHorizontalAlignment(4);
        comp.setFont(Fonts.SMALL_FONT);
        if (arg != null && this.panel.rdbtn != null) {
            JRadioButton btn = this.panel.rdbtn;
            btn.addItemListener(e -> comp.setEnabled(btn.isSelected()));
            comp.setEnabled(btn.isSelected());
            header = new JPanel();
            header.setLayout(new BoxLayout(header, 2));
            header.add(btn);
            header.add(Box.createHorizontalGlue());
            header.add(lbl);
        } else {
            header = lbl;
        }
        this.c.gridwidth = 1;
        this.c.anchor = 22;
        this.panel.add((Component)header, this.c);
        ++this.c.gridx;
        this.c.gridwidth = 2;
        this.c.anchor = 21;
        this.panel.add((Component)comp, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.insets = new Insets(this.topInset, 0, this.bottomInset, 0);
        if (help != null) {
            lbl.setToolTipText(help);
            comp.setToolTipText(help);
        }
    }

    private void addToLayout(String help, JLabel lbl, JComponent comp, String units, Configurator.Argument<?, ?> arg) {
        JComponent header;
        if (units == null) {
            this.addToLayout(help, lbl, comp, arg);
            return;
        }
        lbl.setText(lbl.getText() + " ");
        lbl.setFont(Fonts.SMALL_FONT);
        lbl.setHorizontalAlignment(4);
        comp.setFont(Fonts.SMALL_FONT);
        if (this.panel.rdbtn != null) {
            JRadioButton btn = this.panel.rdbtn;
            btn.addItemListener(e -> comp.setEnabled(btn.isSelected()));
            header = new JPanel();
            header.setLayout(new BoxLayout(header, 2));
            header.add(btn);
            header.add(Box.createHorizontalGlue());
            header.add(lbl);
        } else {
            header = lbl;
        }
        this.c.gridwidth = 1;
        this.c.anchor = 22;
        this.panel.add((Component)header, this.c);
        ++this.c.gridx;
        this.c.anchor = 21;
        this.panel.add((Component)comp, this.c);
        JLabel lblUnits = new JLabel(" " + units);
        lblUnits.setFont(Fonts.SMALL_FONT);
        ++this.c.gridx;
        this.c.insets = new Insets(this.topInset, 0, this.bottomInset, 0);
        this.panel.add((Component)lblUnits, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        if (help != null) {
            lbl.setToolTipText(help);
            comp.setToolTipText(help);
            lblUnits.setToolTipText(help);
        }
    }

    private void addToLayout(String help, JComponent comp) {
        JComponent header;
        if (this.panel.rdbtn != null) {
            JRadioButton btn = this.panel.rdbtn;
            btn.addItemListener(e -> comp.setEnabled(btn.isSelected()));
            header = new JPanel();
            header.setLayout(new BoxLayout(header, 2));
            header.add(btn);
            header.add(Box.createHorizontalGlue());
            header.add(comp);
        } else {
            header = comp;
        }
        this.c.gridx = 0;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.insets = new Insets(this.topInset, 0, this.bottomInset, 0);
        this.panel.add((Component)header, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        if (help != null) {
            comp.setToolTipText(help);
        }
    }

    private void addLastRow() {
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.weighty = 1.0;
        this.panel.add((Component)new JLabel(), this.c);
    }

    public static ConfigPanel build(Configurator config) {
        ConfigGuiBuilder builder = ConfigGuiBuilder.createBuilder(config);
        if (config instanceof CLIConfigurator) {
            ((CLIConfigurator)config).getCommandArg().accept(builder);
        }
        return ConfigGuiBuilder.build(config, builder);
    }

    private static ConfigGuiBuilder createBuilder(Configurator config) {
        return new ConfigGuiBuilder(config.forwardUITranslators, config.backwardUITranslators);
    }

    private static ConfigPanel build(Configurator config, ConfigGuiBuilder builder) {
        HashMap buttons = new HashMap();
        for (Configurator.SelectableArguments selectableArguments : config.getSelectables()) {
            List<Configurator.Argument<?, ?>> args = selectableArguments.getArguments();
            int nItems = args.size();
            String label = selectableArguments.getKey();
            IntSupplier get = selectableArguments::getSelected;
            Consumer<Integer> set = selectableArguments::select;
            StyleElements.IntElement element = StyleElements.intElement(label, 0, nItems - 1, get, set);
            builder.panel.elements.put(selectableArguments.getKey(), element);
            ButtonGroup buttonGroup = ConfigGuiBuilder.linkedButtonGroup(element);
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            Iterator<Configurator.Argument<?, ?>> it = args.iterator();
            while (enumeration.hasMoreElements()) {
                JRadioButton btn = (JRadioButton)enumeration.nextElement();
                Configurator.Argument<?, ?> arg = it.next();
                buttons.put(arg, btn);
                btn.setSelected(selectableArguments.getSelection().equals(arg));
            }
        }
        for (Configurator.Argument argument : config.getArguments()) {
            if (!argument.isVisible()) continue;
            builder.setCurrentRadioButton((JRadioButton)buttons.get(argument));
            argument.accept(builder);
        }
        builder.addLastRow();
        return builder.panel;
    }

    private static ButtonGroup linkedButtonGroup(final StyleElements.IntElement element) {
        BoundedValue value = element.getValue();
        ButtonGroup buttonGroup = new ButtonGroup();
        final ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
        int i = 0;
        while (i <= value.getRangeMax()) {
            final JRadioButton btn = new JRadioButton();
            buttons.add(btn);
            final int selected = i++;
            btn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (btn.isSelected()) {
                        element.set(selected);
                    }
                }
            });
            buttonGroup.add(btn);
        }
        element.getValue().setUpdateListener(new BoundedValue.UpdateListener(){

            @Override
            public void update() {
                int selected = element.get();
                ((JRadioButton)buttons.get(selected)).setSelected(true);
            }
        });
        return buttonGroup;
    }

    public class ConfigPanel
    extends JPanel {
        final Map<String, StyleElements.StyleElement> elements = new LinkedHashMap<String, StyleElements.StyleElement>();
        private JRadioButton rdbtn;
        private static final long serialVersionUID = 1L;

        public void refresh() {
            this.elements.values().forEach(e -> e.update());
        }
    }
}

