/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import org.lsmp.djep.groupJep.groups.Group;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.JEP;

public class Quaternions
extends Group
implements RingI {
    private Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    private Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    private Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    private Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    @Override
    public Number getZERO() {
        return this.ZERO;
    }

    @Override
    public Number getONE() {
        return this.ONE;
    }

    @Override
    public Number getInverse(Number num) {
        Quaternion q = (Quaternion)num;
        return new Quaternion(-q.x, -q.y, -q.z, -q.w);
    }

    @Override
    public Number add(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x + q.x, p.y + q.y, p.z + q.z, p.w + q.w);
    }

    @Override
    public Number sub(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x - q.x, p.y - q.y, p.z - q.z, p.w - q.w);
    }

    @Override
    public Number mul(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x * q.x - p.y * q.y - p.z * q.z - p.w * q.w, p.x * q.y - p.y * q.x + p.z * q.w - p.w * q.z, p.x * q.z - p.y * q.w + p.z * q.x + p.w * q.y, p.x * q.w - p.y * q.z - p.z * q.y + p.w * q.x);
    }

    @Override
    public boolean equals(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return p.x == q.x && p.y == q.y && p.z == q.z && p.w == q.w;
    }

    @Override
    public Number valueOf(String s) {
        return new Quaternion(Double.parseDouble(s), 0.0, 0.0, 0.0);
    }

    @Override
    public void addStandardConstants(JEP j) {
        super.addStandardConstants(j);
        j.addConstant("i", this.I);
        j.addConstant("j", this.J);
        j.addConstant("k", this.K);
    }

    @Override
    public String toString() {
        return "Quaternions";
    }

    public static class Quaternion
    extends Number {
        double x;
        double y;
        double z;
        double w;

        public Quaternion(double x, double y, double z, double w) {
            this.w = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        @Override
        public double doubleValue() {
            return this.x;
        }

        @Override
        public float floatValue() {
            return (float)this.x;
        }

        @Override
        public int intValue() {
            return (int)this.x;
        }

        @Override
        public long longValue() {
            return (long)this.x;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            boolean flag = false;
            if (this.x != 0.0) {
                sb.append(this.x);
                flag = true;
            }
            if (this.y != 0.0) {
                if (flag && this.y > 0.0) {
                    sb.append("+");
                }
                if (this.y != 1.0) {
                    if (this.y == -1.0) {
                        sb.append("-");
                    } else {
                        sb.append(this.y);
                    }
                }
                sb.append("i");
                flag = true;
            }
            if (this.z != 0.0) {
                if (flag && this.z > 0.0) {
                    sb.append("+");
                }
                if (this.z != 1.0) {
                    if (this.z == -1.0) {
                        sb.append("-");
                    } else {
                        sb.append(this.z);
                    }
                }
                sb.append("j");
                flag = true;
            }
            if (this.w != 0.0) {
                if (flag && this.w > 0.0) {
                    sb.append("+");
                }
                if (this.w != 1.0) {
                    if (this.w == -1.0) {
                        sb.append("-");
                    } else {
                        sb.append(this.w);
                    }
                }
                sb.append("k");
                flag = true;
            }
            if (!flag) {
                sb.append("0");
            }
            return sb.toString();
        }
    }
}

