/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.widget.AWTInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.ObjectWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class AWTObjectWidget
extends AWTInputWidget<Object>
implements ItemListener,
ObjectWidget<Panel> {
    private Choice choice;

    public Object getValue() {
        return this.get().getObjectPool().get(this.choice.getSelectedIndex());
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.choice = new Choice();
        for (Object item : model.getObjectPool()) {
            this.choice.add(item.toString());
        }
        this.getComponent().add((Component)this.choice, "Center");
        this.choice.addItemListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.getObjectPool().size() > 0;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateModel();
    }

    public void doRefresh() {
        String value = this.get().getValue().toString();
        if (value.equals(this.choice.getSelectedItem())) {
            return;
        }
        this.choice.select(value);
    }
}

