/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import fiji.util.FloatArray;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import sc.fiji.timelapse.Phase_Map;

public class Combine_Profile_Stacks
implements PlugIn {
    public void run(String arg) {
        ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
        HashMap<ImagePlus, float[][]> map = new HashMap<ImagePlus, float[][]>();
        int[] ids = WindowManager.getIDList();
        if (ids.length < 2) {
            IJ.error((String)"Need at least 2 profile stacks!");
            return;
        }
        for (int id : ids) {
            ImagePlus imp = WindowManager.getImage((int)id);
            float[][] profiles = this.parseProfiles(imp.getProperty("Info"));
            if (profiles == null) continue;
            images.add(imp);
            map.put(imp, profiles);
        }
        if (images.size() < 2) {
            IJ.error((String)"Need at least 2 profile stacks!");
            return;
        }
        GenericDialog gd = new GenericDialog("Combine Profile Stacks");
        for (ImagePlus imp : images) {
            gd.addCheckbox(imp.getTitle(), true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ArrayList<float[][]> profiles = new ArrayList<float[][]>();
        float pixelSpacing = 1.0f;
        String pixelSpacingUnit = null;
        for (ImagePlus imp : images) {
            Calibration calibration;
            if (!gd.getNextBoolean()) continue;
            if (pixelSpacingUnit == null && (calibration = imp.getCalibration()) != null) {
                pixelSpacing = (float)calibration.pixelWidth;
                pixelSpacingUnit = calibration.getUnit();
            }
            profiles.add((float[][])map.get(imp));
        }
        if (pixelSpacingUnit == null) {
            pixelSpacingUnit = "pixels";
        }
        this.combineProfileStacks("Combined profile stack", profiles, pixelSpacing, pixelSpacingUnit).show();
    }

    private ImagePlus combineProfileStacks(String title, List<float[][]> profiles, float pixelSpacing, String pixelSpacingUnit) {
        int maxT = 0;
        int maxX = 0;
        float maxPhase = -3.4028235E38f;
        float minPhase = Float.MAX_VALUE;
        for (float[][] list : profiles) {
            if (maxT < list.length) {
                maxT = list.length;
            }
            for (float[] profile : list) {
                if (maxX < profile.length) {
                    maxX = profile.length;
                }
                for (float f : profile) {
                    if (minPhase > f) {
                        minPhase = f;
                    }
                    if (!(maxPhase < f)) continue;
                    maxPhase = f;
                }
            }
        }
        ImageStack imageStack = null;
        float[][] median = new float[maxT][];
        float[] tmp = new float[maxT];
        float[][] p = new float[maxT][];
        for (int t = 0; t < maxT; ++t) {
            int i;
            int count = 0;
            for (i = 0; i < profiles.size(); ++i) {
                float[][] stack = profiles.get(i);
                if (t >= stack.length) continue;
                p[count++] = stack[t];
            }
            for (i = count; i < p.length; ++i) {
                p[i] = null;
            }
            Arrays.sort(p, new Comparator<float[]>(){

                @Override
                public int compare(float[] a, float[] b) {
                    if (a == null) {
                        return b == null ? 0 : 1;
                    }
                    if (b == null) {
                        return -1;
                    }
                    return b.length - a.length;
                }
            });
            median[t] = new float[p[0].length];
            for (i = 0; i < p[0].length; ++i) {
                int j;
                for (j = 0; j < count && i < p[j].length; ++j) {
                    tmp[j] = p[j][i];
                }
                for (int k = j; k < tmp.length; ++k) {
                    tmp[k] = Float.MAX_VALUE;
                }
                Arrays.sort(tmp);
                median[t][i] = (j & 1) == 1 ? tmp[j / 2] : (tmp[j / 2] + tmp[j / 2 - 1]) / 2.0f;
            }
            float pi2 = (float)Math.PI * 2;
            Plot plot = new Plot("Profile t=" + t, "x" + ("".equals(pixelSpacingUnit) ? "" : " (" + pixelSpacingUnit + ")"), "phase (\u00d7 2\u03c0)");
            plot.setLimits(0.0, (double)maxX, (double)(minPhase / ((float)Math.PI * 2)), (double)(maxPhase / ((float)Math.PI * 2)));
            plot.setFrameSize(850, 400);
            for (int i2 = 0; i2 < count; ++i2) {
                plot.addPoints(Phase_Map.range(0, p[i2].length, pixelSpacing), Phase_Map.divide(p[i2], (float)Math.PI * 2), 2);
            }
            plot.setColor(Color.BLUE);
            plot.setLineWidth(2);
            plot.addPoints(Phase_Map.range(0, median[t].length, pixelSpacing), Phase_Map.divide(median[t], (float)Math.PI * 2), 2);
            ImageProcessor ip = plot.getProcessor();
            if (imageStack == null) {
                imageStack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            imageStack.addSlice("t=" + t, ip);
        }
        return new ImagePlus(title, imageStack);
    }

    private float[][] parseProfiles(Object property) {
        int offset;
        if (property == null || !(property instanceof String)) {
            return null;
        }
        String info = (String)property;
        char[] array = info.toCharArray();
        for (offset = 0; offset < array.length && array[offset] != '['; ++offset) {
        }
        if (offset >= array.length) {
            return null;
        }
        ++offset;
        ArrayList<Object> list = new ArrayList<Object>();
        while (offset < array.length) {
            char ch;
            if (Character.isWhitespace(ch = array[offset++]) || ch == ',') continue;
            if (ch == ']') break;
            if (ch != '[') {
                System.err.println("Unexpected character @" + (offset - 1) + ": " + ch);
                return null;
            }
            FloatArray profile = new FloatArray();
            while (true) {
                int end;
                if (offset < array.length && (array[offset] == ',' || Character.isWhitespace(array[offset]))) {
                    ++offset;
                    continue;
                }
                if (offset >= array.length || array[offset] == ']') {
                    ++offset;
                    break;
                }
                for (end = offset; end < array.length && (array[end] == '.' || array[end] == 'E' || array[end] == 'e' || array[end] == '-' || Character.isDigit(array[end])); ++end) {
                }
                try {
                    profile.add(Float.parseFloat(info.substring(offset, end)));
                }
                catch (Exception e) {
                    return null;
                }
                offset = end;
            }
            list.add(profile.buildArray());
        }
        return (float[][])list.toArray((T[])new float[list.size()][]);
    }

    public static void main(String ... args) {
        new ImageJ();
        IJ.openImage((String)"/home/dscho/Desktop/Fiji.app/profile_stacks/Profile Stack  of Kymograph of 120807_yfp_s0001.tif").show();
        IJ.openImage((String)"/home/dscho/Desktop/Fiji.app/profile_stacks/Profile Stack  of Kymograph of 120807_yfp_s0002.tif").show();
        IJ.openImage((String)"/home/dscho/Desktop/Fiji.app/profile_stacks/Profile Stack  of Kymograph of 120807_yfp_s0006.tif").show();
        IJ.openImage((String)"/home/dscho/Desktop/Fiji.app/profile_stacks/Profile Stack  of Kymograph of 120807_yfp_s0007.tif").show();
        IJ.openImage((String)"/home/dscho/Desktop/Fiji.app/profile_stacks/Profile Stack  of Kymograph of 120807_yfp_s0008.tif").show();
        new Combine_Profile_Stacks().run("");
    }
}

