/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

public class StandardDeviation {
    protected double x;
    protected double x2;
    protected double count;

    public void reset() {
        this.count = 0.0;
        this.x2 = 0.0;
        this.x = 0.0;
    }

    public void add(double value) {
        this.count += 1.0;
        this.x += value;
        this.x2 += value * value;
    }

    public double getCount() {
        return this.count;
    }

    public double getMean() {
        return this.x / this.count;
    }

    public double getVariance() {
        return (this.x2 - this.x * this.x / this.count) / this.count;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }
}

