/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import net.imglib2.AbstractLocalizingCursorInt;
import net.imglib2.img.list.AbstractListImg;
import net.imglib2.util.IntervalIndexer;

public final class ListLocalizingCursor<T>
extends AbstractLocalizingCursorInt<T> {
    private int i;
    private final int maxNumPixels;
    private final long[] max;
    private final AbstractListImg<T> img;

    public ListLocalizingCursor(ListLocalizingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.maxNumPixels = cursor.maxNumPixels;
        this.max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = cursor.max[d];
            this.position[d] = cursor.position[d];
        }
        this.i = cursor.i;
    }

    public ListLocalizingCursor(AbstractListImg<T> img) {
        super(img.numDimensions());
        this.img = img;
        this.maxNumPixels = (int)img.size() - 1;
        this.max = new long[this.n];
        img.max(this.max);
        this.reset();
    }

    @Override
    public void fwd() {
        ++this.i;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if ((long)this.position[n] <= this.max[d]) break;
            this.position[d] = 0;
        }
    }

    @Override
    public void jumpFwd(long steps) {
        this.i = (int)((long)this.i + steps);
        IntervalIndexer.indexToPosition(this.i, this.img.dim, this.position);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.maxNumPixels;
    }

    @Override
    public void reset() {
        this.i = -1;
        this.position[0] = -1;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = 0;
        }
    }

    @Override
    public T get() {
        return this.img.get(this.i);
    }

    @Override
    public T getType() {
        return this.img.getType();
    }

    public void set(T t) {
        this.img.set(this.i, t);
    }

    @Override
    public ListLocalizingCursor<T> copy() {
        return new ListLocalizingCursor<T>(this);
    }
}

