/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.fluent;

import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import net.imglib2.view.fluent.RandomAccessibleIntervalView;
import net.imglib2.view.fluent.RealRandomAccessibleView;

public interface RandomAccessibleView<T, V extends RandomAccessibleView<T, V>>
extends RandomAccessible<T> {
    public RandomAccessible<T> delegate();

    public static <T, V extends RandomAccessibleView<T, V>> RandomAccessibleView<T, V> wrap(RandomAccessible<T> delegate) {
        return () -> delegate;
    }

    default public RandomAccessibleIntervalView<T> interval(Interval interval) {
        return RandomAccessibleIntervalView.wrap(Views.interval(this.delegate(), interval));
    }

    default public RandomAccessibleView<T, ?> slice(int d, long pos) {
        return RandomAccessibleView.wrap(Views.hyperSlice(this.delegate(), d, pos));
    }

    default public RandomAccessibleView<T, ?> addDimension() {
        return RandomAccessibleView.wrap(Views.addDimension(this.delegate()));
    }

    default public RandomAccessibleView<T, ?> translate(long ... translation) {
        return RandomAccessibleView.wrap(Views.translate(this.delegate(), translation));
    }

    default public RandomAccessibleView<T, ?> translateInverse(long ... translation) {
        return RandomAccessibleView.wrap(Views.translateInverse(this.delegate(), translation));
    }

    default public RandomAccessibleView<T, ?> subsample(long ... steps) {
        return RandomAccessibleView.wrap(Views.subsample(this.delegate(), Util.expandArray(steps, this.numDimensions())));
    }

    default public RandomAccessibleView<T, ?> rotate(int fromAxis, int toAxis) {
        return RandomAccessibleView.wrap(Views.rotate(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleView<T, ?> permute(int fromAxis, int toAxis) {
        return RandomAccessibleView.wrap(Views.permute(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleView<T, ?> moveAxis(int fromAxis, int toAxis) {
        return RandomAccessibleView.wrap(Views.moveAxis(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleView<T, ?> invertAxis(int axis) {
        return RandomAccessibleView.wrap(Views.invertAxis(this.delegate(), axis));
    }

    default public RealRandomAccessibleView<T> interpolate(Interpolation<T> interpolation) {
        return RealRandomAccessibleView.wrap(Views.interpolate(this.delegate(), interpolation.factory));
    }

    default public <U> RandomAccessibleView<U, ?> convert(Supplier<U> targetSupplier, Converter<? super T, ? super U> converter) {
        return RandomAccessibleView.wrap(Converters.convert2(this.delegate(), converter, targetSupplier));
    }

    default public <U> RandomAccessibleView<U, ?> convert(Supplier<U> targetSupplier, Supplier<Converter<? super T, ? super U>> converterSupplier) {
        return RandomAccessibleView.wrap(Converters.convert2(this.delegate(), converterSupplier, targetSupplier));
    }

    default public <U> U use(Function<? super V, U> function) {
        return function.apply(this);
    }

    @Override
    default public RandomAccessibleView<T, ?> view() {
        return this;
    }

    @Override
    default public T getType() {
        return this.delegate().getType();
    }

    @Override
    default public int numDimensions() {
        return this.delegate().numDimensions();
    }

    @Override
    default public RandomAccess<T> randomAccess() {
        return this.delegate().randomAccess();
    }

    @Override
    default public RandomAccess<T> randomAccess(Interval interval) {
        return this.delegate().randomAccess(interval);
    }

    public static class Interpolation<T> {
        final InterpolatorFactory<T, ? super RandomAccessible<T>> factory;

        private Interpolation(InterpolatorFactory<T, ? super RandomAccessible<T>> factory) {
            this.factory = factory;
        }

        public static <T> Interpolation<T> nearestNeighbor() {
            return new Interpolation<T>(new NearestNeighborInterpolatorFactory());
        }

        public static <T extends NumericType<T>> Interpolation<T> nLinear() {
            return new Interpolation<T>(new NLinearInterpolatorFactory());
        }

        public static <T extends NumericType<T>> Interpolation<T> clampingNLinear() {
            return new Interpolation<T>(new ClampingNLinearInterpolatorFactory());
        }

        public static <T extends RealType<T>> Interpolation<T> lanczos() {
            return new Interpolation<T>(new LanczosInterpolatorFactory());
        }
    }
}

