/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.geom;

import org.renjin.graphics.geom.Dimension;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Margins {
    private double bottom;
    private double left;
    private double top;
    private double right;

    public Margins() {
    }

    public Margins(double bottom, double left, double top, double right) {
        this.bottom = bottom;
        this.left = left;
        this.top = top;
        this.right = right;
    }

    public static Margins fromExp(SEXP exp2) {
        if (!(exp2 instanceof Vector)) {
            throw new IllegalArgumentException("vector required");
        }
        Vector vector2 = (Vector)exp2;
        if (exp2.length() != 4) {
            throw new IllegalArgumentException("vector of length 4 required");
        }
        return new Margins(vector2.getElementAsDouble(0), vector2.getElementAsDouble(1), vector2.getElementAsDouble(2), vector2.getElementAsDouble(3));
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public Vector toVector() {
        return new DoubleArrayVector(this.bottom, this.left, this.top, this.right);
    }

    public Margins multiplyBy(Dimension size) {
        return new Margins(this.bottom * size.getHeight(), this.left * size.getWidth(), this.top * size.getHeight(), this.right * size.getWidth());
    }
}

