/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.codegen.GeneratorDefinitionException;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Primitives;

public class PrimitiveModel {
    private final Primitives.Entry entry;
    private final List<JvmMethod> overloads;

    public PrimitiveModel(Primitives.Entry entry, List<JvmMethod> overloads) {
        this.entry = entry;
        this.overloads = overloads;
    }

    public String argumentErrorMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Invalid argument: %s. Expected:");
        for (JvmMethod method : this.overloads) {
            message.append("\n\t");
            method.appendFriendlySignatureTo(this.entry.name, message);
        }
        return message.toString();
    }

    public int maxPositionalArgs() {
        int max2 = 0;
        for (JvmMethod overload : this.overloads) {
            int count = overload.countPositionalFormals();
            if (count <= max2) continue;
            max2 = count;
        }
        return max2;
    }

    public List<JvmMethod> overloadsWithPosArgCountOf(int i) {
        ArrayList matching = Lists.newArrayList();
        for (JvmMethod overload : this.overloads) {
            if (overload.countPositionalFormals() != i) continue;
            matching.add(overload);
        }
        Collections.sort(matching);
        return matching;
    }

    public boolean isEvaluated(int argumentIndex) {
        boolean evaluated = false;
        boolean unevaluated = false;
        for (JvmMethod overload : this.overloads) {
            if (argumentIndex >= overload.getFormals().size()) continue;
            if (overload.getFormals().get(argumentIndex).isEvaluated()) {
                evaluated = true;
                continue;
            }
            unevaluated = true;
        }
        if (evaluated && unevaluated) {
            throw new GeneratorDefinitionException("Mixing evaluated and unevaluated arguments at the same position is not yet supported");
        }
        return evaluated;
    }

    public String getName() {
        return this.entry.name;
    }

    public String getJavaName() {
        return WrapperGenerator2.toJavaName(this.getName());
    }

    public String getClassName() {
        return "R$primitive$" + this.getJavaName();
    }

    public boolean isSpecial() {
        return this.entry.isSpecial();
    }

    public List<Integer> getArity() {
        HashSet arity = Sets.newHashSet();
        for (JvmMethod overload : this.overloads) {
            arity.add(overload.countPositionalFormals());
        }
        ArrayList list2 = Lists.newArrayList((Iterable)arity);
        Collections.sort(list2);
        return list2;
    }

    public int getMaxArity() {
        int max2 = 0;
        for (JvmMethod overload : this.overloads) {
            if (overload.countPositionalFormals() <= max2) continue;
            max2 = overload.countPositionalFormals();
        }
        return max2;
    }

    public boolean hasVargs() {
        for (JvmMethod overload : this.overloads) {
            for (JvmMethod.Argument argument : overload.getFormals()) {
                if (!argument.isAnnotatedWith(ArgumentList.class)) continue;
                return true;
            }
        }
        return false;
    }

    public List<JvmMethod> getOverloads() {
        return this.overloads;
    }
}

