/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

import java.text.NumberFormat;
import org.apache.commons.math.complex.Complex;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;

public class NumericLiterals {
    public static final NumberFormat INTEGER_FORMAT = NumericLiterals.createIntegerFormat();
    public static final NumberFormat REAL_FORMAT = NumericLiterals.createRealFormat();

    public static String format(double value, String naString) {
        if (DoubleVector.isNA(value)) {
            return naString;
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            return "Inf";
        }
        return NumericLiterals.toString(value);
    }

    public static String format(int value) {
        return INTEGER_FORMAT.format(value);
    }

    public static String toString(double value) {
        if (value > 100000.0) {
            return Double.toString(value);
        }
        return REAL_FORMAT.format(value);
    }

    public static String toString(Complex complex2) {
        StringBuilder sb = new StringBuilder();
        sb.append(NumericLiterals.toString(complex2.getReal()));
        if (complex2.getImaginary() >= 0.0) {
            sb.append('+');
        }
        sb.append(NumericLiterals.toString(complex2.getImaginary()));
        sb.append('i');
        return sb.toString();
    }

    public static NumberFormat createRealFormat() {
        NumberFormat format2 = NumberFormat.getNumberInstance();
        format2.setMinimumFractionDigits(0);
        format2.setMaximumFractionDigits(14);
        format2.setGroupingUsed(false);
        return format2;
    }

    private static NumberFormat createIntegerFormat() {
        NumberFormat format2 = NumberFormat.getIntegerInstance();
        format2.setGroupingUsed(false);
        return format2;
    }

    public static double parseDouble(CharSequence text) {
        return NumericLiterals.parseDouble(text, 0, text.length(), '.', false);
    }

    public static Complex parseComplex(CharSequence s) {
        int lastCharIndex = s.length() - 1;
        if (s.charAt(lastCharIndex) == 'i') {
            int imaginaryStart = NumericLiterals.findImaginaryStart(s);
            if (imaginaryStart <= 0) {
                return ComplexVector.NA;
            }
            double real2 = NumericLiterals.parseDouble(s, 0, imaginaryStart, '.', false);
            double imaginary = NumericLiterals.parseDouble(s, imaginaryStart, lastCharIndex, '.', false);
            return new Complex(real2, imaginary);
        }
        return new Complex(NumericLiterals.parseDouble(s), 0.0);
    }

    private static int findImaginaryStart(CharSequence s) {
        for (int index = s.length() - 2; index >= 0; --index) {
            char c2 = s.charAt(index);
            if (c2 != '+' && c2 != '-') continue;
            return index;
        }
        return -1;
    }

    public static int parseInt(CharSequence line) {
        return (int)NumericLiterals.parseDouble(line);
    }

    public static double parseDouble(CharSequence s, int startIndex, int endIndex, char dec, boolean NA) {
        int n;
        int p;
        int ndigits;
        int sign2;
        int expn;
        double fac;
        double p10;
        double ans;
        block47: {
            ans = 0.0;
            p10 = 10.0;
            fac = 1.0;
            expn = 0;
            sign2 = 1;
            ndigits = 0;
            int exph = -1;
            for (p = startIndex; p < endIndex && Character.isWhitespace(s.charAt(p)); ++p) {
            }
            if (NA && p + 2 < endIndex && s.charAt(p) == 'N' && s.charAt(p + 1) == 'A') {
                ans = DoubleVector.NA;
                p += 2;
                return ans;
            }
            if (p == endIndex) {
                return DoubleVector.NA;
            }
            switch (s.charAt(p)) {
                case '-': {
                    sign2 = -1;
                    ++p;
                    break;
                }
                case '+': {
                    ++p;
                }
            }
            if (NumericLiterals.nextWordIgnoringCaseIs(s, p, endIndex, "NAN")) {
                ans = Double.NaN;
                p += 3;
                return (double)sign2 * ans;
            }
            if (NumericLiterals.nextWordIgnoringCaseIs(s, p, endIndex, "INF")) {
                ans = Double.POSITIVE_INFINITY;
                p += 3;
                return (double)sign2 * ans;
            }
            if (NumericLiterals.nextWordIgnoringCaseIs(s, p, endIndex, "INFINITY")) {
                ans = Double.POSITIVE_INFINITY;
                p += 8;
                return (double)sign2 * ans;
            }
            if (endIndex - p <= 2 || s.charAt(p) != '0' || s.charAt(p + 1) != 'x' && s.charAt(p + 2) != 'X') break block47;
            p += 2;
            while (p < s.length()) {
                block52: {
                    block49: {
                        block51: {
                            block50: {
                                block48: {
                                    if ('0' > s.charAt(p) || s.charAt(p) > '9') break block48;
                                    ans = 16.0 * ans + (double)(s.charAt(p) - 48);
                                    break block49;
                                }
                                if ('a' > s.charAt(p) || s.charAt(p) > 'f') break block50;
                                ans = 16.0 * ans + (double)(s.charAt(p) - 97 + 10);
                                break block49;
                            }
                            if ('A' > s.charAt(p) || s.charAt(p) > 'F') break block51;
                            ans = 16.0 * ans + (double)(s.charAt(p) - 65 + 10);
                            break block49;
                        }
                        if (s.charAt(p) != dec) break;
                        exph = 0;
                        break block52;
                    }
                    if (exph >= 0) {
                        exph += 4;
                    }
                }
                ++p;
            }
            if (p < endIndex && (s.charAt(p) == 'p' || s.charAt(p) == 'P')) {
                int expsign = 1;
                double p2 = 2.0;
                switch (s.charAt(++p)) {
                    case '-': {
                        expsign = -1;
                        ++p;
                        break;
                    }
                    case '+': {
                        ++p;
                    }
                }
                int n2 = 0;
                while (p < endIndex && s.charAt(p) >= '0' && s.charAt(p) <= '9') {
                    n2 = n2 * 10 + (s.charAt(p) - 48);
                    ++p;
                }
                expn += expsign * n2;
                if (exph > 0) {
                    expn -= exph;
                }
                if (expn < 0) {
                    n2 = -expn;
                    fac = 1.0;
                    while (n2 != 0) {
                        if ((n2 & 1) != 0) {
                            fac *= p2;
                        }
                        n2 >>= 1;
                        p2 *= p2;
                    }
                    ans /= fac;
                } else {
                    n2 = expn;
                    fac = 1.0;
                    while (n2 != 0) {
                        if ((n2 & 1) != 0) {
                            fac *= p2;
                        }
                        n2 >>= 1;
                        p2 *= p2;
                    }
                    ans *= fac;
                }
            }
            return (double)sign2 * ans;
        }
        while (p < endIndex && s.charAt(p) >= '0' && s.charAt(p) <= '9') {
            ans = 10.0 * ans + (double)(s.charAt(p) - 48);
            ++p;
            ++ndigits;
        }
        if (p < endIndex && s.charAt(p) == dec) {
            ++p;
            while (p < endIndex && s.charAt(p) >= '0' && s.charAt(p) <= '9') {
                ans = 10.0 * ans + (double)(s.charAt(p) - 48);
                ++p;
                ++ndigits;
                --expn;
            }
        }
        if (ndigits == 0) {
            ans = DoubleVector.NA;
            p = 0;
            return (double)sign2 * ans;
        }
        if (p < endIndex && (s.charAt(p) == 'e' || s.charAt(p) == 'E')) {
            int expsign = 1;
            switch (s.charAt(++p)) {
                case '-': {
                    expsign = -1;
                    ++p;
                    break;
                }
                case '+': {
                    ++p;
                }
            }
            n = 0;
            while (p < endIndex && s.charAt(p) >= '0' && s.charAt(p) <= '9') {
                n = n * 10 + (s.charAt(p) - 48);
                ++p;
            }
            expn += expsign * n;
        }
        if (expn + ndigits < -300) {
            for (n = 0; n < ndigits; ++n) {
                ans /= 10.0;
            }
            expn += ndigits;
        }
        if (expn < -307) {
            n = -expn;
            fac = 1.0;
            while (n != 0) {
                if ((n & 1) != 0) {
                    fac /= p10;
                }
                n >>= 1;
                p10 *= p10;
            }
            ans *= fac;
        } else if (expn < 0) {
            n = -expn;
            fac = 1.0;
            while (n != 0) {
                if ((n & 1) != 0) {
                    fac *= p10;
                }
                n >>= 1;
                p10 *= p10;
            }
            ans /= fac;
        } else {
            n = expn;
            fac = 1.0;
            while (n != 0) {
                if ((n & 1) != 0) {
                    fac *= p10;
                }
                n >>= 1;
                p10 *= p10;
            }
            ans *= fac;
        }
        return (double)sign2 * ans;
    }

    private static boolean nextWordIgnoringCaseIs(CharSequence s, int start, int endIndex, String word) {
        int lenRemaining = endIndex - start;
        int wordLen = word.length();
        if (lenRemaining < wordLen) {
            return false;
        }
        for (int i = 0; i < wordLen; ++i) {
            if (Character.toUpperCase(s.charAt(start + i)) == word.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

