/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Attributes;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public abstract class AbstractSEXP
implements SEXP {
    protected AttributeMap attributes;
    private boolean object;

    protected AbstractSEXP() {
        this.attributes = AttributeMap.EMPTY;
        this.object = false;
    }

    protected AbstractSEXP(AttributeMap attributes2) {
        Preconditions.checkNotNull((Object)attributes2);
        this.attributes = attributes2;
        this.object = attributes2.hasClass();
    }

    protected boolean checkDims() {
        Vector dimVector = this.attributes.getDim();
        if (dimVector.length() == 0) {
            return true;
        }
        int length2 = 1;
        for (int i = 0; i != dimVector.length(); ++i) {
            length2 *= dimVector.getElementAsInt(i);
        }
        return length2 == this.length();
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public final boolean hasAttributes() {
        return this.attributes != AttributeMap.EMPTY;
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Logical asLogical() {
        return Logical.NA;
    }

    @Override
    public double asReal() {
        return DoubleVector.NA;
    }

    @Override
    public StringVector getS3Class() {
        SEXP classAttribute = this.attributes.getClassVector();
        if (classAttribute instanceof StringVector) {
            return (StringVector)classAttribute;
        }
        return new StringArrayVector(this.getImplicitClass());
    }

    @Override
    public String getImplicitClass() {
        return this.getTypeName();
    }

    @Override
    public boolean inherits(String sClassName) {
        if (this.isObject()) {
            Vector classes = (Vector)this.getAttribute(Symbols.CLASS);
            for (int i = 0; i != classes.length(); ++i) {
                if (!sClassName.equals(classes.getElementAsString(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AtomicVector getNames() {
        return this.attributes.getNamesOrNull();
    }

    @Override
    public String getName(int index) {
        StringVector names2;
        if (this.attributes.hasNames() && (names2 = this.attributes.getNames()).length() > 0) {
            return names2.getElementAsString(index);
        }
        return StringVector.NA;
    }

    @Override
    public final int getIndexByName(String name) {
        SEXP namesExp;
        if (this.attributes != null && (namesExp = this.attributes.get(Symbols.NAMES)) instanceof StringVector) {
            StringVector names2 = (StringVector)namesExp;
            for (int i = 0; i != names2.length(); ++i) {
                if (!Objects.equal((Object)names2.getElementAsString(i), (Object)name)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final boolean isObject() {
        return this.object;
    }

    @Override
    public SEXP getAttribute(Symbol name) {
        return this.attributes.get(name);
    }

    @Override
    public final SEXP setAttribute(String attributeName, SEXP value) {
        return this.setAttribute(Symbol.get(attributeName), value);
    }

    @Override
    public SEXP setAttribute(Symbol attributeName, SEXP value) {
        return this.cloneWithNewAttributes(this.replaceAttribute(attributeName, Attributes.validateAttribute(this, attributeName, value)));
    }

    @Override
    public SEXP setAttributes(AttributeMap attributes2) {
        return this.cloneWithNewAttributes(attributes2);
    }

    private AttributeMap replaceAttribute(Symbol attributeName, SEXP newValue) {
        return this.attributes.copy().set(attributeName, newValue).build();
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        if (attributes2 != AttributeMap.EMPTY) {
            throw new EvalException("cannot change/set attributes on " + this.getClass().getName(), new Object[0]);
        }
        return this;
    }

    @Override
    public String asString() {
        throw new EvalException("Cannot coerce " + this.getTypeName() + " to scalar string", new Object[0]);
    }

    @Override
    public <S extends SEXP> S getElementAsSEXP(int index) {
        if (index == 0) {
            return (S)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SEXP force(Context context) {
        return this;
    }

    public void unsafeSetAttributes(AttributeMap attributeMap) {
        this.attributes = attributeMap;
        this.object = this.attributes.hasClass();
    }
}

