/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.ConvertToString;
import org.jpedal.objects.acroforms.FormObject;
import org.jpedal.objects.acroforms.FormXObject;
import org.jpedal.objects.acroforms.OverStream;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FormStream
extends OverStream {
    private FormXObject appearanceObject = null;
    protected Map currentField;
    protected int keySize;
    protected String[] commands;
    private static boolean messageShown = false;

    protected FormStream() {
    }

    public FormStream(PdfObjectReader pdfObjectReader) {
        this.type = 2;
        this.currentPdfFile = pdfObjectReader;
        this.init();
    }

    protected void init() {
    }

    private FormObject createAppearanceString(FormObject formObject, Map map) {
        this.currentField = map;
        Object object = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (!this.addItem(object)) {
            return null;
        }
        this.parseStream(formObject);
        if (this.type != 1) {
            this.decodeStream(formObject);
        }
        if (debugSpecific) {
            System.out.println("createdParent=" + formObject);
        }
        return formObject;
    }

    public FormObject createAppearanceString(Map map, PdfObjectReader pdfObjectReader) {
        FormObject formObject = new FormObject();
        this.currentPdfFile = pdfObjectReader;
        this.currentField = map;
        Object object = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (object != null && !this.addItem(object)) {
            return null;
        }
        this.parseStream(formObject);
        if (this.type != 1) {
            this.decodeStream(formObject);
        }
        if (debugSpecific) {
            System.out.println("createdNormal=" + formObject);
        }
        return formObject;
    }

    protected void parseStream(FormObject formObject) {
        String string;
        formObject.setBorder(null);
        this.currentField.remove("P");
        this.createOrderedCommandArray();
        for (int i = 0; i < this.commands.length; ++i) {
            string = this.commands[i];
            Object object = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
            this.parseCommand(string, object, formObject);
        }
        if (formObject.fieldName == null) {
            Object object = this.currentPdfFile.resolveToMapOrString("Parent", this.currentField.get("Parent"));
            if (object instanceof Map) {
                string = (String)this.currentPdfFile.resolveToMapOrString("T", ((Map)object).get("T"));
                formObject.setFieldName(string);
            } else if (object != null) {
                // empty if block
            }
        }
    }

    private void createOrderedCommandArray() {
        Iterator iterator = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new String[this.keySize];
        int n = this.keySize - 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("AP")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("Kids")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("H")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("I")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            this.commands[n2] = string;
            ++n2;
        }
    }

    protected boolean parseCommand(String string, Object object, FormObject formObject) {
        boolean bl = false;
        if (string.equals("Parent")) {
            Map map;
            if (object instanceof Map && (map = (Map)object).containsKey("V")) {
                this.commandV(object, formObject);
            }
        } else if (string.equals("V")) {
            this.commandV(object, formObject);
        } else if (string.equals("Q")) {
            formObject.setHorizontalAlign(object);
        } else if (!string.equals("AP") && !string.equals("DA")) {
            if (string.equals("TU")) {
                formObject.setUserName((String)object);
                LogWriter.writeFormLog("{stream} userName NOT IMPLEMENTED=" + object, false);
            } else if (string.equals("T")) {
                formObject.setFieldName((String)object);
            } else if (string.equals("TM")) {
                formObject.setMapName((String)object);
                LogWriter.writeFormLog("{stream} mapName NOT IMPLEMENTED=" + object, false);
            } else if (string.equals("AS")) {
                String string2 = null;
                if (object instanceof Map) {
                    Map map = (Map)object;
                    map.remove("PageNumber");
                    if (map.containsKey("rawValue")) {
                        string2 = (String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue"));
                        if (map.size() > 1) {
                            LogWriter.writeFormLog("{stream} AS IS MAP UNKNOWN field=" + object, false);
                        }
                    } else {
                        LogWriter.writeFormLog("{stream} AS IS MAP field=" + object, false);
                    }
                } else {
                    string2 = (String)object;
                }
                string2 = Strip.checkRemoveLeadingSlach(string2);
                formObject.setDefaultState(string2);
            } else if (string.equals("F")) {
                this.workOutCharachteristic((String)object, formObject);
            } else if (!string.equals("Kids")) {
                if (string.equals("Opt")) {
                    formObject.valuesMap = new HashMap();
                    String[] stringArray = object instanceof String ? this.populateItemsArrayWithValues((String)object, formObject.valuesMap) : this.populateItemsArrayWithValues((String)this.currentPdfFile.resolveToMapOrString("rawValue", ((Map)object).get("rawValue")), formObject.valuesMap);
                    if (formObject.valuesMap.size() < 1) {
                        formObject.valuesMap = null;
                    }
                    formObject.setlistOfItems(stringArray);
                } else if (string.equals("BS")) {
                    formObject.setBorder(object);
                } else if (string.equals("Ti")) {
                    formObject.setTopIndex(new int[]{Integer.parseInt((String)object)});
                } else if (string.equals("MaxLen")) {
                    formObject.setMaxTextLength(Integer.parseInt((String)object));
                } else if (string.equals("Rect")) {
                    this.createBoundsRectangle((String)this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect")), formObject);
                } else if (string.equals("FT")) {
                    String string3 = null;
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        map.remove("PageNumber");
                        if (map.containsKey("rawValue")) {
                            string3 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue")));
                            if (map.size() > 1) {
                                LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + object, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} type IS MAP field=" + object, false);
                        }
                    } else {
                        string3 = Strip.checkRemoveLeadingSlach((String)object);
                    }
                    if (string3 != null) {
                        if (string3.equals("Btn")) {
                            formObject.setType(0);
                        } else if (string3.equals("Tx")) {
                            formObject.setType(2);
                        } else if (string3.equals("Ch")) {
                            formObject.setType(1);
                        } else if (string3.equals("Sig")) {
                            formObject.setType(3);
                        }
                    }
                } else if (string.equals("MK")) {
                    this.commandMK((Map)object, formObject);
                } else if (string.equals("Ff")) {
                    this.commandFf(formObject);
                } else if (string.equals("AA")) {
                    this.resolveAdditionalAction(object, formObject);
                } else if (!string.equals("Type")) {
                    if (string.equals("Subtype")) {
                        if (!object.equals("/Widget")) {
                            bl = true;
                        }
                    } else if (string.equals("PageNumber")) {
                        formObject.setPageNumber(object);
                    } else if (string.equals("StructParent")) {
                        LogWriter.writeFormLog("{stream} CHECK 'StructParent' NOT Implemented", false);
                    } else if (string.equals("A")) {
                        this.commandA(object, formObject);
                    } else if (string.equals("DV")) {
                        if (object instanceof String) {
                            formObject.setDefaultValue((String)object);
                        } else if (object instanceof Map) {
                            Map map = (Map)object;
                            if (map.containsKey("rawValue")) {
                                formObject.setDefaultValue((String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue")));
                            } else if (!map.containsKey("PageNumber")) {
                                LogWriter.writeFormLog("{stream} unknown entry as Map DV command NOT IMPLEMENTED field=" + map, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} unknown DV command NOT IMPLEMENTED field=" + object, false);
                        }
                    } else if (!string.equals("I") && !string.equals("H")) {
                        if (string.equals("DR")) {
                            if (object instanceof Map) {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text map UNIMPLEMENTED field", false);
                            } else {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text non map UNIMPLEMENTED field", false);
                            }
                        } else if (string.equals("Lock")) {
                            LogWriter.writeFormLog("{stream} Lock command UNIMPLEMENTED only needed for signiture fields, field=" + object, false);
                        } else if (!string.equals("NeedAppearances")) {
                            if (string.equals("NM")) {
                                this.commandNM(formObject, object);
                            } else if (!string.equals("obj")) {
                                LogWriter.writeFormLog("{stream} UNIMPLEMENTED command - " + string + " in form Stream=\n\t" + object, false);
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    protected void commandA(Object object, FormObject formObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("A", object);
        this.resolveAdditionalAction(hashMap, formObject);
    }

    private void commandFf(FormObject formObject) {
        String string = (String)this.currentPdfFile.resolveToMapOrString("Ff", this.currentField.get("Ff"));
        if (string != null) {
            int n = Integer.parseInt(string);
            boolean[] blArray = new boolean[32];
            blArray[1] = (n & 1) == 1;
            blArray[2] = (n & 2) == 2;
            blArray[3] = (n & 4) == 4;
            blArray[12] = (n & 0x1000) == 4096;
            blArray[13] = (n & 0x2000) == 8192;
            blArray[14] = (n & 0x4000) == 16384;
            blArray[15] = (n & 0x8000) == 32768;
            blArray[16] = (n & 0x10000) == 65536;
            blArray[17] = (n & 0x20000) == 131072;
            blArray[18] = (n & 0x40000) == 262144;
            blArray[19] = (n & 0x80000) == 524288;
            blArray[20] = (n & 0x100000) == 0x100000;
            blArray[21] = (n & 0x200000) == 0x200000;
            blArray[22] = (n & 0x400000) == 0x400000;
            blArray[23] = (n & 0x800000) == 0x800000;
            blArray[24] = (n & 0x1000000) == 0x1000000;
            blArray[25] = (n & 0x2000000) == 0x2000000;
            blArray[25] = (n & 0x2000000) == 0x2000000;
            blArray[26] = (n & 0x4000000) == 0x4000000;
            formObject.setFlags(blArray);
            if (blArray[3] || blArray[22] || blArray[24] || blArray[26]) {
                LogWriter.writeFormLog("{stream} new flags (3 22 24 26) UNIMPLEMENTED flags - 3=" + blArray[3] + " 22=" + blArray[22] + " 24=" + blArray[24] + " 26= " + blArray[26], false);
            }
        }
    }

    protected void commandNM(FormObject formObject, Object object) {
        formObject.setFieldName((String)object);
    }

    private void commandV(Object object, FormObject formObject) {
        Object object2;
        String string = null;
        if (object instanceof Map) {
            object2 = (Map)object;
            if (object2.containsKey("rawValue")) {
                string = (String)this.currentPdfFile.resolveToMapOrString("rawValue", object2.get("rawValue"));
            } else if (!object2.containsKey("Type") || !Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("Type", object2.get("Type"))).equals("Sig")) {
                LogWriter.writeFormLog("{stream} V Map UNKNOWN=" + object, false);
            }
        } else {
            string = (String)object;
        }
        if (string != null) {
            object2 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("FT", this.currentField.get("FT")));
            if (((String)object2).equals("Btn")) {
                String string2 = (String)this.currentPdfFile.resolveToMapOrString("Ff", this.currentField.get("Ff"));
                if (string2 != null) {
                    int n = Integer.parseInt(string2);
                    if ((n & 0x8000) == 32768) {
                        formObject.setChildOnState(string);
                    } else if ((n & 0x10000) != 65536) {
                        formObject.setCurrentState(string);
                    }
                } else {
                    formObject.setCurrentState(string);
                }
            } else if (((String)object2).equals("Tx")) {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = stringBuffer.length();
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    char c = stringBuffer.charAt(i);
                    if (c == '\\') {
                        if ((c = stringBuffer.charAt(++i)) == 't') {
                            stringBuffer2.append('\t');
                            continue;
                        }
                        if (c == 'n') {
                            stringBuffer2.append('\n');
                            continue;
                        }
                        if (c == 'r') {
                            stringBuffer2.append('\r');
                            continue;
                        }
                        stringBuffer2.append(c);
                        continue;
                    }
                    stringBuffer2.append(c);
                }
                formObject.setTextValue(stringBuffer2.toString());
            } else if (((String)object2).equals("Ch")) {
                String string3 = (String)this.currentPdfFile.resolveToMapOrString("V", string);
                formObject.setSelectedItem(string3);
            } else if (((String)object2).equals("Sig")) {
                LogWriter.writeFormLog("{stream} value - signiture value NOT IMPLEMENTED field=" + string, false);
            } else {
                LogWriter.writeFormLog("{stream} NOT IMPLEMENTED command=V field=" + string + " currentField=" + ConvertToString.convertMapToString(this.currentField, this.currentPdfFile), false);
            }
        }
    }

    private void resolveAdditionalAction(Object object, FormObject formObject) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string = (String)iterator.next();
                if (string.equals("A")) {
                    object5 = map.get("A");
                    if (object5 instanceof String) {
                        object5 = this.currentPdfFile.readObject((String)object5, false, null);
                    }
                    if ((object4 = this.currentPdfFile.resolveToMapOrString("A", object5)) instanceof Map) {
                        object3 = (Map)object4;
                        object2 = new HashMap<String, Object>();
                        if (object3.containsKey("S")) {
                            Object object6;
                            String string2 = (String)this.currentPdfFile.resolveToMapOrString("S", object3.get("S"));
                            if ((string2 = Strip.checkRemoveLeadingSlach(string2)).equals("Named")) {
                                if (object3.containsKey("N")) {
                                    object6 = (String)this.currentPdfFile.resolveToMapOrString("N", object3.get("N"));
                                    if (((String)(object6 = Strip.checkRemoveLeadingSlach((String)object6))).equals("Print")) {
                                        LogWriter.writeFormLog("Named Action=Print PageNumber=" + this.currentPdfFile.resolveToMapOrString("PageNumber", object3.get("PageNumber")), false);
                                        object2.put("Print", "currentPage");
                                    } else if (((String)object6).equals("SaveAs")) {
                                        LogWriter.writeFormLog("Named Action=SaveAs pagenumber=" + this.currentPdfFile.resolveToMapOrString("Pagenumber", object3.get("PageNumber")), false);
                                        object2.put("SaveAs", "currentPage");
                                    } else if (!((String)object6).startsWith("AcroForm:")) {
                                        if (((String)object6).startsWith("NextPage")) {
                                            LogWriter.writeFormLog("Named action NextPage NOT implemented" + (String)object6, false);
                                        } else if (!((String)object6).startsWith("ZoomTo")) {
                                            if (((String)object6).startsWith("FullScreen")) {
                                                LogWriter.writeFormLog("Named action FullScreen NOT implemented" + (String)object6, false);
                                            } else {
                                                LogWriter.writeFormLog("{stream} Named Action NOT IMPLEMENTED command=" + (String)object6 + " field=" + ConvertToString.convertMapToString((Map)object3, this.currentPdfFile), false);
                                            }
                                        }
                                    }
                                }
                            } else if (string2.equals("ResetForm")) {
                                object2.put("ResetForm", Boolean.TRUE);
                            } else if (string2.equals("SubmitForm")) {
                                if (object3.containsKey("Fields")) {
                                    object6 = new StringTokenizer((String)object3.get("Fields"), "[]()");
                                    String string3 = null;
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while (((StringTokenizer)object6).hasMoreTokens()) {
                                        String string4 = ((StringTokenizer)object6).nextToken();
                                        if (string4.indexOf(".x") != -1) {
                                            string3 = string4.substring(string4.indexOf(".") + 1, string4.indexOf(".x") + 1);
                                        }
                                        if (string4.indexOf(" R") == -1) continue;
                                        string4 = (String)this.currentPdfFile.readObject(string4.trim(), false, null).get("T");
                                        if (string3 != null) {
                                            stringBuffer.append(string3);
                                        }
                                        stringBuffer.append(string4.substring(1, string4.length() - 1));
                                        stringBuffer.append(',');
                                    }
                                    object3.put("Fields", stringBuffer.toString());
                                }
                                object2.put("SubmitForm", object3);
                            } else if (string2.equals("JavaScript")) {
                                LogWriter.writeFormLog("{stream} JavaScript field=" + ConvertToString.convertMapToString((Map)object3, this.currentPdfFile), false);
                            } else if (string2.equals("Hide")) {
                                object6 = new HashMap();
                                this.getHideMap((Map)object3, (Map)object6);
                                object2.put("Hide", object6);
                            } else if (string2.equals("URI")) {
                                object6 = this.removeBrackets((String)object3.get("URI"));
                                object2.put("URL", object6);
                            } else if (string2.equals("Launch")) {
                                LogWriter.writeFormLog("{stream} launch activate action NOT IMPLEMENTED", false);
                            } else if (string2.equals("GoTo")) {
                                LogWriter.writeFormLog("{FormStream.resolveAdditionalAction} /GoTo action NOT IMPLEMENTED", false);
                            } else {
                                LogWriter.writeFormLog("{stream} UNKNOWN command for Activate Action command=" + string2 + " field=" + ConvertToString.convertMapToString((Map)object3, this.currentPdfFile), false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} Activate Action UNKNOWN command NOT IMPLEMENTED field=" + ConvertToString.convertMapToString((Map)object3, this.currentPdfFile), false);
                        }
                        formObject.setActivateAction((Map)object2);
                        continue;
                    }
                    LogWriter.writeFormLog("{stream} A additionalAction NON Map UNIMPLEMENTED", false);
                    continue;
                }
                if (string.equals("E")) {
                    object5 = (Map)this.currentPdfFile.resolveToMapOrString("E", map.get("E"));
                    object4 = (String)this.currentPdfFile.resolveToMapOrString("S", object5.get("S"));
                    object5.put("command", object4);
                    object5.remove("S");
                    if (object5.containsKey("T")) {
                        object3 = this.currentPdfFile.resolveToMapOrString("T", object5.get("T"));
                        object5.put("fields", object3);
                        object5.remove("T");
                    }
                    object3 = Boolean.TRUE;
                    if (object5.containsKey("H")) {
                        object3 = Boolean.valueOf((String)this.currentPdfFile.resolveToMapOrString("H", object5.get("H")));
                    }
                    object5.put("hide", object3);
                    object5.remove("H");
                    formObject.setEnteredAction((Map)object5);
                    continue;
                }
                if (string.equals("X")) {
                    object5 = (Map)this.currentPdfFile.resolveToMapOrString("X", map.get("X"));
                    object4 = (String)this.currentPdfFile.resolveToMapOrString("S", object5.get("S"));
                    object5.put("command", object4);
                    object5.remove("S");
                    if (object5.containsKey("T")) {
                        object3 = this.currentPdfFile.resolveToMapOrString("T", object5.get("T"));
                        object5.put("fields", object3);
                        object5.remove("T");
                    }
                    object3 = Boolean.TRUE;
                    if (object5.containsKey("H")) {
                        object3 = Boolean.valueOf((String)this.currentPdfFile.resolveToMapOrString("H", object5.get("H")));
                    }
                    object5.put("hide", object3);
                    object5.remove("H");
                    formObject.setExitedAction((Map)object5);
                    continue;
                }
                if (string.equals("K")) {
                    LogWriter.writeFormLog("{stream} NOT IMPLEMENTED K command in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString("K", map.get("K")), false);
                    continue;
                }
                if (string.equals("C")) {
                    LogWriter.writeFormLog("{stream} NOT IMPLEMENTED C command in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString("C", map.get("C")), false);
                    continue;
                }
                if (string.equals("D")) {
                    LogWriter.writeFormLog("{stream} NOT IMPLEMENTED D command in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString("D", map.get("D")), false);
                    continue;
                }
                if (string.equals("F")) {
                    LogWriter.writeFormLog("{stream} NOT IMPLEMENTED F command in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString("F", map.get("F")), false);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                if (string.equals("Bl")) {
                    LogWriter.writeFormLog("{stream} NOT IMPLEMENTED Bl command in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString("B1", map.get("B1")), false);
                    continue;
                }
                if (string.equals("V")) {
                    object5 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (!(object5 instanceof Map) || !((String)(object3 = (String)(object4 = (Map)object5).get("S"))).equals("/JavaScript")) continue;
                    object2 = (String)object4.get("JS");
                    formObject.setValidateValueCommand((String)object2);
                    continue;
                }
                LogWriter.writeFormLog("{stream} " + string + " NOT IMPLEMENTED in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString(string, map.get(string)), false);
            }
        } else {
            LogWriter.writeFormLog("{stream} AdditionAction is String UNIMPLEMENTED", false);
        }
    }

    private String removeBrackets(String string) {
        return string.substring(1, string.length() - 2);
    }

    private void getHideMap(Map map, Map map2) {
        Boolean[] booleanArray;
        String[] stringArray;
        Object object;
        if (!Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("S", map.get("S"))).equals("Hide")) {
            LogWriter.writeFormLog("{stream} getHideMap has a NON Hide value field=" + map, false);
        }
        if (map2.containsKey("fields")) {
            object = (String[])map2.get("fields");
            stringArray = new String[((String[])object).length + 1];
            System.arraycopy(object, 0, stringArray, 0, ((String[])object).length);
            stringArray[stringArray.length - 1] = (String)this.currentPdfFile.resolveToMapOrString("T", map.get("T"));
        } else {
            stringArray = new String[]{(String)this.currentPdfFile.resolveToMapOrString("T", map.get("T"))};
        }
        map2.put("fields", stringArray);
        object = Boolean.TRUE;
        if (map.containsKey("H")) {
            object = Boolean.valueOf((String)this.currentPdfFile.resolveToMapOrString("H", map.get("H")));
        }
        if (map2.containsKey("hide")) {
            Boolean[] booleanArray2 = (Boolean[])map2.get("hide");
            booleanArray = new Boolean[booleanArray2.length + 1];
            System.arraycopy(booleanArray2, 0, booleanArray, 0, booleanArray2.length);
            booleanArray[booleanArray.length - 1] = object;
        } else {
            booleanArray = new Boolean[]{object};
        }
        map2.put("hide", booleanArray);
        if (map.containsKey("Next")) {
            this.getHideMap((Map)this.currentPdfFile.resolveToMapOrString("Next", map.get("Next")), map2);
        }
    }

    private void trickleThroughMaps(Map map, String string, boolean bl, boolean bl2, FormObject formObject) {
        if (string.equals("N")) {
            this.N(map, bl, bl2, formObject);
        } else if (string.equals("D")) {
            this.D(map, bl, bl2, formObject);
        } else if (string.equals("R")) {
            this.R(map, bl, bl2, formObject);
        } else {
            LogWriter.writeFormLog("{stream} NOT SINGLED in Trickle " + string + "=", bl2);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                Object object2 = this.currentPdfFile.resolveToMapOrString(string2, map.get(string2));
                if (object2 instanceof Map) {
                    object = (Map)object2;
                    this.trickleThroughMaps((Map)object, string2, bl, bl2, formObject);
                    continue;
                }
                if (string2.equals("SW")) {
                    object = Strip.checkRemoveLeadingSlach((String)object2);
                    if (((String)object).equals("N")) continue;
                    LogWriter.writeFormLog("{stream} UNIMPLEMENTED SW field=" + object2, bl2);
                    continue;
                }
                if (string2.equals("PageNumber")) continue;
                LogWriter.writeFormLog("{stream} NON SINGLED command=" + string2 + " field=" + object2, bl2);
            }
        }
    }

    protected boolean commandAP(Map map, FormObject formObject) {
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            if (!(object instanceof Map)) continue;
            this.trickleThroughMaps((Map)object, string, false, false, formObject);
        }
        bl = true;
        return bl;
    }

    private void resolveKidsArray(Object object, boolean bl, boolean bl2, FormObject formObject) {
        boolean bl3 = false;
        StringTokenizer stringTokenizer = null;
        Map map = null;
        Iterator iterator = null;
        HashMap<String, FormObject> hashMap = new HashMap<String, FormObject>();
        if (object instanceof String) {
            bl3 = true;
        }
        if (!bl3) {
            map = (Map)object;
            iterator = map.keySet().iterator();
        } else {
            stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object), "R");
        }
        while (!bl3 && iterator.hasNext() || bl3 && stringTokenizer.hasMoreTokens()) {
            Object object2;
            String string;
            if (!bl3) {
                string = (String)iterator.next();
                object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            } else {
                string = stringTokenizer.nextToken().trim() + " R";
                object2 = this.currentPdfFile.readObject(string, false, null);
            }
            if (!(object2 instanceof Map)) continue;
            FormObject formObject2 = formObject.duplicate();
            hashMap.put(string, this.createAppearanceString(formObject2, (Map)object2));
        }
        formObject.setKidData(hashMap);
    }

    private void N(Map map, boolean bl, boolean bl2, FormObject formObject) {
        block13: {
            Object object;
            block12: {
                if (map.containsKey("MK")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString("MK", map.get("MK"));
                    this.commandMK((Map)object, formObject);
                }
                if (map.containsKey("CachedStream")) {
                    this.currentPdfFile.readStreamIntoMemory(map);
                }
                if (!map.containsKey("DecodedStream")) break block12;
                if (formObject.hasNormalOff()) break block13;
                if (this.appearanceObject == null) {
                    this.appearanceObject = new FormXObject(this.currentPdfFile);
                }
                formObject.setNormalAppOff(this.appearanceObject.decode(map), null);
                if (!showIconsOnCreate) break block13;
                ShowGUIMessage.showGUIMessage("N normalAppImage", formObject.normalOffImage, "normalAppImage");
                break block13;
            }
            object = map.keySet().iterator();
            while (object.hasNext()) {
                Object object2;
                String string = (String)object.next();
                if (string.equals("Off")) {
                    object2 = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.appearanceObject.decode((Map)object2), string);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("N normalAppOff", formObject.normalOffImage, "normalAppOff");
                    continue;
                }
                if (string.equals("On")) {
                    object2 = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.appearanceObject.decode((Map)object2), string);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("normalAppOn", formObject.normalOnImage, "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                formObject.setStateToCheck(string);
                object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object2 instanceof Map) {
                    Map map2 = (Map)object2;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.appearanceObject.decode(map2), string);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("N normalAppOn", formObject.normalOnImage, "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.N stateTocheck=" + string + " field=" + object2, bl2);
            }
        }
    }

    private void R(Map map, boolean bl, boolean bl2, FormObject formObject) {
        if (map.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Rollover appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", map.get("MK")), bl2);
        }
        if (map.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(map);
        }
        if (map.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setRolloverAppOff(this.appearanceObject.decode(map));
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if (string.equals("Off")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOff(this.appearanceObject.decode((Map)object));
                    continue;
                }
                if (string.equals("On")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.appearanceObject.decode((Map)object));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.appearanceObject.decode(map2));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.R stateTocheck=" + string + " field=" + object, bl2);
            }
        }
    }

    private void D(Map map, boolean bl, boolean bl2, FormObject formObject) {
        if (map.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Down appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", map.get("MK")), bl2);
        }
        if (map.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(map);
        }
        if (map.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setDownAppOff(this.appearanceObject.decode(map));
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if (string.equals("Off")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOff(this.appearanceObject.decode((Map)object));
                    continue;
                }
                if (string.equals("On")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.appearanceObject.decode((Map)object));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.appearanceObject.decode(map2));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.D stateTocheck=" + string + " field=" + object, bl2);
            }
        }
    }

    protected void commandMK(Map map, FormObject formObject) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            Object object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            if (string.equals("CA")) {
                formObject.setNormalCaption((String)object2);
                continue;
            }
            if (string.equals("BC")) {
                object = this.generateColorFromString((String)object2);
                formObject.setBorderColor((Color)object);
                continue;
            }
            if (string.equals("BG")) {
                object = this.generateColorFromString((String)object2);
                formObject.setBackgroundColor((Color)object);
                continue;
            }
            if (string.equals("R")) {
                formObject.setRotation(Integer.parseInt((String)object2));
                continue;
            }
            if (string.equals("RC")) {
                formObject.setRolloverCaption((String)object2);
                continue;
            }
            if (string.equals("AC")) {
                formObject.setDownCaption((String)object2);
                continue;
            }
            if (string.equals("I")) {
                if (object2 instanceof Map) {
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.appearanceObject.decode((Map)object2), null);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("MKI normalAppImage", formObject.normalOffImage, "normalAppImage");
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK I NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("RI")) {
                LogWriter.writeFormLog("{stream} MK RI NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("IX")) {
                LogWriter.writeFormLog("{stream} MK IX NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("IF")) {
                if (object2 instanceof Map) {
                    object = (Map)object2;
                    if (object.containsKey("SW")) {
                        String string2 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("SW", object.get("SW")));
                        if (string2.equals("A")) {
                            formObject.setWhenToScaleIcon("A");
                            continue;
                        }
                        if (string2.equals("N")) {
                            formObject.setWhenToScaleIcon("N");
                            continue;
                        }
                        LogWriter.writeFormLog("{stream} MK IF Map Unimplemented command=" + string2 + " field=" + object2, false);
                        continue;
                    }
                    if (object.size() < 1) continue;
                    LogWriter.writeFormLog("{stream} MK IF unknown command type field=" + object, false);
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK IF String NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("TP")) {
                formObject.setTextPosition(Integer.parseInt((String)object2));
                continue;
            }
            if (string.equals("PageNumber")) continue;
            LogWriter.writeFormLog("{stream} MK command NOT IMPLEMENTED command=" + string, false);
        }
    }

    private String[] populateItemsArrayWithValues(String string, Map map) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]()\\", true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object object = null;
        String string2 = null;
        String[] stringArray2 = new String[2];
        int n4 = 0;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("\\") && !bl2) {
                bl2 = true;
                continue;
            }
            bl2 = false;
            if (string2.equals("(")) {
                if (++n2 == 1) {
                    bl = true;
                    object = new StringBuffer();
                    continue;
                }
                ((StringBuffer)object).append(string2);
                continue;
            }
            if (string2.equals(")")) {
                if (--n2 == 0) {
                    bl = false;
                    if (n3 < 2) {
                        stringArray[n++] = ((StringBuffer)object).toString();
                        continue;
                    }
                    if (n4 >= 2) continue;
                    stringArray2[n4++] = ((StringBuffer)object).toString();
                    continue;
                }
                ((StringBuffer)object).append(string2);
                continue;
            }
            if (!bl && string2.equals("[")) {
                ++n3;
                continue;
            }
            if (n3 > 1 && string2.equals("]")) {
                if (--n3 != 1) continue;
                if (n4 == 2) {
                    map.put(stringArray2[0], stringArray2[1]);
                    n4 = 0;
                }
                stringArray[n++] = ((StringBuffer)object).toString();
                continue;
            }
            if (!bl) continue;
            ((StringBuffer)object).append(string2);
        }
        if (n2 != 0) {
            stringArray[n++] = ((StringBuffer)object).toString();
        }
        object = new String[n];
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            object[n] = stringArray[n].trim();
        }
        stringArray = object;
        return stringArray;
    }

    protected void decodeStream(FormObject formObject) {
        for (int i = 0; i < this.keySize; ++i) {
            String string = this.commands[i];
            Object object = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
            this.decodeFormCommand(string, object, formObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean decodeFormCommand(String string, Object object, FormObject formObject) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (string.equals("AP")) {
            boolean bl2 = this.commandAP((Map)object, formObject);
            if (bl2) return bl;
        }
        if (string.equals("I")) {
            String[] stringArray = formObject.itemsList;
            String string2 = Strip.removeArrayDeleminators((String)object);
            if (string2.indexOf(" ") == -1) return bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
            formObject.setTopIndex(nArray);
            return bl;
        } else if (string.equals("H")) {
            this.commandH(object, formObject);
            return bl;
        } else if (string.equals("Kids")) {
            this.resolveKidsArray(object, false, false, formObject);
            return bl;
        } else {
            Object object2;
            Object object3;
            if (!string.equals("DA")) return true;
            byte[] byArray = new byte[]{};
            if (object instanceof Map) {
                object3 = (Map)object;
                object3.remove("PageNumber");
                if (object3.containsKey("rawValue")) {
                    object2 = this.currentPdfFile.resolveToMapOrString("rawValue", object3.get("rawValue"));
                    byArray = object2 instanceof byte[] ? (byte[])object2 : ((String)object2).getBytes();
                    this.decodeFontCommandObj((String)this.currentPdfFile.resolveToMapOrString("rawValue", object3.get("rawValue")), formObject);
                    if (object3.size() > 1) {
                        LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + object, false);
                    }
                } else {
                    LogWriter.writeFormLog("{stream} DA IS MAP field=" + object, false);
                }
            } else {
                object3 = object;
                byArray = object3 instanceof byte[] ? (byte[])object3 : ((String)object3).getBytes();
                this.decodeFontCommandObj((String)object, formObject);
            }
            object3 = formObject.contents;
            if (object3 == null) return bl;
            object2 = ((String)object3).getBytes();
            int n = byArray.length;
            byte[] byArray2 = new byte[n + ((Object)object2).length];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = i < n ? byArray[i] : (byte)object2[i - n];
            }
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
            pdfStreamDecoder.decodeStreamIntoObjects(byArray2);
            StringBuffer stringBuffer = pdfStreamDecoder.getlastTextStreamDecoded();
            if (stringBuffer == null) return bl;
            formObject.setTextValue(stringBuffer.toString());
        }
        return bl;
    }

    protected void commandH(Object object, FormObject formObject) {
        String string = Strip.checkRemoveLeadingSlach((String)object);
        if (string.equals("T") || string.equals("P")) {
            if (!formObject.hasDownImage()) {
                formObject.setOffsetDownApp();
            }
        } else if (string.equals("N")) {
            formObject.setNoDownIcon();
        } else if (string.equals("I")) {
            formObject.setInvertForDownIcon();
        } else if (!string.equals("O")) {
            LogWriter.writeFormLog("{FormStream.commandH} H command NOT IMPLEMENTED field=" + object, false);
        }
    }
}

