/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.FontFactory;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private int pageNumber = 0;
    private String rawKey = null;
    private PdfPaint fillCol = null;
    private PdfPaint strokeCol = null;
    private static boolean flagException = false;
    int defaultSize = 5000;
    int endItem = -1;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private ObjectStore objectStoreRef;
    private boolean isPrinting;
    private static Map cachedWidths = new HashMap();
    private static Map cachedHeights = new HashMap();
    private Map fonts = new HashMap();
    private Map fontsUsed = new HashMap();
    protected GlyphFactory factory = null;
    private PdfGlyphs glyphs;
    private int displayMode = 1;
    private boolean isType3Font = false;
    private static int glyphT3Count;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap();
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private static final int TEXT = 1;
    private static final int SHAPE = 2;
    private static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    public static final int TR = 15;
    public static final int STRING = 16;
    public static final int STROKEOPACITY = 17;
    public static final int FILLOPACITY = 18;
    public static final int STROKEDSHAPE = 19;
    public static final int FILLEDSHAPE = 20;
    public static final int FONTSIZE = 21;
    public static final int LINEWIDTH = 22;
    public static final int MARKER = 200;
    public static final boolean debugStreams = false;
    private boolean addBackground = true;
    private boolean pageDrawing = false;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet = false;
    private boolean strokeSet = false;
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private AffineTransform aff = new AffineTransform();
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    private boolean renderFailed;
    private JFrame frame = null;
    private static boolean userAlerted;
    boolean hasClips = false;
    Area lastClip = null;
    private double cropX;
    private double cropH;
    private float scaling;

    public DynamicVectorRenderer(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n2);
    }

    private void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
    }

    public DynamicVectorRenderer(int n, ObjectStore objectStore, boolean bl) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(this.defaultSize);
    }

    public void setDisplayView(int n) {
        this.displayMode = n;
    }

    public final void renderText(int n, Area area, Graphics2D graphics2D, boolean bl, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, Rectangle rectangle) {
        if (bl && pdfPaint instanceof Color) {
            Color color = (Color)((Object)pdfPaint);
            if (color == null) {
                color = (Color)((Object)pdfPaint2);
            }
            Color color2 = this.setHighlightedColor(color, graphics2D);
            graphics2D.fill(rectangle);
            graphics2D.setPaint(color2);
        } else {
            Composite composite = graphics2D.getComposite();
            if ((n & 2) == 2) {
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                graphics2D.setPaint(pdfPaint2);
                if (bl) {
                    Color color = (Color)((Object)pdfPaint2);
                    Color color3 = this.setHighlightedColor(color, graphics2D);
                    graphics2D.fill(rectangle);
                    graphics2D.setPaint(color3);
                } else {
                    graphics2D.setPaint(pdfPaint2);
                }
                if (f2 != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                }
                graphics2D.fill(area);
                graphics2D.setComposite(composite);
            }
            if ((n & 1) == 1) {
                if (pdfPaint != null) {
                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                }
                graphics2D.setPaint(pdfPaint);
                if (f != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                }
                graphics2D.draw(area);
                graphics2D.setComposite(composite);
            }
        }
    }

    public final void renderEmbeddedText(int n, Object object, int n2, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, Rectangle rectangle, int n3) {
        PdfGlyph pdfGlyph = FontFactory.chooseGlpyh(n2, object);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (pdfGlyph != null) {
            Stroke stroke = graphics2D.getStroke();
            if (n3 != 0) {
                graphics2D.setStroke(new BasicStroke(n3));
            }
            Color color = null;
            if (pdfPaint != null && pdfPaint instanceof Color) {
                color = (Color)((Object)pdfPaint);
            } else if (pdfPaint == null && pdfPaint2 instanceof Color) {
                color = (Color)((Object)pdfPaint2);
            }
            if (color != null && bl && n2 != 6) {
                Color color2 = this.setHighlightedColor(color, graphics2D);
                graphics2D.fill(rectangle);
                graphics2D.setPaint(color2);
                graphics2D.transform(affineTransform);
                try {
                    pdfGlyph.render(n, graphics2D, false, this.scaling);
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " rendering glyph");
                    exception.printStackTrace();
                }
            } else {
                graphics2D.transform(affineTransform);
                Composite composite = graphics2D.getComposite();
                if ((n & 2) == 2) {
                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                    graphics2D.setPaint(pdfPaint2);
                    if (f2 != 1.0f) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                    }
                    pdfGlyph.render(2, graphics2D, false, this.scaling);
                    graphics2D.setComposite(composite);
                } else if ((n & 1) == 1) {
                    if (pdfPaint != null) {
                        pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                    }
                    graphics2D.setPaint(pdfPaint);
                    if (f != 1.0f) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    }
                    try {
                        pdfGlyph.render(1, graphics2D, false, this.scaling);
                    }
                    catch (Exception exception) {
                        System.out.println("Exception " + exception + " rendering glyph");
                        exception.printStackTrace();
                    }
                    graphics2D.setComposite(composite);
                }
            }
            graphics2D.setTransform(affineTransform2);
            if (n3 != 0) {
                graphics2D.setStroke(stroke);
            }
        }
    }

    private Color setHighlightedColor(Color color, Graphics2D graphics2D) {
        int n;
        int n2;
        Color color2 = null;
        int n3 = 255 - color.getRed();
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = 255 - color.getGreen()) < 0) {
            n2 = -n2;
        }
        if ((n = 255 - color.getBlue()) < 0) {
            n = -n;
        }
        if (n3 > 120 && n3 < 136 && n2 > 120 && n2 < 136 && n > 120 & n < 136) {
            graphics2D.setPaint(Color.black);
            color2 = Color.white;
        } else {
            graphics2D.setPaint(color);
            color2 = new Color(n3, n2, n);
        }
        return color2;
    }

    public final void renderImage(AffineTransform affineTransform, BufferedImage bufferedImage, float f, GraphicsState graphicsState, Graphics2D graphics2D, float f2, float f3) {
        Object[] objectArray;
        float f4;
        Object object;
        boolean bl;
        boolean bl2 = bl = graphicsState != null;
        if (bufferedImage == null) {
            return;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        AffineTransform affineTransform2 = new AffineTransform();
        boolean bl3 = false;
        if (bl || this.useHiResImageForDisplay) {
            if (bl) {
                object = graphicsState.CTM;
                bufferedImage = this.invertImage((float[][])object, bufferedImage);
                affineTransform2 = new AffineTransform(object[0][0] / (float)n, object[0][1] / (float)n, object[1][0] / (float)n2, (float)(object[1][1] / (float)n2), (float)object[2][0], (float)object[2][1]);
            } else {
                affineTransform2 = affineTransform;
            }
            bl3 = true;
        } else if (n2 > 1 && (f4 = (float)PdfDecoder.dpi) != 72.0f) {
            affineTransform2.scale(72.0f / f4, 72.0f / f4);
            affineTransform2.translate(0.0, (float)n2 * (f4 / 72.0f - 1.0f));
            bl3 = true;
        }
        object = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
        Composite composite = graphics2D.getComposite();
        Shape shape = graphics2D.getClip();
        if (this.colorsLocked) {
            objectArray = new int[4];
            int n3 = this.fillCol.getRGB();
            objectArray[0] = n3 >> 16 & 0xFF;
            objectArray[1] = n3 >> 8 & 0xFF;
            objectArray[2] = n3 & 0xFF;
            objectArray[3] = 255;
            if (objectArray[0] != 0 || objectArray[1] != 0 || objectArray[2] != 0) {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                WritableRaster writableRaster = bufferedImage.getRaster();
                WritableRaster writableRaster2 = bufferedImage2.getRaster();
                for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                    for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                        int[] nArray = new int[4];
                        writableRaster.getPixel(j, i, nArray);
                        if (nArray[3] <= 2) continue;
                        writableRaster2.setPixel(j, i, (int[])objectArray);
                    }
                }
                bufferedImage = bufferedImage2;
            }
        }
        if (bl || this.useHiResImageForDisplay) {
            try {
                graphics2D.drawImage(bufferedImage, affineTransform2, null);
            }
            catch (Exception exception) {}
        } else {
            try {
                if (this.isType3Font && PdfDecoder.optimiseType3Rendering) {
                    double d;
                    objectArray = new double[6];
                    AffineTransform affineTransform3 = graphics2D.getTransform();
                    graphics2D.translate(f2, f3);
                    graphics2D.getTransform().getMatrix((double[])objectArray);
                    int n4 = bufferedImage.getWidth();
                    int n5 = bufferedImage.getHeight();
                    double d2 = (double)n4 * objectArray[0];
                    if (d2 == 0.0) {
                        d2 = (int)((double)n4 * objectArray[1]);
                    }
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    if (d2 > (double)n4) {
                        d2 = n4;
                    }
                    if ((d = (double)n5 * objectArray[3]) == 0.0) {
                        d = (double)n5 * objectArray[2];
                    }
                    if (d < 0.0) {
                        d = -d;
                    }
                    float f5 = 0.0f;
                    d += (double)f5;
                    d2 += (double)f5;
                    if (d >= 1.0 && d2 >= 1.0) {
                        int n6;
                        graphics2D.setTransform(new AffineTransform(1.0, 0.0, 0.0, -1.0, (double)objectArray[4], (double)objectArray[5]));
                        bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
                        double d3 = (d - (double)((int)d)) * (double)this.scaling;
                        int n7 = objectArray[5] - (double)objectArray[5];
                        double d4 = (d2 - (double)((int)d2)) * (double)this.scaling;
                        if (d4 > 1.0) {
                            n6 = (int)d4;
                            d4 -= (double)n6;
                            d2 += (double)n6;
                        }
                        if (d3 > 1.0) {
                            n6 = (int)d3;
                            d3 -= (double)n6;
                            d += (double)n6;
                        }
                        Image image = bufferedImage.getScaledInstance((int)d2, (int)d, 4);
                        if (n7 < 0.5) {
                            graphics2D.translate(0, -1);
                        }
                        graphics2D.drawImage(image, 0, 0, null);
                    } else {
                        bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
                        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    }
                    graphics2D.setTransform(affineTransform3);
                } else {
                    if (bl3) {
                        bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
                    }
                    graphics2D.translate(f2, f3);
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.translate(-f2, -f3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (PdfDecoder.isRunningOnMac && shape != null) {
            graphics2D.setClip(shape);
        }
        graphics2D.setComposite(composite);
    }

    public final void renderShape(int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape, Graphics2D graphics2D, float f, float f2) {
        Composite composite = graphics2D.getComposite();
        if (n == 2 | n == 3) {
            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint2);
            if (f2 != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            }
            graphics2D.fill(shape);
            graphics2D.setComposite(composite);
        }
        if (n == 1 | n == 3) {
            Shape shape2;
            Stroke stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint);
            if (f != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            if ((shape2 = graphics2D.getClip()) != null && (shape2.getBounds2D().getHeight() < 1.0 || shape2.getBounds2D().getWidth() < 1.0)) {
                graphics2D.setClip(null);
            }
            graphics2D.draw(shape);
            graphics2D.setClip(shape2);
            graphics2D.setStroke(stroke2);
            graphics2D.setComposite(composite);
        }
    }

    public void flush() {
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[this.defaultSize];
            this.y_coord = new float[this.defaultSize];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues.clear();
            }
            if (this.fs != null) {
                this.fs.clear();
            }
            if (this.lw != null) {
                this.lw.clear();
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = color;
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle[] rectangleArray, int n, int n2) {
        this.xx = n < 0 ? n : 0;
        this.yy = n2 < 0 ? n2 : 0;
        this.paint(graphics2D, rectangleArray, null, null, false);
    }

    public Rectangle paint(Graphics2D graphics2D, Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle, boolean bl) {
        Object object;
        int n = 0;
        if (!this.isType3Font) {
            glyphT3Count = 0;
        }
        if (!this.pageDrawing) {
            Shape shape;
            this.pageDrawing = true;
            object = null;
            int[] nArray = this.objectType.get();
            int[] nArray2 = this.textFillType.get();
            int n2 = nArray.length;
            Area[] areaArray = this.clips.get();
            double[] dArray = this.af1.get();
            int[] nArray3 = null;
            if (this.fs != null) {
                nArray3 = this.fs.get();
            }
            int[] nArray4 = null;
            if (this.lw != null) {
                nArray4 = this.lw.get();
            }
            double[] dArray2 = this.af2.get();
            double[] dArray3 = this.af3.get();
            double[] dArray4 = this.af4.get();
            Object[] objectArray = this.text_color.get();
            Object[] objectArray2 = this.fill_color.get();
            Object[] objectArray3 = this.stroke_color.get();
            Object[] objectArray4 = this.pageObjects.get();
            Object[] objectArray5 = this.javaObjects.get();
            Object[] objectArray6 = this.stroke.get();
            int[] nArray5 = this.shapeType.get();
            float[] fArray = null;
            if (this.opacity != null) {
                fArray = this.opacity.get();
            }
            int[] nArray6 = null;
            if (this.TRvalues != null) {
                nArray6 = this.TRvalues.get();
            }
            if ((shape = graphics2D.getClip()) != null) {
                object = shape.getBounds();
            }
            boolean bl2 = false;
            Shape shape2 = graphics2D.getClip();
            Area area = null;
            boolean bl3 = false;
            if (!bl) {
                this.paintBackground(graphics2D, (Rectangle)object);
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            if (affineTransform != null) {
                graphics2D.transform(affineTransform);
                shape2 = graphics2D.getClip();
            }
            this.minX = -1.0;
            this.minY = -1.0;
            this.maxX = -1.0;
            this.maxY = -1.0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 2;
            int n6 = 0;
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            int n13 = -1;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            PdfPaint pdfPaint = null;
            PdfPaint pdfPaint2 = null;
            PdfPaint pdfPaint3 = null;
            PdfPaint pdfPaint4 = null;
            Stroke stroke = null;
            if (this.colorsLocked) {
                pdfPaint4 = this.strokeCol;
                pdfPaint3 = this.fillCol;
            }
            block38: for (int i = 0; i < n2; ++i) {
                Object object2;
                boolean bl4 = false;
                boolean bl5 = false;
                n3 = nArray[i];
                Rectangle rectangle2 = null;
                if (n3 <= 0) continue;
                f3 = this.x_coord[i];
                f4 = this.y_coord[i];
                Object object3 = null;
                object3 = objectArray4[i];
                if (rectangle2 == null) {
                    if (dArray != null && n3 == 3) {
                        object2 = (BufferedImage)objectArray4[i];
                        if (object2 != null) {
                            rectangle2 = new Rectangle((int)f3, (int)f4, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight());
                        }
                    } else if (dArray != null && n3 == 2) {
                        rectangle2 = ((Shape)objectArray4[i]).getBounds();
                    } else if (n3 == 1 && n13 > -1) {
                        int n21 = ((Area)object3).getBounds().x;
                        int n22 = ((Area)object3).getBounds().y;
                        rectangle2 = this.getAreaForGlyph(new float[][]{{(float)dArray[n13], (float)dArray2[n13], 0.0f}, {(float)dArray3[n13], (float)dArray4[n13], 0.0f}, {n21, n22, 1.0f}});
                    } else if (n11 != -1 && dArray != null) {
                        rectangle2 = new Rectangle((int)f3, (int)f4, nArray3[n11], nArray3[n11]);
                    }
                }
                if (bl4) {
                    switch (n3) {
                        case 2: {
                            ++n9;
                            break;
                        }
                        case 3: {
                            ++n7;
                            break;
                        }
                        case 7: {
                            ++n8;
                        }
                        case 4: {
                            ++n10;
                            break;
                        }
                        case 5: {
                            ++n10;
                            break;
                        }
                        case 6: {
                            ++n10;
                            break;
                        }
                        case 9: {
                            ++n13;
                            break;
                        }
                        case 21: {
                            ++n11;
                            break;
                        }
                        case 22: {
                            ++n12;
                            break;
                        }
                        case 10: {
                            ++n14;
                            break;
                        }
                        case 11: {
                            ++n16;
                            break;
                        }
                        case 12: {
                            ++n17;
                            break;
                        }
                        case 14: {
                            ++n15;
                            break;
                        }
                        case 15: {
                            ++n18;
                        }
                    }
                    continue;
                }
                if (!bl2) {
                    graphics2D.setRenderingHints(hints);
                    bl2 = true;
                }
                ++n;
                switch (n3) {
                    case 2: {
                        if (!bl) {
                            if (bl3) {
                                this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                                bl3 = false;
                            }
                            this.renderShape(nArray5[n9], pdfPaint4, pdfPaint3, stroke, (Shape)object3, graphics2D, f2, f);
                        }
                        ++n9;
                        continue block38;
                    }
                    case 1: {
                        if (bl3) {
                            this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                            bl3 = false;
                        }
                        if (rectangleArray != null) {
                            bl5 = this.setHighlightForGlyph(rectangle2, nArray, rectangleArray, i, bl5);
                        }
                        if (bl && !bl5) continue block38;
                        this.renderText(n5, (Area)object3, graphics2D, bl5, pdfPaint, pdfPaint2, f2, f, rectangle2);
                        continue block38;
                    }
                    case 4: {
                        if (bl3) {
                            this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                            bl3 = false;
                        }
                        if (rectangleArray != null) {
                            bl5 = this.setHighlightForGlyph(rectangle2, nArray, rectangleArray, i, bl5);
                        }
                        this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f3, (double)f4);
                        if (!bl || bl5) {
                            this.renderEmbeddedText(n5, object3, 4, graphics2D, this.aff, bl5, pdfPaint, pdfPaint2, f2, f, rectangle2, n6);
                        }
                        ++n10;
                        continue block38;
                    }
                    case 5: {
                        if (bl3) {
                            this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                            bl3 = false;
                        }
                        if (rectangleArray != null) {
                            bl5 = this.setHighlightForGlyph(rectangle2, nArray, rectangleArray, i, bl5);
                        }
                        this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f3, (double)f4);
                        if (!bl || bl5) {
                            this.renderEmbeddedText(n5, object3, 5, graphics2D, this.aff, bl5, pdfPaint, pdfPaint2, f2, f, rectangle2, n6);
                        }
                        ++n10;
                        continue block38;
                    }
                    case 6: {
                        if (bl3) {
                            this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                            bl3 = false;
                        }
                        if (rectangleArray != null) {
                            bl5 = this.setHighlightForGlyph(rectangle2, nArray, rectangleArray, i, bl5);
                        }
                        this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f3, (double)f4);
                        if (!bl || bl5) {
                            this.renderEmbeddedText(n5, object3, 6, graphics2D, this.aff, bl5, pdfPaint, pdfPaint2, f2, f, rectangle2, n6);
                        }
                        ++n10;
                        continue block38;
                    }
                    case 3: {
                        if (!bl) {
                            if (bl3) {
                                this.renderClip(area, (Rectangle)object, shape2, graphics2D);
                                bl3 = false;
                            }
                            if (!this.useHiResImageForDisplay) {
                                this.renderImage(null, (BufferedImage)object3, f, null, graphics2D, f3, f4);
                            }
                        }
                        ++n7;
                        continue block38;
                    }
                    case 7: {
                        area = areaArray[n8];
                        bl3 = true;
                        ++n8;
                        continue block38;
                    }
                    case 9: {
                        ++n13;
                        continue block38;
                    }
                    case 21: {
                        ++n11;
                        continue block38;
                    }
                    case 22: {
                        n6 = nArray4[n12];
                        ++n12;
                        continue block38;
                    }
                    case 10: {
                        n4 = nArray2[n14];
                        if (n4 == 1) {
                            pdfPaint = (PdfPaint)objectArray[n14];
                        } else {
                            pdfPaint2 = (PdfPaint)objectArray[n14];
                        }
                        ++n14;
                        continue block38;
                    }
                    case 11: {
                        if (!this.colorsLocked) {
                            pdfPaint3 = (PdfPaint)objectArray2[n16];
                        }
                        ++n16;
                        continue block38;
                    }
                    case 12: {
                        if (!this.colorsLocked) {
                            pdfPaint4 = (PdfPaint)objectArray3[n17];
                            pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling);
                        }
                        ++n17;
                        continue block38;
                    }
                    case 14: {
                        stroke = (Stroke)objectArray6[n15];
                        ++n15;
                        continue block38;
                    }
                    case 15: {
                        n5 = nArray6[n18];
                        ++n18;
                        continue block38;
                    }
                    case 17: {
                        f2 = fArray[n19];
                        ++n19;
                        continue block38;
                    }
                    case 18: {
                        f = fArray[n19];
                        ++n19;
                        continue block38;
                    }
                    case 16: {
                        if (bl) continue block38;
                        try {
                            object2 = graphics2D.getTransform();
                            String string = (String)object3;
                            double[] dArray5 = new double[6];
                            graphics2D.getTransform().getMatrix(dArray5);
                            if (dArray5[2] != 0.0) {
                                dArray5[2] = -dArray5[2];
                            }
                            if (dArray5[3] != 0.0) {
                                dArray5[3] = -dArray5[3];
                            }
                            graphics2D.setTransform(new AffineTransform(dArray5));
                            Font font = (Font)objectArray5[n20];
                            graphics2D.setFont(font);
                            if ((n5 & 2) == 2) {
                                if (pdfPaint2 != null) {
                                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                                }
                                graphics2D.setPaint(pdfPaint2);
                            }
                            if ((n5 & 1) == 1) {
                                if (pdfPaint != null) {
                                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                                }
                                graphics2D.setPaint(pdfPaint);
                            }
                            graphics2D.drawString(string, f3, f4);
                            graphics2D.setTransform((AffineTransform)object2);
                            ++n20;
                            continue block38;
                        }
                        catch (Exception exception) {
                            System.err.println(object3 + "<>" + i);
                            exception.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
            }
            graphics2D.setClip(shape2);
            graphics2D.setTransform(affineTransform2);
        }
        if (debugPaint) {
            System.err.println("Painted " + n);
        }
        this.pageDrawing = false;
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                object = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, object);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    private Rectangle getAreaForGlyph(float[][] fArray) {
        int n = (int)Math.sqrt(fArray[0][0] * fArray[0][0] + fArray[1][0] * fArray[1][0]);
        int n2 = (int)Math.sqrt(fArray[1][1] * fArray[1][1] + fArray[0][1] * fArray[0][1]);
        return new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n2);
    }

    public void setMessageFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void paintBackground(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.addBackground) {
            graphics2D.setColor(this.backgroundColor);
            if (rectangle == null) {
                graphics2D.fill(new Rectangle(this.xx, this.yy, this.w, this.h));
            } else {
                graphics2D.fill(rectangle);
            }
        }
    }

    public void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    private boolean setHighlightForGlyph(Rectangle rectangle, int[] nArray, Rectangle[] rectangleArray, int n, boolean bl) {
        int n2 = rectangleArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n];
            if (rectangle == null || !(n3 == 1 | n3 == 4 | n3 == 5 | n3 == 6) || rectangleArray[i] == null || !rectangleArray[i].intersects(rectangle) || !(rectangleArray[i].getMinX() <= rectangle.getMinX()) || !(rectangleArray[i].getMinY() <= rectangle.getMinY())) continue;
            i = n2;
            bl = true;
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.minX == -1.0) {
                this.minX = rectangle2D.getMinX();
                this.minY = rectangle2D.getMinY();
                this.maxX = rectangle2D.getMaxX();
                this.maxY = rectangle2D.getMaxY();
                continue;
            }
            double d = rectangle2D.getMinX();
            if (d < this.minX) {
                this.minX = d;
            }
            if ((d = rectangle2D.getMinY()) < this.minY) {
                this.minY = d;
            }
            if ((d = rectangle2D.getMaxX()) > this.maxX) {
                this.maxX = d;
            }
            if (!((d = rectangle2D.getMaxY()) > this.maxY)) continue;
            this.maxY = d;
        }
        return bl;
    }

    public final void drawText(float[][] fArray, Object object, GraphicsState graphicsState) {
        int n;
        int n2;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        if (object instanceof Area) {
            this.drawFontSize((int)((Area)object).getBounds().getWidth());
            this.pageObjects.addElement(object);
            this.areas.addElement(((Area)object).getBounds());
            this.objectType.addElement(1);
        } else {
            this.pageObjects.addElement(object);
            this.objectType.addElement(-1);
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = fArray[2][0];
        this.y_coord[this.currentItem] = fArray[2][1];
        ++this.currentItem;
        this.resetTextColors = false;
    }

    public final void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        int n2;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    private float[] checkSize(float[] fArray, int n) {
        int n2 = fArray.length;
        if (n2 <= n) {
            int n3 = n2 * 2;
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        return fArray;
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        if (this.areas != null) {
            Rectangle rectangle3 = rectangle.getBounds();
            int n = rectangle3.x;
            int n2 = rectangle3.y;
            int n3 = n + rectangle3.width;
            int n4 = n2 + rectangle3.height;
            boolean bl2 = false;
            Rectangle[] rectangleArray = this.areas.get();
            int n5 = rectangleArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (rectangleArray[i] == null || !rectangle.contains(rectangleArray[i])) continue;
                bl2 = true;
                int n7 = rectangleArray[i].x;
                if (n3 > n7) {
                    n3 = n7;
                }
                if (n < (n7 = rectangleArray[i].x + rectangleArray[i].width)) {
                    n = n7;
                }
                if (n4 > (n6 = rectangleArray[i].y)) {
                    n4 = n6;
                }
                if (n2 >= (n6 = rectangleArray[i].y + rectangleArray[i].height)) continue;
                n2 = n6;
            }
            if (bl2) {
                rectangle2 = new Rectangle(n3 - 1, n4 + 1, n - n3 + 2, n2 - n4 + 2);
            }
        }
        return rectangle2;
    }

    public final void init(int n, int n2, int n3) {
        this.w = n;
        this.h = n2;
        this.rotation = n3;
    }

    public final BufferedImage getPageAsImage(float f, int n, int n2, int n3, int n4, int n5, AffineTransform affineTransform, int n6) {
        if (n3 < 0) {
            n3 = this.w;
            n4 = this.h;
        } else {
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n6 == 1) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n3, n4);
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.paint(graphics2D, null, n, n2);
        graphics2D.setTransform(affineTransform2);
        return bufferedImage;
    }

    public final void drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl) {
        this.pageNumber = n;
        float[][] fArray = graphicsState.CTM;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        if (!bl && bufferedImage.getHeight() > 1) {
            bufferedImage = this.invertImage(fArray, bufferedImage);
        }
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(3);
        this.w = (int)fArray[0][0];
        if (this.w == 0) {
            this.w = (int)fArray[0][1];
        }
        this.h = (int)fArray[1][1];
        if (this.h == 0) {
            this.h = (int)fArray[1][0];
        }
        this.areas.addElement(new Rectangle((int)graphicsState.x, (int)graphicsState.y, this.w, this.h));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    private BufferedImage invertImage(float[][] fArray, BufferedImage bufferedImage) {
        boolean bl;
        boolean bl2 = bl = fArray[0][0] > 0.0f && fArray[1][1] > 0.0f || fArray[0][0] < 0.0f && fArray[1][1] < 0.0f || fArray[0][0] * fArray[1][1] < 0.0f || fArray[0][1] * fArray[1][0] != 0.0f;
        if (bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            boolean bl3 = false;
            if (JAIHelper.isJAIused()) {
                bl3 = true;
                try {
                    bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception exception) {
                    bl3 = false;
                    exception.printStackTrace();
                }
                catch (Error error) {
                    bl3 = false;
                    error.printStackTrace();
                }
                if (!bl3) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            }
            if (!bl3) {
                if (bufferedImage.getType() == 12) {
                    BufferedImage bufferedImage2 = bufferedImage;
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                    affineTransformOp.filter(bufferedImage2, bufferedImage);
                } else {
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
            }
        }
        return bufferedImage;
    }

    public final void drawImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight();
        if (n > 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(0.0, n);
            affineTransform.scale(1.0, -1.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
        }
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    public final void drawShape(Shape shape, GraphicsState graphicsState) {
        int n;
        PdfPaint pdfPaint;
        int n2 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0) {
            shape = new Rectangle(0, 0, 1, 1);
        }
        if (n2 == 2 | n2 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.fillSet = true;
            } else {
                n = pdfPaint.getRGB();
                if (!this.fillSet || this.lastFillCol != n) {
                    this.lastFillCol = n;
                    this.drawFillColor(pdfPaint);
                    this.fillSet = true;
                }
            }
        }
        if (n2 == 1 | n2 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n = pdfPaint.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawStrokeColor(pdfPaint);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(pdfPaint);
                this.strokeSet = true;
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n2);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    public final void drawColor(PdfPaint pdfPaint, int n) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.text_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    public final void setGraphicsState(int n, float f) {
        if (f != 1.0f) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(this.defaultSize);
            }
            this.pageObjects.addElement(null);
            if (n == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(f);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        } else {
            this.endItem = this.currentItem;
        }
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        block5: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 19: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(1);
                    graphicsState.setStrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block5;
                }
                case 20: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block5;
                }
                case 16: {
                    TextObject textObject = (TextObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    float f = textObject.font.getSize();
                    double[] dArray = new double[]{f, 0.0, 0.0, f, 0.0, 0.0};
                    this.drawAffine(dArray);
                    this.drawTR(2);
                    graphicsState.setTextRenderType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawText(null, textObject.text, graphicsState, textObject.x, -textObject.y, textObject.font);
                    continue block5;
                }
                default: {
                    throw new PdfException("Unrecognised type " + n2);
                }
            }
        }
    }

    public final void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.stroke_color.addElement(paint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    public final void drawTR(int n) {
        if (n != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(this.defaultSize);
            }
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.TRvalues.addElement(n);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.stroke.addElement(stroke);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawClip(GraphicsState graphicsState) {
        Area area = graphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || area != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, int n2, GraphicsState graphicsState, AffineTransform affineTransform, float f) {
        int n3;
        PdfPaint pdfPaint;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
            } else {
                n3 = pdfPaint.getRGB();
                if (this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n4 & 1) == 1 && this.lastStrokeCol != (n3 = (pdfPaint = graphicsState.getStrokeColor()).getRGB())) {
            this.lastStrokeCol = n3;
            this.drawColor(pdfPaint, 1);
        }
        this.drawFontSize(n);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        this.pageObjects.addElement(pdfGlyph);
        this.objectType.addElement(n2);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)affineTransform.getTranslateX();
        this.y_coord[this.currentItem] = (float)affineTransform.getTranslateY();
        this.areas.addElement(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
        ++this.currentItem;
    }

    public void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    public void drawFontSize(int n) {
        if (n != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            if (this.fs == null) {
                this.fs = new Vector_Int(this.defaultSize);
            }
            this.fs.addElement(n);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = n;
        }
    }

    public void setLineWidth(int n) {
        if (n == this.lastLW) {
            // empty if block
        }
        this.pageObjects.addElement(null);
        this.objectType.addElement(22);
        if (this.lw == null) {
            this.lw = new Vector_Int(this.defaultSize);
        }
        this.lw.addElement(n);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastLW = n;
    }

    public void renderAffine(AffineTransform affineTransform) {
        this.aff = affineTransform;
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.colorsLocked = true;
        Color color = Color.white;
        Color color2 = Color.white;
        if (!pdfPaint.isPattern()) {
            color = (Color)((Object)pdfPaint);
        }
        this.strokeCol = new PdfColor(color.getRed(), color.getGreen(), color.getBlue());
        if (!pdfPaint2.isPattern()) {
            color2 = (Color)((Object)pdfPaint2);
        }
        this.fillCol = new PdfColor(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean bl) {
    }

    public void setOptimiseDrawing(boolean bl) {
        this.optimiseDrawing = bl;
    }

    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    public boolean isImageCached(int n) {
        if (this.rawKey == null) {
            return this.objectStoreRef.isImageCached(n + "_HIRES_" + (this.currentItem + 1));
        }
        return this.objectStoreRef.isImageCached(n + "_HIRES_" + (this.currentItem + 1) + "_" + this.rawKey);
    }

    public DynamicVectorRenderer(byte[] byArray, Map map) {
        try {
            Object object;
            int n;
            this.fonts = map;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = byteArrayInputStream.read();
            if (n2 != 1) {
                throw new PdfException("Unknown version in serialised object " + n2);
            }
            int n3 = byteArrayInputStream.read();
            this.useHiResImageForDisplay = n3 == 1;
            this.pageNumber = byteArrayInputStream.read();
            this.x_coord = (float[])this.restoreFromStream(byteArrayInputStream);
            this.y_coord = (float[])this.restoreFromStream(byteArrayInputStream);
            this.text_color = (Vector_Object)this.restoreFromStream(byteArrayInputStream);
            this.textFillType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(byteArrayInputStream);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(byteArrayInputStream);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(byteArrayInputStream);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(byteArrayInputStream);
            this.javaObjects = (Vector_Object)this.restoreFromStream(byteArrayInputStream);
            this.shapeType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.af1 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af2 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af3 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af4 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.clips = new Vector_Shape();
            this.clips.restoreFromStream(byteArrayInputStream);
            this.objectType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.opacity = (Vector_Float)this.restoreFromStream(byteArrayInputStream);
            this.TRvalues = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.fs = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.lw = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            int n4 = (Integer)this.restoreFromStream(byteArrayInputStream);
            for (n = 0; n < n4; ++n) {
                Object object2 = this.restoreFromStream(byteArrayInputStream);
                object = this.restoreFromStream(byteArrayInputStream);
                map.put(object2, object);
            }
            n = (Integer)this.restoreFromStream(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                object = this.restoreFromStream(byteArrayInputStream);
                PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)map.get(object);
                pdfJavaGlyphs.setDisplayValues((Map)this.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setCharGlyphs((Map)this.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setEmbeddedEncs((Map)this.restoreFromStream(byteArrayInputStream));
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] serializeToByteArray(Set set) throws IOException {
        Object k;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        if (this.useHiResImageForDisplay) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        this.writeToStream(byteArrayOutputStream, this.x_coord, "x_coord");
        this.writeToStream(byteArrayOutputStream, this.y_coord, "y_coord");
        this.writeToStream(byteArrayOutputStream, this.text_color, "text_color");
        this.writeToStream(byteArrayOutputStream, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(byteArrayOutputStream);
        this.fill_color.writeToStream(byteArrayOutputStream);
        int n2 = byteArrayOutputStream.size();
        this.stroke.writeToStream(byteArrayOutputStream);
        n2 = n = byteArrayOutputStream.size();
        this.pageObjects.writeToStream(byteArrayOutputStream);
        n = byteArrayOutputStream.size();
        this.writeToStream(byteArrayOutputStream, this.javaObjects, "javaObjects");
        this.writeToStream(byteArrayOutputStream, this.shapeType, "shapeType");
        this.writeToStream(byteArrayOutputStream, this.af1, "af1");
        this.writeToStream(byteArrayOutputStream, this.af2, "af2");
        this.writeToStream(byteArrayOutputStream, this.af3, "af3");
        this.writeToStream(byteArrayOutputStream, this.af4, "af4");
        n2 = byteArrayOutputStream.size();
        this.clips.writeToStream(byteArrayOutputStream);
        n = byteArrayOutputStream.size();
        this.writeToStream(byteArrayOutputStream, this.objectType, "objectType");
        this.writeToStream(byteArrayOutputStream, this.opacity, "opacity");
        this.writeToStream(byteArrayOutputStream, this.TRvalues, "TRvalues");
        this.writeToStream(byteArrayOutputStream, this.fs, "fs");
        this.writeToStream(byteArrayOutputStream, this.lw, "lw");
        int n3 = 0;
        int n4 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = this.fontsUsed.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (!set.contains(k)) {
                ++n3;
                hashMap2.put(k, "x");
                continue;
            }
            ++n4;
            hashMap.put(k, "x");
        }
        this.writeToStream(byteArrayOutputStream, new Integer(n3), "new Integer(fontCount)");
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            this.writeToStream(byteArrayOutputStream, k, "key");
            this.writeToStream(byteArrayOutputStream, this.fonts.get(k), "font");
            set.add(k);
        }
        this.writeToStream(byteArrayOutputStream, new Integer(n4), "new Integer(existingfontCount)");
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            this.writeToStream(byteArrayOutputStream, k, "key");
            PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)this.fonts.get(k);
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getDisplayValues(), "display");
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getCharGlyphs(), "char");
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getEmbeddedEncs(), "emb");
        }
        byteArrayOutputStream.close();
        this.fontsUsed.clear();
        return byteArrayOutputStream.toByteArray();
    }

    public Object restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream, Object object, String string) throws IOException {
        int n = byteArrayOutputStream.size();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        int n2 = byteArrayOutputStream.size();
        objectOutputStream.close();
    }

    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
        System.out.println("xxxxxx");
        this.pageObjects.addElement(object);
        this.objectType.addElement(200);
        ++this.currentItem;
        if (this.fontsUsed.get(string) == null || pdfFont.isFontSubsetted()) {
            this.fonts.put(string, pdfFont.getGlyphData());
            this.fontsUsed.put(string, "x");
        }
    }

    public boolean hasObjectsBehind(float[][] fArray) {
        double d;
        boolean bl = false;
        double d2 = fArray[2][0];
        double d3 = fArray[2][1];
        double d4 = fArray[0][0];
        if (d4 == 0.0) {
            d4 = fArray[0][1];
        }
        if ((d = (double)fArray[1][1]) == 0.0) {
            d = fArray[1][0];
        }
        Rectangle[] rectangleArray = this.areas.get();
        int n = rectangleArray.length;
        for (int i = 0; i < n; ++i) {
            if (rectangleArray[i] == null || !rectangleArray[i].intersects(new Rectangle((int)d2, (int)d3, (int)d4, (int)d))) continue;
            i = n;
            bl = true;
        }
        return bl;
    }

    public void setObjectStoreRef(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public void setType3Glyph(String string) {
        this.rawKey = string;
        this.isType3Font = true;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        userAlerted = false;
    }
}

