/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;

public final class FFTFunctions {
    public static final <T extends RealType<T>, S extends ComplexType<S>> Image<T> computeInverseFFT(final Image<S> complex, T type, final int numThreads, final boolean scale, final boolean cropBack, final int[] originalSize, final int[] originalOffset, final float additionalNormalization) {
        if (complex == null) {
            return null;
        }
        final int numDimensions = complex.getNumDimensions();
        int nfft = (complex.getDimension(0) - 1) * 2;
        final int[] dimensionsReal = complex.getDimensions();
        dimensionsReal[0] = nfft;
        ImageFactory<T> imgFactory = new ImageFactory<T>(type, complex.getContainerFactory());
        final Image<T> realImage = cropBack ? imgFactory.createImage(originalSize) : imgFactory.createImage(dimensionsReal);
        if (realImage == null) {
            return null;
        }
        for (int d = numDimensions - 1; d > 0; --d) {
            final int dim = d;
            final AtomicInteger ai = new AtomicInteger();
            Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        int size = complex.getDimension(dim);
                        float[] tempIn = new float[size * 2];
                        FftComplex fftc = new FftComplex(size);
                        LocalizableByDimCursor cursor = complex.createLocalizableByDimCursor();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = complex.getDimension(d);
                        }
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        float[] tempOut = new float[size * 2];
                        while (cursorDim.hasNext()) {
                            int i;
                            cursorDim.fwd();
                            if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                            cursorDim.getPosition(fakeSize);
                            tmp[dim] = 0;
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                tmp[d] = fakeSize[countDim++];
                            }
                            cursor.setPosition(tmp);
                            for (i = 0; i < size - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                                cursor.fwd(dim);
                            }
                            tempIn[(size - 1) * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                            tempIn[(size - 1) * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                            fftc.complexToComplex(1, tempIn, tempOut);
                            cursor.setPosition(tmp);
                            if (scale) {
                                for (i = 0; i < size - 1; ++i) {
                                    ((ComplexType)cursor.getType()).setComplexNumber(tempOut[i * 2] / (float)size, tempOut[i * 2 + 1] / (float)size);
                                    cursor.fwd(dim);
                                }
                                ((ComplexType)cursor.getType()).setComplexNumber(tempOut[(size - 1) * 2] / (float)size, tempOut[(size - 1) * 2 + 1] / (float)size);
                                continue;
                            }
                            for (i = 0; i < size - 1; ++i) {
                                ((ComplexType)cursor.getType()).setComplexNumber(tempOut[i * 2], tempOut[i * 2 + 1]);
                                cursor.fwd(dim);
                            }
                            ((ComplexType)cursor.getType()).setComplexNumber(tempOut[(size - 1) * 2], tempOut[(size - 1) * 2 + 1]);
                        }
                        cursor.close();
                        cursorDim.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        final AtomicInteger ai = new AtomicInteger();
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int cropX2;
                    int cropX1;
                    int myNumber = ai.getAndIncrement();
                    int realSize = dimensionsReal[0];
                    int complexSize = complex.getDimension(0);
                    float[] tempIn = new float[complexSize * 2];
                    FftReal fft = new FftReal(realSize);
                    if (cropBack) {
                        cropX1 = originalOffset[0];
                        cropX2 = originalOffset[0] + originalSize[0];
                    } else {
                        cropX1 = 0;
                        cropX2 = realSize;
                    }
                    LocalizableByDimCursor cursor = complex.createLocalizableByDimCursor();
                    LocalizableByDimCursor cursorOut = realImage.createLocalizableByDimCursor();
                    if (numDimensions > 1) {
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        for (int d = 1; d < numDimensions; ++d) {
                            fakeSize[d - 1] = complex.getDimension(d);
                        }
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        float[] tempOut = new float[realSize];
                        block1: while (cursorDim.hasNext()) {
                            int x;
                            int d;
                            cursorDim.fwd();
                            if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                            cursorDim.getPosition(fakeSize);
                            tmp[0] = 0;
                            if (cropBack) {
                                for (d = 1; d < numDimensions; ++d) {
                                    tmp[d] = fakeSize[d - 1];
                                    if (tmp[d] < originalOffset[d] || tmp[d] >= originalOffset[d] + originalSize[d]) continue block1;
                                }
                            } else {
                                for (d = 1; d < numDimensions; ++d) {
                                    tmp[d] = fakeSize[d - 1];
                                }
                            }
                            cursor.setPosition(tmp);
                            for (int i = 0; i < complexSize - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                                cursor.fwd(0);
                            }
                            tempIn[(complexSize - 1) * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                            tempIn[(complexSize - 1) * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                            fft.complexToReal(1, tempIn, tempOut);
                            if (cropBack) {
                                for (d = 1; d < numDimensions; ++d) {
                                    int n = d;
                                    tmp[n] = tmp[n] - originalOffset[d];
                                }
                            }
                            cursorOut.setPosition(tmp);
                            if (scale) {
                                for (x = cropX1; x < cropX2 - 1; ++x) {
                                    ((RealType)cursorOut.getType()).setReal(tempOut[x] / (float)realSize * additionalNormalization);
                                    cursorOut.fwd(0);
                                }
                                ((RealType)cursorOut.getType()).setReal(tempOut[cropX2 - 1] / (float)realSize * additionalNormalization);
                                continue;
                            }
                            for (x = cropX1; x < cropX2 - 1; ++x) {
                                ((RealType)cursorOut.getType()).setReal(tempOut[x] * additionalNormalization);
                                cursorOut.fwd(0);
                            }
                            ((RealType)cursorOut.getType()).setReal(tempOut[cropX2 - 1] * additionalNormalization);
                        }
                        cursorOut.close();
                        cursor.close();
                        cursorDim.close();
                    } else {
                        if (myNumber == 0) {
                            cursor.setPosition(0, 0);
                            for (int i = 0; i < complexSize - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                                cursor.fwd(0);
                            }
                            tempIn[(complexSize - 1) * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                            tempIn[(complexSize - 1) * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                            float[] tempOut = new float[realSize];
                            fft.complexToReal(1, tempIn, tempOut);
                            cursorOut.setPosition(0, 0);
                            if (scale) {
                                for (int x = cropX1; x < cropX2 - 1; ++x) {
                                    ((RealType)cursorOut.getType()).setReal(tempOut[x] / (float)realSize * additionalNormalization);
                                    cursorOut.fwd(0);
                                }
                                ((RealType)cursorOut.getType()).setReal(tempOut[cropX2 - 1] / (float)realSize * additionalNormalization);
                            } else {
                                for (int x = cropX1; x < cropX2 - 1; ++x) {
                                    ((RealType)cursorOut.getType()).setReal(tempOut[x] * additionalNormalization);
                                    cursorOut.fwd(0);
                                }
                                ((RealType)cursorOut.getType()).setReal(tempOut[cropX2 - 1] * additionalNormalization);
                            }
                        }
                        cursorOut.close();
                        cursor.close();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        return realImage;
    }

    public static final <T extends RealType<T>, S extends ComplexType<S>> Image<S> computeFFT(final Image<T> img, S complexType, final OutOfBoundsStrategyFactory<T> outOfBoundsFactory, final int[] imageOffset, final int[] imageSize, final int numThreads, final boolean scale) {
        final int numDimensions = img.getNumDimensions();
        int[] complexSize = new int[numDimensions];
        complexSize[0] = imageSize[0] / 2 + 1;
        for (int d = 1; d < numDimensions; ++d) {
            complexSize[d] = imageSize[d];
        }
        ImageFactory<S> imgFactory = new ImageFactory<S>(complexType, img.getContainerFactory());
        final Image<S> fftImage = imgFactory.createImage(complexSize);
        if (fftImage == null) {
            return null;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int realSize = imageSize[0];
                    int complexSize = fftImage.getDimension(0);
                    float[] tempIn = new float[realSize];
                    FftReal fft = new FftReal(realSize);
                    LocalizableByDimCursor cursor = img.createLocalizableByDimCursor(outOfBoundsFactory);
                    LocalizableByDimCursor cursorOut = fftImage.createLocalizableByDimCursor();
                    if (numDimensions > 1) {
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int[] tmp2 = new int[numDimensions];
                        for (int d = 1; d < numDimensions; ++d) {
                            fakeSize[d - 1] = imageSize[d];
                        }
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        float[] tempOut = new float[complexSize * 2];
                        while (cursorDim.hasNext()) {
                            int x;
                            cursorDim.fwd();
                            if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                            cursorDim.getPosition(fakeSize);
                            tmp[0] = 0;
                            tmp2[0] = -imageOffset[0];
                            for (int d = 1; d < numDimensions; ++d) {
                                tmp[d] = fakeSize[d - 1];
                                tmp2[d] = fakeSize[d - 1] - imageOffset[d];
                            }
                            cursor.setPosition(tmp2);
                            for (x = 0; x < realSize - 1; ++x) {
                                tempIn[x] = ((RealType)cursor.getType()).getRealFloat();
                                cursor.fwd(0);
                            }
                            tempIn[realSize - 1] = ((RealType)cursor.getType()).getRealFloat();
                            fft.realToComplex(-1, tempIn, tempOut);
                            cursorOut.setPosition(tmp);
                            if (scale) {
                                for (x = 0; x < complexSize - 1; ++x) {
                                    ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[x * 2] / (float)realSize, tempOut[x * 2 + 1] / (float)realSize);
                                    cursorOut.fwd(0);
                                }
                                ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[(complexSize - 1) * 2] / (float)realSize, tempOut[(complexSize - 1) * 2 + 1] / (float)realSize);
                                continue;
                            }
                            for (x = 0; x < complexSize - 1; ++x) {
                                ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[x * 2], tempOut[x * 2 + 1]);
                                cursorOut.fwd(0);
                            }
                            ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[(complexSize - 1) * 2], tempOut[(complexSize - 1) * 2 + 1]);
                        }
                        cursorOut.close();
                        cursor.close();
                        cursorDim.close();
                    } else {
                        if (myNumber == 0) {
                            cursor.setPosition(-imageOffset[0], 0);
                            for (int x = 0; x < realSize - 1; ++x) {
                                tempIn[x] = ((RealType)cursor.getType()).getRealFloat();
                                cursor.fwd(0);
                            }
                            tempIn[realSize - 1] = ((RealType)cursor.getType()).getRealFloat();
                            float[] tempOut = new float[complexSize * 2];
                            fft.realToComplex(-1, tempIn, tempOut);
                            cursorOut.setPosition(0, 0);
                            if (scale) {
                                for (int x = 0; x < complexSize - 1; ++x) {
                                    ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[x * 2] / (float)realSize, tempOut[x * 2 + 1] / (float)realSize);
                                    cursorOut.fwd(0);
                                }
                                ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[(complexSize - 1) * 2] / (float)realSize, tempOut[(complexSize - 1) * 2 + 1] / (float)realSize);
                            } else {
                                for (int x = 0; x < complexSize - 1; ++x) {
                                    ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[x * 2], tempOut[x * 2 + 1]);
                                    cursorOut.fwd(0);
                                }
                                ((ComplexType)cursorOut.getType()).setComplexNumber(tempOut[(complexSize - 1) * 2], tempOut[(complexSize - 1) * 2 + 1]);
                            }
                        }
                        cursorOut.close();
                        cursor.close();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        for (int d = 1; d < numDimensions; ++d) {
            final int dim = d;
            ai.set(0);
            threads = SimpleMultiThreading.newThreads(numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        int size = fftImage.getDimension(dim);
                        float[] tempIn = new float[size * 2];
                        FftComplex fftc = new FftComplex(size);
                        LocalizableByDimCursor cursor = fftImage.createLocalizableByDimCursor();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = fftImage.getDimension(d);
                        }
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        float[] tempOut = new float[size * 2];
                        while (cursorDim.hasNext()) {
                            int i;
                            cursorDim.fwd();
                            if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                            cursorDim.getPosition(fakeSize);
                            tmp[dim] = 0;
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                tmp[d] = fakeSize[countDim++];
                            }
                            cursor.setPosition(tmp);
                            for (i = 0; i < size - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                                cursor.fwd(dim);
                            }
                            tempIn[(size - 1) * 2] = ((ComplexType)cursor.getType()).getRealFloat();
                            tempIn[(size - 1) * 2 + 1] = ((ComplexType)cursor.getType()).getComplexFloat();
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            cursor.setPosition(tmp);
                            if (scale) {
                                for (i = 0; i < size - 1; ++i) {
                                    ((ComplexType)cursor.getType()).setComplexNumber(tempOut[i * 2] / (float)size, tempOut[i * 2 + 1] / (float)size);
                                    cursor.fwd(dim);
                                }
                                ((ComplexType)cursor.getType()).setComplexNumber(tempOut[(size - 1) * 2] / (float)size, tempOut[(size - 1) * 2 + 1] / (float)size);
                                continue;
                            }
                            for (i = 0; i < size - 1; ++i) {
                                ((ComplexType)cursor.getType()).setComplexNumber(tempOut[i * 2], tempOut[i * 2 + 1]);
                                cursor.fwd(dim);
                            }
                            ((ComplexType)cursor.getType()).setComplexNumber(tempOut[(size - 1) * 2], tempOut[(size - 1) * 2 + 1]);
                        }
                        cursor.close();
                        cursorDim.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        return fftImage;
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZeroSingleDim(Image<T> fftImage) {
        int sizeDim = fftImage.getDimension(0);
        int halfSizeDim = sizeDim / 2;
        int sizeDimMinus1 = sizeDim - 1;
        Object buffer = fftImage.createType();
        LocalizableByDimCursor<T> cursor1 = fftImage.createLocalizableByDimCursor();
        LocalizableByDimCursor<T> cursor2 = fftImage.createLocalizableByDimCursor();
        cursor1.setPosition(0, 0);
        cursor2.setPosition(0, sizeDimMinus1);
        for (int i = 0; i < halfSizeDim - 1; ++i) {
            buffer.set(cursor1.getType());
            cursor1.getType().set(cursor2.getType());
            cursor2.getType().set(buffer);
            cursor1.fwd(0);
            cursor2.bck(0);
        }
        buffer.set(cursor1.getType());
        cursor1.getType().set(cursor2.getType());
        cursor2.getType().set(buffer);
        cursor1.close();
        cursor2.close();
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZero(final Image<T> fftImage, final int numThreads) {
        final int numDimensions = fftImage.getNumDimensions();
        if (numDimensions == 1) {
            FFTFunctions.rearrangeQuadrantFFTDimZeroSingleDim(fftImage);
            return;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = fftImage.getDimension(0);
                    int halfSizeDim = sizeDim / 2;
                    int sizeDimMinus1 = sizeDim - 1;
                    Object buffer = fftImage.createType();
                    LocalizableByDimCursor cursor1 = fftImage.createLocalizableByDimCursor();
                    LocalizableByDimCursor cursor2 = fftImage.createLocalizableByDimCursor();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    for (int d = 1; d < numDimensions; ++d) {
                        fakeSize[d - 1] = fftImage.getDimension(d);
                    }
                    ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                        cursorDim.getPosition(fakeSize);
                        tmp[0] = 0;
                        for (int d = 1; d < numDimensions; ++d) {
                            tmp[d] = fakeSize[d - 1];
                        }
                        cursor1.setPosition(tmp);
                        tmp[0] = sizeDimMinus1;
                        cursor2.setPosition(tmp);
                        for (int i = 0; i < halfSizeDim - 1; ++i) {
                            buffer.set(cursor1.getType());
                            cursor1.getType().set(cursor2.getType());
                            cursor2.getType().set(buffer);
                            cursor1.fwd(0);
                            cursor2.bck(0);
                        }
                        buffer.set(cursor1.getType());
                        cursor1.getType().set(cursor2.getType());
                        cursor2.getType().set(buffer);
                    }
                    cursor1.close();
                    cursor2.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantDim(final Image<T> fftImage, final int dim, boolean forward, final int numThreads) {
        final int numDimensions = fftImage.getNumDimensions();
        if (fftImage.getDimension(dim) % 2 == 1) {
            FFTFunctions.rearrangeQuadrantDimOdd(fftImage, dim, forward, numThreads);
            return;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = fftImage.getDimension(dim);
                    int halfSizeDim = sizeDim / 2;
                    Object buffer = fftImage.createType();
                    LocalizableByDimCursor cursor1 = fftImage.createLocalizableByDimCursor();
                    LocalizableByDimCursor cursor2 = fftImage.createLocalizableByDimCursor();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    int countDim = 0;
                    for (int d = 0; d < numDimensions; ++d) {
                        if (d == dim) continue;
                        fakeSize[countDim++] = fftImage.getDimension(d);
                    }
                    ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                        cursorDim.getPosition(fakeSize);
                        tmp[dim] = 0;
                        countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            tmp[d] = fakeSize[countDim++];
                        }
                        cursor1.setPosition(tmp);
                        tmp[dim] = halfSizeDim;
                        cursor2.setPosition(tmp);
                        for (int i = 0; i < halfSizeDim - 1; ++i) {
                            buffer.set(cursor1.getType());
                            cursor1.getType().set(cursor2.getType());
                            cursor2.getType().set(buffer);
                            cursor1.fwd(dim);
                            cursor2.fwd(dim);
                        }
                        buffer.set(cursor1.getType());
                        cursor1.getType().set(cursor2.getType());
                        cursor2.getType().set(buffer);
                    }
                    cursor1.close();
                    cursor2.close();
                    cursorDim.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantDimOdd(final Image<T> fftImage, final int dim, final boolean forward, final int numThreads) {
        final int numDimensions = fftImage.getNumDimensions();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = fftImage.getDimension(dim);
                    int sizeDimMinus1 = sizeDim - 1;
                    int halfSizeDim = sizeDim / 2;
                    Object buffer1 = fftImage.createType();
                    Object buffer2 = fftImage.createType();
                    LocalizableByDimCursor cursor1 = fftImage.createLocalizableByDimCursor();
                    LocalizableByDimCursor cursor2 = fftImage.createLocalizableByDimCursor();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    int countDim = 0;
                    for (int d = 0; d < numDimensions; ++d) {
                        if (d == dim) continue;
                        fakeSize[countDim++] = fftImage.getDimension(d);
                    }
                    ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getPosition(0) % numThreads != myNumber) continue;
                        cursorDim.getPosition(fakeSize);
                        tmp[dim] = 0;
                        countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            tmp[d] = fakeSize[countDim++];
                        }
                        tmp[dim] = halfSizeDim;
                        cursor1.setPosition(tmp);
                        tmp[dim] = forward ? sizeDimMinus1 : 0;
                        cursor2.setPosition(tmp);
                        buffer1.set(cursor1.getType());
                        for (int i = 0; i < halfSizeDim; ++i) {
                            buffer2.set(cursor2.getType());
                            cursor2.getType().set(buffer1);
                            if (forward) {
                                cursor1.bck(dim);
                            } else {
                                cursor1.fwd(dim);
                            }
                            buffer1.set(cursor1.getType());
                            cursor1.getType().set(buffer2);
                            if (forward) {
                                cursor2.bck(dim);
                                continue;
                            }
                            cursor2.fwd(dim);
                        }
                        cursor2.setPosition(halfSizeDim, dim);
                        cursor2.getType().set(buffer1);
                    }
                    cursor1.close();
                    cursor2.close();
                    cursorDim.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static final <T extends Type<T>> void rearrangeFFTQuadrants(Image<T> fftImage, boolean forward, int numThreads) {
        FFTFunctions.rearrangeQuadrantFFTDimZero(fftImage, numThreads);
        for (int d = 1; d < fftImage.getNumDimensions(); ++d) {
            FFTFunctions.rearrangeQuadrantDim(fftImage, d, forward, numThreads);
        }
    }
}

