/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import java.util.Iterator;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Iterable;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.IntegerType;
import mpicbg.imglib.util.Util;

public abstract class AbstractSortedGrayLevelIterator<T extends IntegerType<T>>
implements Iterable,
LocalizableCursor<T>,
Localizable {
    protected final Image<T> image;
    protected final int[] sortedLinIdx;
    protected int n;
    protected int maxIdx;
    protected int curIdx;
    protected final int[] position;
    protected final int[] dimensions;

    public AbstractSortedGrayLevelIterator(Image<T> image) {
        this.image = image;
        this.position = image.createPositionArray();
        this.n = image.getNumPixels();
        this.maxIdx = this.n - 1;
        this.dimensions = image.getDimensions();
        this.createInternalCursor();
        this.sortedLinIdx = this.getLinearIndexArraySortedByGrayLevel();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.curIdx < this.maxIdx;
    }

    @Override
    public abstract void fwd();

    @Override
    public void reset() {
        this.curIdx = -1;
    }

    @Override
    public int[] getPosition() {
        int[] position = this.image.createPositionArray();
        this.getPosition(position);
        return position;
    }

    @Override
    public String getPositionAsString() {
        return Util.printCoordinates(this.getPosition());
    }

    @Override
    public int[] createPositionArray() {
        return this.image.createPositionArray();
    }

    @Override
    public int getArrayIndex() {
        return this.sortedLinIdx[this.curIdx];
    }

    @Override
    public Image<T> getImage() {
        return this.image;
    }

    @Override
    public Container<T> getStorageContainer() {
        return this.image.getContainer();
    }

    @Override
    public abstract int getStorageIndex();

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setDebug(boolean debug) {
    }

    @Override
    public T next() {
        this.fwd();
        return (T)((IntegerType)this.getType());
    }

    @Override
    public void remove() {
        throw new RuntimeException("remove is not supported.");
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public void getDimensions(int[] position) {
        this.image.getDimensions(position);
    }

    @Override
    public int getNumDimensions() {
        return this.image.getNumDimensions();
    }

    protected <C extends Comparable<C> & Type<C>> C max(Image<C> image) {
        Comparable max = (Comparable)image.createType();
        Cursor<C> cursor = image.createCursor();
        ((Type)((Object)max)).set((Type)cursor.next());
        for (Comparable type : cursor) {
            if (type.compareTo(max) <= 0) continue;
            ((Type)((Object)max)).set((Type)((Object)type));
        }
        return (C)max;
    }

    protected abstract void createInternalCursor();

    protected abstract int getIntegerValueAtLinearIndex(int var1);

    protected int[] getLinearIndexArraySortedByGrayLevel() {
        int k = ((IntegerType)this.max(this.image)).getInteger();
        int[] c = new int[k + 1];
        int[] idx = new int[this.n];
        int p = 0;
        for (p = 0; p < this.n; ++p) {
            int n = this.getIntegerValueAtLinearIndex(p);
            c[n] = c[n] + 1;
        }
        for (int i = 1; i <= k; ++i) {
            c[i] = c[i] + c[i - 1];
        }
        p = this.n - 1;
        while (p >= 0) {
            int level = this.getIntegerValueAtLinearIndex(p);
            idx[this.n - c[level]] = p--;
            int n = level;
            c[n] = c[n] - 1;
        }
        return idx;
    }

    public static final int positionToIndex(int[] position, int[] dimensions) {
        int maxDim = dimensions.length - 1;
        int i = position[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + position[d];
        }
        return i;
    }

    public static final void indexToPosition(int index, int[] dimensions, int[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }
}

