/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.Type;

public class OutOfBoundsStrategyPeriodic<T extends Type<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> circleCursor;
    final T type;
    final T circleType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] circledPosition;

    public OutOfBoundsStrategyPeriodic(LocalizableCursor<T> parentCursor) {
        super(parentCursor);
        this.parentCursor = parentCursor;
        this.circleCursor = parentCursor.getImage().createLocalizableByDimCursor();
        this.circleType = this.circleCursor.getType();
        this.type = this.circleType.createVariable();
        this.numDimensions = parentCursor.getImage().getNumDimensions();
        this.dimension = parentCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.circledPosition = new int[this.numDimensions];
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        this.parentCursor.getPosition(this.position);
        OutOfBoundsStrategyPeriodic.getCircleCoordinate(this.position, this.circledPosition, this.dimension, this.numDimensions);
        this.circleCursor.setPosition(this.circledPosition);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOunds(int steps, int dim) {
        int oldPos = this.circleCursor.getPosition(dim);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(oldPos + steps, this.dimension[dim]) - oldPos, dim);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOundsFwd(int dim) {
        int oldPos = this.circleCursor.getPosition(dim);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(oldPos + 1, this.dimension[dim]) - oldPos, dim);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOundsBck(int dim) {
        int oldPos = this.circleCursor.getPosition(dim);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(oldPos - 1, this.dimension[dim]) - oldPos, dim);
        this.type.set(this.circleType);
    }

    @Override
    public void initOutOfBOunds() {
        this.parentCursor.getPosition(this.position);
        OutOfBoundsStrategyPeriodic.getCircleCoordinate(this.position, this.circledPosition, this.dimension, this.numDimensions);
        this.circleCursor.setPosition(this.circledPosition);
        this.type.set(this.circleType);
    }

    private static final int getCircleCoordinateDim(int pos, int dim) {
        if (pos > -1) {
            return pos % dim;
        }
        return dim - 1 + (pos + 1) % dim;
    }

    private static final void getCircleCoordinate(int[] position, int[] circledPosition, int[] dimensions, int numDimensions) {
        for (int d = 0; d < numDimensions; ++d) {
            circledPosition[d] = OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(position[d], dimensions[d]);
        }
    }

    @Override
    public void close() {
        this.circleCursor.close();
    }
}

