/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.beans;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.jhotdraw.beans.WeakPropertyChangeListener;

public class AbstractBean
implements Serializable,
Cloneable {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        for (PropertyChangeListener l : this.propertySupport.getPropertyChangeListeners()) {
            WeakPropertyChangeListener wl;
            PropertyChangeListener target;
            if (l == listener) {
                this.propertySupport.removePropertyChangeListener(l);
                break;
            }
            if (!(l instanceof WeakPropertyChangeListener) || (target = (wl = (WeakPropertyChangeListener)l).getTarget()) != listener) continue;
            this.propertySupport.removePropertyChangeListener(l);
            break;
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        for (PropertyChangeListener l : this.propertySupport.getPropertyChangeListeners(propertyName)) {
            WeakPropertyChangeListener wl;
            PropertyChangeListener target;
            if (l == listener) {
                this.propertySupport.removePropertyChangeListener(propertyName, l);
                break;
            }
            if (!(l instanceof WeakPropertyChangeListener) || (target = (wl = (WeakPropertyChangeListener)l).getTarget()) != listener) continue;
            this.propertySupport.removePropertyChangeListener(propertyName, l);
            break;
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public AbstractBean clone() {
        AbstractBean that;
        try {
            that = (AbstractBean)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.propertySupport = new PropertyChangeSupport(that);
        return that;
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertySupport.getPropertyChangeListeners();
    }
}

