/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Geom {
    public static final int OUT_TOP = 2;
    public static final int OUT_BOTTOM = 8;
    public static final int OUT_LEFT = 1;
    public static final int OUT_RIGHT = 4;

    private Geom() {
    }

    public static boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py) {
        return Geom.lineContainsPoint(x1, y1, x2, y2, px, py, 3.0);
    }

    public static boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py, double tolerance) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(Math.max(2, (int)Math.ceil(tolerance)), Math.max(2, (int)Math.ceil(tolerance)));
        if (!r.contains(px, py)) {
            return false;
        }
        if (x1 == x2) {
            return (double)Math.abs(px - x1) <= tolerance;
        }
        if (y1 == y2) {
            return (double)Math.abs(py - y1) <= tolerance;
        }
        double a = (double)(y1 - y2) / (double)(x1 - x2);
        double b = (double)y1 - a * (double)x1;
        double x = ((double)py - b) / a;
        double y = a * (double)px + b;
        return Math.min(Math.abs(x - (double)px), Math.abs(y - (double)py)) <= tolerance;
    }

    public static boolean lineContainsPoint(double x1, double y1, double x2, double y2, double px, double py, double tolerance) {
        Rectangle2D.Double r = new Rectangle2D.Double(x1, y1, 0.0, 0.0);
        r.add(x2, y2);
        double grow = Math.max(2, (int)Math.ceil(tolerance));
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        if (!r.contains(px, py)) {
            return false;
        }
        if (x1 == x2) {
            return Math.abs(px - x1) <= tolerance;
        }
        if (y1 == y2) {
            return Math.abs(py - y1) <= tolerance;
        }
        double a = (y1 - y2) / (x1 - x2);
        double b = y1 - a * x1;
        double x = (py - b) / a;
        double y = a * px + b;
        return Math.min(Math.abs(x - px), Math.abs(y - py)) <= tolerance;
    }

    public static int direction(int x1, int y1, int x2, int y2) {
        int direction = 0;
        int vy = y2 - y1;
        int vx = x2 - x1;
        direction = vy < vx && vx > -vy ? 4 : (vy > vx && vy > -vx ? 2 : (vx < vy && vx < -vy ? 1 : 8));
        return direction;
    }

    public static int direction(double x1, double y1, double x2, double y2) {
        int direction = 0;
        double vy = y2 - y1;
        double vx = x2 - x1;
        direction = vy < vx && vx > -vy ? 4 : (vy > vx && vy > -vx ? 2 : (vx < vy && vx < -vy ? 1 : 8));
        return direction;
    }

    public static int outcode(Rectangle r1, Rectangle r2) {
        int outcode = 0;
        if (r2.x > r1.x + r1.width) {
            outcode = 4;
        } else if (r2.x + r2.width < r1.x) {
            outcode = 1;
        }
        if (r2.y > r1.y + r1.height) {
            outcode |= 8;
        } else if (r2.y + r2.height < r1.y) {
            outcode |= 2;
        }
        return outcode;
    }

    public static int outcode(Rectangle2D.Double r1, Rectangle2D.Double r2) {
        int outcode = 0;
        if (r2.x > r1.x + r1.width) {
            outcode = 4;
        } else if (r2.x + r2.width < r1.x) {
            outcode = 1;
        }
        if (r2.y > r1.y + r1.height) {
            outcode |= 8;
        } else if (r2.y + r2.height < r1.y) {
            outcode |= 2;
        }
        return outcode;
    }

    public static Point south(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height);
    }

    public static Point2D.Double south(Rectangle2D.Double r) {
        return new Point2D.Double(r.x + r.width / 2.0, r.y + r.height);
    }

    public static Point center(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public static Point2D.Double center(Rectangle2D.Double r) {
        return new Point2D.Double(r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    public static Point2D.Double chop(Shape shape, Point2D.Double p) {
        Rectangle2D bounds = shape.getBounds2D();
        Point2D.Double ctr = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        double cx = -1.0;
        double cy = -1.0;
        double len = Double.MAX_VALUE;
        PathIterator i = shape.getPathIterator(new AffineTransform(), 1.0);
        double[] coords = new double[6];
        double prevX = coords[0];
        double prevY = coords[1];
        double moveToX = prevX;
        double moveToY = prevY;
        i.next();
        while (!i.isDone()) {
            double cl;
            switch (i.currentSegment(coords)) {
                case 0: {
                    moveToX = coords[0];
                    moveToY = coords[1];
                    break;
                }
                case 4: {
                    coords[0] = moveToX;
                    coords[1] = moveToY;
                }
            }
            Point2D.Double chop = Geom.intersect(prevX, prevY, coords[0], coords[1], p.x, p.y, ctr.x, ctr.y);
            if (chop != null && (cl = Geom.length2(chop.x, chop.y, p.x, p.y)) < len) {
                len = cl;
                cx = chop.x;
                cy = chop.y;
            }
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        if (len == Double.MAX_VALUE) {
            i = shape.getPathIterator(new AffineTransform(), 1.0);
            while (!i.isDone()) {
                i.currentSegment(coords);
                double l = Geom.length2(ctr.x, ctr.y, coords[0], coords[1]);
                if (l < len) {
                    len = l;
                    cx = coords[0];
                    cy = coords[1];
                }
                i.next();
            }
        }
        return new Point2D.Double(cx, cy);
    }

    public static Point west(Rectangle r) {
        return new Point(r.x, r.y + r.height / 2);
    }

    public static Point2D.Double west(Rectangle2D.Double r) {
        return new Point2D.Double(r.x, r.y + r.height / 2.0);
    }

    public static Point east(Rectangle r) {
        return new Point(r.x + r.width, r.y + r.height / 2);
    }

    public static Point2D.Double east(Rectangle2D.Double r) {
        return new Point2D.Double(r.x + r.width, r.y + r.height / 2.0);
    }

    public static Point north(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y);
    }

    public static Point2D.Double north(Rectangle2D.Double r) {
        return new Point2D.Double(r.x + r.width / 2.0, r.y);
    }

    public static int range(int min, int max, int value) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static double range(double min, double max, double value) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static long length2(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static long length(int x1, int y1, int x2, int y2) {
        return (long)Math.sqrt(Geom.length2(x1, y1, x2, y2));
    }

    public static double length2(double x1, double y1, double x2, double y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static double length(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Geom.length2(x1, y1, x2, y2));
    }

    public static double length(Point2D.Double p1, Point2D.Double p2) {
        return Math.sqrt(Geom.length2(p1.x, p1.y, p2.x, p2.y));
    }

    public static Point2D.Double cap(Point2D.Double p1, Point2D.Double p2, double radius) {
        double angle = 1.5707963267948966 - Math.atan2(p2.x - p1.x, p2.y - p1.y);
        Point2D.Double p3 = new Point2D.Double(p2.x + radius * Math.cos(angle), p2.y + radius * Math.sin(angle));
        return p3;
    }

    public static double pointToAngle(Rectangle r, Point p) {
        int px = p.x - (r.x + r.width / 2);
        int py = p.y - (r.y + r.height / 2);
        return Math.atan2(py * r.width, px * r.height);
    }

    public static double pointToAngle(Rectangle2D.Double r, Point2D.Double p) {
        double px = p.x - (r.x + r.width / 2.0);
        double py = p.y - (r.y + r.height / 2.0);
        return Math.atan2(py * r.width, px * r.height);
    }

    public static double angle(double x1, double y1, double x2, double y2) {
        return Math.atan2(y2 - y1, x2 - x1);
    }

    public static Point angleToPoint(Rectangle r, double angle) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        double e = 1.0E-4;
        int x = 0;
        int y = 0;
        if (Math.abs(si) > e) {
            x = (int)((1.0 + co / Math.abs(si)) / 2.0 * (double)r.width);
            x = Geom.range(0, r.width, x);
        } else if (co >= 0.0) {
            x = r.width;
        }
        if (Math.abs(co) > e) {
            y = (int)((1.0 + si / Math.abs(co)) / 2.0 * (double)r.height);
            y = Geom.range(0, r.height, y);
        } else if (si >= 0.0) {
            y = r.height;
        }
        return new Point(r.x + x, r.y + y);
    }

    public static Point2D.Double angleToPoint(Rectangle2D.Double r, double angle) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        double e = 1.0E-4;
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(si) > e) {
            x = (1.0 + co / Math.abs(si)) / 2.0 * r.width;
            x = Geom.range(0.0, r.width, x);
        } else if (co >= 0.0) {
            x = r.width;
        }
        if (Math.abs(co) > e) {
            y = (1.0 + si / Math.abs(co)) / 2.0 * r.height;
            y = Geom.range(0.0, r.height, y);
        } else if (si >= 0.0) {
            y = r.height;
        }
        return new Point2D.Double(r.x + x, r.y + y);
    }

    public static Point polarToPoint(double angle, double fx, double fy) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        return new Point((int)(fx * co + 0.5), (int)(fy * si + 0.5));
    }

    public static Point2D.Double polarToPoint2D(double angle, double fx, double fy) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        return new Point2D.Double(fx * co + 0.5, fy * si + 0.5);
    }

    public static Point ovalAngleToPoint(Rectangle r, double angle) {
        Point center = Geom.center(r);
        Point p = Geom.polarToPoint(angle, r.width / 2, r.height / 2);
        return new Point(center.x + p.x, center.y + p.y);
    }

    public static Point2D.Double ovalAngleToPoint(Rectangle2D.Double r, double angle) {
        Point2D.Double center = Geom.center(r);
        Point2D.Double p = Geom.polarToPoint2D(angle, r.width / 2.0, r.height / 2.0);
        return new Point2D.Double(center.x + p.x, center.y + p.y);
    }

    @Nullable
    public static Point intersect(int xa, int ya, int xb, int yb, int xc, int yc, int xd, int yd) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point(xb, yb);
                }
                return new Point(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            int px = (int)((double)xa + (double)(xb - xa) * r);
            int py = (int)((double)ya + (double)(yb - ya) * r);
            return new Point(px, py);
        }
        return null;
    }

    @Nullable
    public static Point2D.Double intersect(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point2D.Double(xb, yb);
                }
                return new Point2D.Double(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            double px = xa + (xb - xa) * r;
            double py = ya + (yb - ya) * r;
            return new Point2D.Double(px, py);
        }
        return null;
    }

    @Nullable
    public static Point2D.Double intersect(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd, double limit) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point2D.Double(xb, yb);
                }
                return new Point2D.Double(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            double px = xa + (xb - xa) * r;
            double py = ya + (yb - ya) * r;
            return new Point2D.Double(px, py);
        }
        double px = xa + (xb - xa) * r;
        double py = ya + (yb - ya) * r;
        if (Geom.length(xa, ya, px, py) <= limit || Geom.length(xb, yb, px, py) <= limit || Geom.length(xc, yc, px, py) <= limit || Geom.length(xd, yd, px, py) <= limit) {
            return new Point2D.Double(px, py);
        }
        return null;
    }

    public static double distanceFromLine(int xa, int ya, int xb, int yb, int xc, int yc) {
        int xdiff = xb - xa;
        int ydiff = yb - ya;
        long l2 = xdiff * xdiff + ydiff * ydiff;
        if (l2 == 0L) {
            return Geom.length(xa, ya, xc, yc);
        }
        double rnum = (ya - yc) * (ya - yb) - (xa - xc) * (xb - xa);
        double r = rnum / (double)l2;
        if (r < 0.0 || r > 1.0) {
            return Double.MAX_VALUE;
        }
        double xi = (double)xa + r * (double)xdiff;
        double yi = (double)ya + r * (double)ydiff;
        double xd = (double)xc - xi;
        double yd = (double)yc - yi;
        return Math.sqrt(xd * xd + yd * yd);
    }

    public static void grow(Rectangle2D.Double r, double h, double v) {
        r.x -= h;
        r.y -= v;
        r.width += h * 2.0;
        r.height += v * 2.0;
    }

    public static boolean contains(Rectangle2D.Double r1, Rectangle2D.Double r2) {
        return r2.x >= r1.x && r2.y >= r1.y && r2.x + Math.max(0.0, r2.width) <= r1.x + Math.max(0.0, r1.width) && r2.y + Math.max(0.0, r2.height) <= r1.y + Math.max(0.0, r1.height);
    }

    public static boolean contains(Rectangle2D r1, Rectangle2D r2) {
        return r2.getX() >= r1.getX() && r2.getY() >= r1.getY() && r2.getX() + Math.max(0.0, r2.getWidth()) <= r1.getX() + Math.max(0.0, r1.getWidth()) && r2.getY() + Math.max(0.0, r2.getHeight()) <= r1.getY() + Math.max(0.0, r1.getHeight());
    }
}

