/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette.colorchooser;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import org.jhotdraw.color.HSBColorSpace;
import org.jhotdraw.gui.plaf.palette.PaletteListUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PalettePanelUI;
import org.jhotdraw.gui.plaf.palette.colorchooser.ColorIcon;
import org.jhotdraw.util.ResourceBundleUtil;

public class PaletteSwatchesChooser
extends AbstractColorChooserPanel {
    private int updateRecursion = 0;
    private static final List<ColorIcon> HSB_COLORS;
    private static final int HSB_COLORS_COLUMN_COUNT = 12;
    private static final List<ColorIcon> HSB_COLORS_AS_RGB;
    private static final int HSB_COLORS_AS_RGB_COLUMN_COUNT = 12;
    private JList jList;

    private void initComponents() {
        this.jList = new JList();
        this.setBorder(BorderFactory.createEmptyBorder(4, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        this.jList.setSelectionMode(0);
        this.jList.setLayoutOrientation(2);
        this.add((Component)this.jList, new GridBagConstraints());
    }

    @Override
    public void updateChooser() {
        if (this.updateRecursion++ == 0) {
            ListModel m = this.jList.getModel();
            Color mc = this.getColorFromModel();
            if (mc != null) {
                int ma = mc.getAlpha();
                int mr = mc.getRed();
                int mg = mc.getGreen();
                int mb = mc.getBlue();
                int closestSquaredDistance = Integer.MAX_VALUE;
                int closestIndex = -1;
                int n = m.getSize();
                for (int i = 0; i < n; ++i) {
                    ColorIcon item = (ColorIcon)m.getElementAt(i);
                    Color ic = item.getColor();
                    int squaredDistance = ic == null || ic.getAlpha() != ma ? Integer.MAX_VALUE : (mr - ic.getRed()) * (mr - ic.getRed()) + (mg - ic.getGreen()) * (mg - ic.getGreen()) + (mb - ic.getBlue()) * (mb - ic.getBlue());
                    if (squaredDistance > closestSquaredDistance) continue;
                    closestSquaredDistance = squaredDistance;
                    closestIndex = i;
                    if (squaredDistance == 0) break;
                }
                if (closestIndex == -1) {
                    this.jList.clearSelection();
                } else {
                    this.jList.setSelectedIndex(closestIndex);
                }
            }
        }
        --this.updateRecursion;
    }

    @Override
    public String getDisplayName() {
        return PaletteLookAndFeel.getInstance().getString("ColorChooser.colorSwatches");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return PaletteLookAndFeel.getInstance().getIcon("ColorChooser.colorSwatchesIcon");
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return this.getSmallDisplayIcon();
    }

    @Override
    protected void buildChooser() {
        this.initComponents();
        this.setUI(PalettePanelUI.createUI(this));
        this.jList.setUI((ListUI)PaletteListUI.createUI(this.jList));
        this.jList.setListData(HSB_COLORS_AS_RGB.toArray());
        this.jList.setVisibleRowCount(HSB_COLORS_AS_RGB.size() / 12);
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PaletteSwatchesChooser.this.updateRecursion++ == 0) {
                    ColorIcon item = (ColorIcon)PaletteSwatchesChooser.this.jList.getSelectedValue();
                    PaletteSwatchesChooser.this.setColorToModel(item == null ? null : item.getColor());
                }
                PaletteSwatchesChooser.this.updateRecursion--;
            }
        });
    }

    public void setColorToModel(@Nullable Color color) {
        this.getColorSelectionModel().setSelectedColor(color);
    }

    static {
        Color c;
        int h;
        HSBColorSpace hsbCS = HSBColorSpace.getInstance();
        LinkedList<ColorIcon> m = new LinkedList<ColorIcon>();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.gui.Labels");
        m.add(new ColorIcon(new Color(0, true), labels.getToolTipTextProperty("ColorChooser.colorSwatch.noColor")));
        for (int s = 2; s <= 8; s += 2) {
            for (h = 0; h < 12; ++h) {
                c = new Color(hsbCS, new float[]{(float)h / 12.0f, (float)s * 0.1f, 1.0f}, 1.0f);
                m.add(new ColorIcon(c, labels.getFormatted("ColorChooser.colorSwatch.hsbComponents.toolTipText", h * 360 / 12, s * 10, 100)));
            }
        }
        for (int b = 10; b >= 2; b -= 2) {
            for (h = 0; h < 12; ++h) {
                c = new Color(hsbCS, new float[]{(float)h / 12.0f, 1.0f, (float)b * 0.1f}, 1.0f);
                m.add(new ColorIcon(new Color(hsbCS, new float[]{(float)h / 12.0f, 1.0f, (float)b * 0.1f}, 1.0f), labels.getFormatted("ColorChooser.colorSwatch.hsbComponents.toolTipText", h * 360 / 12, 100, b * 10)));
            }
        }
        HSB_COLORS = Collections.unmodifiableList(m);
        m = new LinkedList();
        for (ColorIcon ci : HSB_COLORS) {
            if (ci.getColor() == null) {
                m.add(new ColorIcon(new Color(0, true), labels.getToolTipTextProperty("ColorChooser.colorSwatch.noColor")));
                continue;
            }
            c = ci.getColor();
            m.add(new ColorIcon(c, labels.getFormatted("ColorChooser.colorSwatch.rgbComponents.toolTipText", c.getRed(), c.getGreen(), c.getBlue())));
        }
        HSB_COLORS_AS_RGB = Collections.unmodifiableList(m);
    }
}

