/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.cache.CacheControl;
import bdv.gui.BigWarpViewerOptions;
import bdv.img.WarpedSource;
import bdv.util.Affine3DHelpers;
import bdv.util.Prefs;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.BigWarpDragOverlay;
import bdv.viewer.BigWarpOverlay;
import bdv.viewer.BigWarpViewerSettings;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.RotationAnimator;
import bdv.viewer.animate.SimilarityTransformAnimator3D;
import bdv.viewer.overlay.BigWarpMaskSphereOverlay;
import bigwarp.BigWarpData;
import bigwarp.source.SourceInfo;
import bigwarp.util.Rotation2DHelpers;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.Translation3D;

public class BigWarpViewerPanel
extends ViewerPanel {
    private static final long serialVersionUID = 7706602964307210070L;
    public static final int MOVING_GROUP_INDEX = 0;
    public static final int TARGET_GROUP_INDEX = 1;
    protected final BigWarpData<?> bwData;
    protected BigWarpViewerSettings viewerSettings;
    protected BigWarpOverlay overlay;
    protected BigWarpDragOverlay dragOverlay;
    protected BigWarpMaskSphereOverlay maskOverlay;
    protected boolean isMoving;
    protected boolean updateOnDrag;
    protected boolean transformEnabled = true;
    protected int ndims;
    protected boolean boxOverlayVisible = true;
    protected boolean textOverlayVisible = true;
    protected ArrayList<AffineTransform3D> orthoTransforms;
    public static final double R2o2 = Math.sqrt(2.0) / 2.0;
    ViewerOptions options;

    public BigWarpViewerPanel(BigWarpData bwData, BigWarpViewerSettings viewerSettings, CacheControl cache, boolean isMoving) {
        this(bwData, viewerSettings, cache, BigWarpViewerOptions.options(), isMoving);
    }

    public BigWarpViewerPanel(BigWarpData bwData, BigWarpViewerSettings viewerSettings, CacheControl cache, BigWarpViewerOptions optional, boolean isMoving) {
        super(bwData.sources, 1, cache, optional.getViewerOptions(isMoving));
        this.bwData = bwData;
        this.viewerSettings = viewerSettings;
        this.isMoving = isMoving;
        this.updateOnDrag = !isMoving;
        this.getDisplay().overlays().add(g -> {
            if (null != this.overlay) {
                this.overlay.setViewerState((ViewerState)this.state());
                this.overlay.paint((Graphics2D)g);
            }
            if (this.dragOverlay != null) {
                this.dragOverlay.paint((Graphics2D)g);
            }
        });
    }

    public ViewerOptions.Values getOptionValues() {
        return this.options.values;
    }

    public void precomputeRotations2d(AffineTransform3D initialViewTransform) {
        this.orthoTransforms = new ArrayList();
        AffineTransform3D rot = new AffineTransform3D();
        rot.rotate(2, -1.5707963267948966);
        AffineTransform3D xfm = initialViewTransform;
        this.orthoTransforms.add(xfm);
        for (int i = 1; i < 4; ++i) {
            AffineTransform3D newXfm = xfm.copy();
            newXfm.rotate(2, -1.5707963267948966);
            this.orthoTransforms.add(newXfm);
            xfm = newXfm;
        }
    }

    public void setHoveredIndex(int index) {
        if (index != this.overlay.getHoveredIndex()) {
            this.overlay.setHoveredIndex(index);
            if (null != this.overlay) {
                this.overlay.setViewerState((ViewerState)this.state());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int updateGrouping() {
        SynchronizedViewerState state;
        SynchronizedViewerState synchronizedViewerState = state = this.state();
        synchronized (synchronizedViewerState) {
            ArrayList moving = new ArrayList();
            ArrayList target = new ArrayList();
            int idx = 0;
            for (SourceInfo sourceInfo : this.bwData.sourceInfos.values()) {
                if (sourceInfo.isMoving()) {
                    moving.add(state.getSources().get(idx));
                } else {
                    target.add(state.getSources().get(idx));
                }
                ++idx;
            }
            state.clearGroups();
            SourceGroup movingGroup = new SourceGroup();
            state.addGroup(movingGroup);
            state.setGroupName(movingGroup, "moving images");
            state.addSourcesToGroup(moving, movingGroup);
            SourceGroup targetGroup = new SourceGroup();
            state.addGroup(targetGroup);
            state.setGroupName(targetGroup, "fixed images");
            state.addSourcesToGroup(target, targetGroup);
            state.setGroupActive(movingGroup, true);
            state.setGroupActive(targetGroup, true);
            if (moving.size() > 1 || target.size() > 1) {
                state.setDisplayMode(state.getDisplayMode().withGrouping(true));
            }
            state.setCurrentGroup(this.isMoving ? movingGroup : targetGroup);
            return state.getGroups().size();
        }
    }

    public boolean isInFixedImageSpace() {
        if (this.bwData.numMovingSources() < 1) {
            return true;
        }
        return !this.isMoving || ((WarpedSource)this.bwData.getMovingSource(0).getSpimSource()).isTransformed();
    }

    public boolean doUpdateOnDrag() {
        return this.updateOnDrag;
    }

    public void setUpdateOnDrag(boolean updateOnDrag) {
        this.updateOnDrag = updateOnDrag;
    }

    public void toggleUpdateOnDrag() {
        this.setUpdateOnDrag(!this.updateOnDrag);
        if (this.updateOnDrag) {
            this.showMessage("Update on drag");
        } else {
            this.showMessage("No update on drag");
        }
    }

    public void addOverlay(BigWarpOverlay overlay) {
        this.overlay = overlay;
    }

    public BigWarpOverlay getOverlay() {
        return this.overlay;
    }

    public void addDragOverlay(BigWarpDragOverlay dragOverlay) {
        this.dragOverlay = dragOverlay;
    }

    public void addOverlay(OverlayRenderer overlay) {
        super.getDisplay().overlays().add((Object)overlay);
    }

    public BigWarpDragOverlay getDragOverlay() {
        return this.dragOverlay;
    }

    public BigWarpMaskSphereOverlay getMaskOverlay() {
        return this.maskOverlay;
    }

    public void setMaskOverlay(BigWarpMaskSphereOverlay maskOverlay) {
        this.maskOverlay = maskOverlay;
        this.addOverlay(maskOverlay);
    }

    public boolean getIsMoving() {
        return this.isMoving;
    }

    public void setNumDim(int ndim) {
        this.ndims = ndim;
    }

    public BigWarpViewerSettings getSettings() {
        return this.viewerSettings;
    }

    public void displayViewerTransforms() {
        System.out.println(this.state().getViewerTransform());
    }

    public synchronized void rotateView2d(boolean isClockwise) {
        double centerY;
        double centerX;
        if (!this.transformEnabled) {
            return;
        }
        AffineTransform3D transform = this.state().getViewerTransform();
        if (this.mouseCoordinates.isMouseInsidePanel()) {
            centerX = this.mouseCoordinates.getX();
            centerY = this.mouseCoordinates.getY();
        } else {
            centerY = (double)this.getHeight() / 2.0;
            centerX = (double)this.getWidth() / 2.0;
        }
        AffineTransform3D newTransform = null;
        for (int i = 0; i < 4; ++i) {
            try {
                newTransform = Rotation2DHelpers.targetViewerTransform2d(transform, isClockwise);
                break;
            }
            catch (Exception e) {
                if (isClockwise) {
                    transform.rotate(2, -0.1);
                    continue;
                }
                transform.rotate(2, 0.1);
                continue;
            }
        }
        double[] qNew = new double[4];
        Affine3DHelpers.extractRotation((AffineTransform3D)newTransform, (double[])qNew);
        this.setTransformAnimator((AbstractTransformAnimator)new RotationAnimator(transform, centerX, centerY, qNew, 300L));
    }

    public synchronized void align(AbstractViewerPanel.AlignPlane plane) {
        if (!this.transformEnabled) {
            return;
        }
        super.align(plane);
    }

    public synchronized void animateTransformation(AffineTransform3D destinationXfm, int millis) {
        double centerY;
        double centerX;
        if (!this.transformEnabled) {
            return;
        }
        AffineTransform3D startXfm = this.state().getViewerTransform();
        if (this.mouseCoordinates.isMouseInsidePanel()) {
            centerX = this.mouseCoordinates.getX();
            centerY = this.mouseCoordinates.getY();
        } else {
            centerY = (double)this.getHeight() / 2.0;
            centerX = (double)this.getWidth() / 2.0;
        }
        if (this.ndims == 2) {
            double[] tmp = new double[3];
            startXfm.applyInverse(tmp, tmp);
            double zstart = tmp[2];
            Arrays.fill(tmp, 0.0);
            destinationXfm.applyInverse(tmp, tmp);
            Translation3D t = new Translation3D(0.0, 0.0, tmp[2] - zstart);
            destinationXfm.concatenate((AffineGet)t);
        }
        this.setTransformAnimator(new SimilarityTransformAnimator3D(startXfm, destinationXfm, centerX, centerY, millis / 2));
    }

    public void animateTransformation(AffineTransform3D destinationXfm) {
        this.animateTransformation(destinationXfm, 300);
    }

    public synchronized void setTransformEnabled(boolean enabled) {
        this.transformEnabled = enabled;
    }

    public boolean getTransformEnabled() {
        return this.transformEnabled;
    }

    public void drawOverlays(Graphics g) {
        boolean prefsShowTextOverlay = Prefs.showTextOverlay();
        boolean prefsShowMultibox = Prefs.showMultibox();
        super.drawOverlays(g);
    }
}

